/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.core;

import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BasicExecutionOccurrence;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.SDViewPref;

public abstract class BaseMessage
extends GraphNode {
    protected Lifeline fStartLifeline = null;
    protected Lifeline fEndLifeline = null;
    protected boolean fVisible = true;

    @Override
    public int getX() {
        return this.getX(false);
    }

    @Override
    public int getY() {
        if (this.fStartLifeline != null && this.fEndLifeline != null) {
            return this.fEndLifeline.getY() + this.fEndLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.fEndEventOccurrence;
        }
        if (this.fStartLifeline != null) {
            return this.fStartLifeline.getY() + this.fStartLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.fEndEventOccurrence;
        }
        if (this.fEndLifeline != null) {
            return this.fEndLifeline.getY() + this.fEndLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.fEndEventOccurrence;
        }
        return 0;
    }

    @Override
    public int getWidth() {
        return this.getWidth(false);
    }

    @Override
    public int getHeight() {
        return 0;
    }

    protected int getX(boolean quick) {
        int x = 0;
        int activationWidth = 4;
        if (this.fStartLifeline != null && this.fEndLifeline != null) {
            x = this.fStartLifeline.getX() + Metrics.getLifelineWidth() / 2;
        } else {
            if (this.fStartLifeline != null) {
                x = this.fStartLifeline.getX() + Metrics.getLifelineWidth() / 2;
            }
            if (this.fEndLifeline != null) {
                x = this.fEndLifeline.getX() - 22;
            }
        }
        if (quick) {
            return x;
        }
        if (this.fStartLifeline != null && this.fEndLifeline != null && this.fStartLifeline.getX() > this.fEndLifeline.getX()) {
            activationWidth = -activationWidth;
        }
        if (this.isMessageStartInActivation(this.fEndEventOccurrence)) {
            x += activationWidth;
        }
        return x;
    }

    protected int getWidth(boolean quick) {
        int width = 0;
        int activationWidth = 4;
        if (this.fStartLifeline != null && this.fEndLifeline != null) {
            width = this.fStartLifeline == this.fEndLifeline ? 28 : this.fEndLifeline.getX() + Metrics.getLifelineWidth() / 2 - this.getX(true);
        } else {
            if (this.fStartLifeline != null) {
                width = Metrics.swimmingLaneWidth() / 2;
            }
            if (this.fEndLifeline != null) {
                width = Metrics.swimmingLaneWidth() / 2;
            }
        }
        if (quick) {
            return width;
        }
        if (this.fStartLifeline != null && this.fEndLifeline != null && this.fStartLifeline.getX() > this.fEndLifeline.getX()) {
            activationWidth = -activationWidth;
        }
        if (this.isMessageStartInActivation(this.fEndEventOccurrence)) {
            width -= activationWidth;
        }
        if (this.isMessageEndInActivation(this.fEndEventOccurrence)) {
            width -= activationWidth;
        }
        return width;
    }

    @Override
    public boolean isVisible(int x, int y, int width, int height) {
        if (this.fEndLifeline != null && this.fEndLifeline.isVisible(x, y, width, height) || this.fStartLifeline != null && this.fStartLifeline.isVisible(x, y, width, height)) {
            return true;
        }
        if (this.fEndLifeline != null && !this.fEndLifeline.isVisible(x, y, width, height) && this.fStartLifeline != null && !this.fStartLifeline.isVisible(x, y, width, height)) {
            if (this.fEndLifeline.getX() > x + width && this.fStartLifeline.getX() < x) {
                return true;
            }
            if (this.fStartLifeline.getX() > x + width && this.fEndLifeline.getX() < x) {
                return true;
            }
        }
        return false;
    }

    public void setVisible(boolean value) {
        this.fVisible = value;
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    public void setStartLifeline(Lifeline lifeline) {
        this.fStartLifeline = lifeline;
    }

    public Lifeline getStartLifeline() {
        return this.fStartLifeline;
    }

    public Lifeline getEndLifeline() {
        return this.fEndLifeline;
    }

    public void setEndLifeline(Lifeline lifeline) {
        this.fEndLifeline = lifeline;
    }

    protected void setEventOccurrence(int occurrence) {
        this.fEndEventOccurrence = occurrence;
    }

    public int getEventOccurrence() {
        return this.fEndEventOccurrence;
    }

    protected boolean isMessageStartInActivation(int event) {
        boolean inActivation = false;
        if (this.fStartLifeline != null && this.fStartLifeline.getExecutions() != null) {
            int thisY = this.getY();
            int i = 0;
            while (i < this.fStartLifeline.getExecutions().size()) {
                BasicExecutionOccurrence toDraw = (BasicExecutionOccurrence)this.fStartLifeline.getExecutions().get(i);
                if (event >= toDraw.fStartEventOccurrence && event <= toDraw.fEndEventOccurrence) {
                    inActivation = true;
                }
                if (toDraw.getY() > thisY) break;
                ++i;
            }
        }
        return inActivation;
    }

    protected boolean isMessageEndInActivation(int event) {
        boolean inActivation = false;
        if (this.fEndLifeline != null && this.fEndLifeline.getExecutions() != null) {
            int i = 0;
            while (i < this.fEndLifeline.getExecutions().size()) {
                BasicExecutionOccurrence toDraw = (BasicExecutionOccurrence)this.fEndLifeline.getExecutions().get(i);
                if (event >= toDraw.fStartEventOccurrence && event <= toDraw.fEndEventOccurrence) {
                    inActivation = true;
                }
                if (toDraw.getY() > this.getY()) break;
                ++i;
            }
        }
        return inActivation;
    }

    @Override
    public boolean contains(int xValue, int yValue) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        int tempHeight = 10 + Metrics.getMessageFontHeigth();
        if (this.fStartLifeline == this.fEndLifeline) {
            if (this.getName().length() * Metrics.getAverageCharWidth() > Metrics.swimmingLaneWidth() - 4 + -20 ? Frame.contains(x + 20 + 10, y, Metrics.swimmingLaneWidth() - 4 + -20, Metrics.getMessageFontHeigth(), xValue, yValue) : Frame.contains(x + 20 + 10, y, this.getName().length() * Metrics.getAverageCharWidth(), Metrics.getMessageFontHeigth(), xValue, yValue)) {
                return true;
            }
            if (Frame.contains(x, y - 15, 10, 30, xValue, yValue)) {
                return true;
            }
            if (Frame.contains(x + 20 - 15, y, 30, height + 10, xValue, yValue)) {
                return true;
            }
            return Frame.contains(x, y + height - 15 + 10, 10, 30, xValue, yValue);
        }
        return Frame.contains(x, y - tempHeight, width, tempHeight, xValue, yValue);
    }

    protected void drawMessage(IGC context) {
        int fH = 0;
        int fW = 0;
        int fY = 0;
        int fX = 0;
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        SDViewPref pref = SDViewPref.getInstance();
        if ((this.fStartLifeline == null || this.fEndLifeline == null) && this.fStartLifeline != this.fEndLifeline) {
            IColor temp = context.getForeground();
            context.setForeground(pref.getFontColor(this.fPrefId));
            context.drawTextTruncatedCentred(this.getName(), x, y - Metrics.getMessageFontHeigth() - 20, width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            context.setForeground(temp);
            int margin = 0;
            if (this.fEndLifeline == null) {
                margin = 5;
            }
            context.drawLine(x, y, x + width, y + height);
            Double xt = Math.cos(0.75) * 7.0;
            Double yt = Math.sin(0.75) * 7.0;
            if (context.getLineStyle() == context.getLineSolidStyle()) {
                IColor backcolor = context.getBackground();
                context.setBackground(context.getForeground());
                int[] points = new int[]{x + width - margin, y + height, x + width - xt.intValue() - margin, y + height - yt.intValue(), x + width - xt.intValue() - margin, y + height + yt.intValue(), x + width - margin, y + height};
                context.fillPolygon(points);
                context.drawPolygon(points);
                context.setBackground(backcolor);
            } else {
                int currentStyle = context.getLineStyle();
                int currentWidth = context.getLineWidth();
                context.setLineWidth(currentWidth + 2);
                context.setLineStyle(context.getLineSolidStyle());
                context.drawLine(x + width - xt.intValue() - margin, y + height - yt.intValue(), x + width - margin, y + height);
                context.drawLine(x + width - xt.intValue() - margin, y + height + yt.intValue(), x + width - margin, y + height);
                context.setLineStyle(currentStyle);
                context.setLineWidth(currentWidth);
            }
            IColor storedColor = context.getBackground();
            context.setBackground(context.getForeground());
            int ray = 5;
            if (context.getLineWidth() != 1) {
                ray = ray + 5 - 1;
            }
            if (this.fStartLifeline == null) {
                context.fillOval(x - ray, y - ray, ray * 2, ray * 2);
            } else {
                context.fillOval(x + width - ray, y + height - ray, ray * 2, ray * 2);
            }
            context.setBackground(storedColor);
            context.setForeground(pref.getFontColor(this.fPrefId));
            fX = x;
            fY = y - yt.intValue();
            fW = width;
            fH = height + 2 * yt.intValue();
        } else if (this.fStartLifeline != null && this.fEndLifeline != null && this.fStartLifeline == this.fEndLifeline) {
            int tempy = 10;
            tempy = 5;
            context.drawLine(x, y, x + 10, y);
            context.drawLine(x + 20, y + tempy, x + 20, y + height + 10 - tempy);
            context.drawLine(x, y + height + 10, x + 10, y + height + 10);
            Double xt = Math.cos(0.75) * 7.0;
            Double yt = Math.sin(0.75) * 7.0;
            fX = x;
            fY = y;
            fW = 20;
            fH = height + 10;
            if (context.getLineStyle() == context.getLineSolidStyle()) {
                IColor backcolor = context.getBackground();
                context.setBackground(context.getForeground());
                int[] points = new int[]{x, y + height + 10, x + xt.intValue(), y + height + 10 + yt.intValue(), x + xt.intValue(), y + height + 10 - yt.intValue(), x, y + height + 10};
                context.fillPolygon(points);
                context.drawPolygon(points);
                context.setBackground(backcolor);
            } else {
                int currentStyle = context.getLineStyle();
                int currentWidth = context.getLineWidth();
                context.setLineWidth(currentWidth + 2);
                context.setLineStyle(context.getLineSolidStyle());
                context.drawLine(x + xt.intValue(), y + height + 10 + yt.intValue(), x, y + height + 10);
                context.drawLine(x + xt.intValue(), y + height + 10 - yt.intValue(), x, y + height + 10);
                context.setLineStyle(currentStyle);
                context.setLineWidth(currentWidth);
            }
            context.drawArc(x, y, 20, 2 * tempy, 0, 90);
            context.drawArc(x, y + 10, 20, -2 * tempy, 0, -90);
            context.setForeground(pref.getFontColor(this.fPrefId));
            if (this.fStartLifeline.getIndex() == this.fStartLifeline.getFrame().getHorizontalIndex()) {
                context.drawTextTruncated(this.getName(), x + width + 5, y, Metrics.swimmingLaneWidth() / 2 - 8 + -20, 10 - Metrics.getMessageFontHeigth(), !this.isSelected());
            } else {
                context.drawTextTruncated(this.getName(), x + width + 5, y, Metrics.swimmingLaneWidth() - 8 + -20, 10 - Metrics.getMessageFontHeigth(), !this.isSelected());
            }
        } else if (this.fStartLifeline != null && this.fEndLifeline != null) {
            context.drawLine(x, y, x + width, y + height);
            int spaceBTWStartEnd = this.fEndLifeline.getX() - this.fStartLifeline.getX();
            double a = height;
            double b = width;
            double angle = Math.atan(a / b);
            int sign = 1;
            if (spaceBTWStartEnd < 0) {
                sign = -1;
            }
            Double x1 = (double)sign * Math.cos(angle - 0.75) * 7.0;
            Double y1 = (double)sign * Math.sin(angle - 0.75) * 7.0;
            Double x2 = (double)sign * Math.cos(angle + 0.75) * 7.0;
            Double y2 = (double)sign * Math.sin(angle + 0.75) * 7.0;
            fX = this.getX();
            fY = y + height - y2.intValue();
            fW = this.getWidth();
            fH = y2.intValue() - y1.intValue() + 1;
            if (fW < 0) {
                fW = -fW;
                fX -= fW;
            }
            if (fH < 0) {
                fH = -fH;
                fY -= fH;
            }
            if (context.getLineStyle() == context.getLineSolidStyle()) {
                IColor backcolor = context.getBackground();
                context.setBackground(context.getForeground());
                int[] points = new int[]{x + width - x1.intValue(), y + height - y1.intValue(), x + width, y + height, x + width - x2.intValue(), y + height - y2.intValue(), x + width - x1.intValue(), y + height - y1.intValue()};
                context.fillPolygon(points);
                context.drawPolygon(points);
                context.setBackground(backcolor);
            } else {
                int currentStyle = context.getLineStyle();
                int currentWidth = context.getLineWidth();
                context.setLineWidth(currentWidth + 2);
                context.setLineStyle(context.getLineSolidStyle());
                context.drawLine(x + width - x1.intValue(), y + height - y1.intValue(), x + width, y + height);
                context.drawLine(x + width - x2.intValue(), y + height - y2.intValue(), x + width, y + height);
                context.setLineStyle(currentStyle);
                context.setLineWidth(currentWidth);
            }
            context.setForeground(pref.getFontColor(this.fPrefId));
            if (spaceBTWStartEnd > 0) {
                context.drawTextTruncatedCentred(this.getName(), x, y + height / 2 - (20 + Metrics.getMessageFontHeigth()), width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            } else {
                context.drawTextTruncatedCentred(this.getName(), x + width, y + height / 2 - (20 + Metrics.getMessageFontHeigth()), -width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            }
        }
    }

    @Override
    public void draw(IGC context) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isSelected()) {
            SDViewPref pref = SDViewPref.getInstance();
            context.setForeground(pref.getBackGroundColorSelection());
            context.setLineWidth(5);
            this.drawMessage(context);
            context.setBackground(pref.getBackGroundColorSelection());
            context.setForeground(pref.getForeGroundColorSelection());
        }
        context.setLineWidth(1);
        if (this.hasFocus()) {
            context.setDrawTextWithFocusStyle(true);
        }
        this.drawMessage(context);
        int oldStyle = context.getLineStyle();
        if (this.hasFocus()) {
            context.setDrawTextWithFocusStyle(false);
            this.drawFocus(context);
        }
        context.setLineStyle(oldStyle);
    }

    @Override
    public boolean isSameAs(GraphNode message) {
        if (message == null) {
            return false;
        }
        if (!(message instanceof BaseMessage)) {
            return super.isSameAs(message);
        }
        return this.getX() == message.getX() && this.getY() == message.getY() && this.getWidth() == message.getWidth() && this.getHeight() == message.getHeight();
    }

    public void drawRot(int x, int y, int w, int h, IGC context) {
        double angleA = Math.atan2(this.getHeight(), this.getWidth());
        double cosA = Math.cos(angleA);
        double sinA = Math.sin(angleA);
        int gx = this.getX();
        int gy = this.getY();
        int localHeight = h;
        localHeight /= 2;
        double cw = Math.sqrt(w * w + this.getHeight() * this.getHeight());
        int x1 = Math.round((float)((double)(x - gx) * cosA - (double)(y - gy) * sinA));
        int y1 = Math.round((float)((double)(x - gx) * sinA + (double)(y - gy) * cosA));
        int x2 = Math.round((float)(cw * cosA - (double)(y - gy) * sinA));
        int y2 = Math.round((float)(cw * sinA + (double)(y - gy) * cosA));
        int x3 = Math.round((float)(cw * cosA - (double)localHeight * sinA));
        int y3 = Math.round((float)(cw * sinA + (double)localHeight * cosA));
        int x4 = Math.round((float)((double)(x - gx) * cosA - (double)localHeight * sinA));
        int y4 = Math.round((float)((double)(x - gx) * sinA + (double)localHeight * cosA));
        int[] points = new int[]{x1 + this.getX(), y1 + this.getY(), x2 + this.getX(), y2 + this.getY(), x3 + this.getX(), y3 + this.getY(), x4 + this.getX(), y4 + this.getY()};
        context.drawPolygon(points);
    }

    @Override
    public void drawFocus(IGC context) {
        SDViewPref pref = SDViewPref.getInstance();
        if (this.fStartLifeline != this.fEndLifeline && this.fStartEventOccurrence == this.fEndEventOccurrence) {
            context.setLineStyle(context.getLineDotStyle());
            context.setLineWidth(1);
            context.setBackground(pref.getBackGroundColorSelection());
            context.setForeground(pref.getForeGroundColorSelection());
            context.drawFocus(this.getX(), this.getY() - 3, this.getWidth(), this.getHeight() + 6);
        } else if (this.fStartLifeline == this.fEndLifeline && this.fStartEventOccurrence == this.fEndEventOccurrence) {
            context.drawFocus(this.getX(), this.getY() - 3, this.getWidth(), 16);
        } else if (this.fStartLifeline != this.fEndLifeline && this.fStartEventOccurrence != this.fEndEventOccurrence) {
            context.setLineStyle(context.getLineDotStyle());
            context.setLineWidth(1);
            context.setBackground(pref.getBackGroundColor("PREF_LIFELINE_HEADER"));
            context.setForeground(pref.getForeGroundColor("PREF_LIFELINE_HEADER"));
            this.drawRot(this.getX(), this.getY() - 5, this.getWidth(), 10, context);
        } else {
            super.drawFocus(context);
        }
    }
}

