/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphTreeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphTreeExpansionEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.ItemData;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphBaseControl;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphItem;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphSelection;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class TimeGraphControl
extends TimeGraphBaseControl
implements FocusListener,
KeyListener,
MouseMoveListener,
MouseListener,
MouseWheelListener,
ControlListener,
SelectionListener,
MouseTrackListener,
TraverseListener,
ISelectionProvider {
    private static final int DRAG_NONE = 0;
    private static final int DRAG_TRACE_ITEM = 1;
    private static final int DRAG_SPLIT_LINE = 2;
    public static final boolean DEFAULT_DRAW_THREAD_JOIN = true;
    public static final boolean DEFAULT_DRAW_THREAD_WAIT = true;
    public static final boolean DEFAULT_DRAW_THREAD_RELEASE = true;
    public static final int H_SCROLLBAR_MAX = 0x7FFFFFFE;
    private static final int CUSTOM_ITEM_HEIGHT = -1;
    private static final double zoomCoeff = 1.5;
    private ITimeDataProvider _timeProvider;
    private boolean _isInFocus = false;
    private boolean _isDragCursor3 = false;
    private boolean _isWaitCursor = true;
    private boolean _mouseOverSplitLine = false;
    private int _itemHeight = -1;
    private int _minimumItemWidth = 0;
    private int _topIndex = 0;
    private int _dragState = 0;
    private int _dragX0 = 0;
    private int _dragX = 0;
    private int _idealNameSpace = 0;
    private long _time0bak;
    private long _time1bak;
    private ITimeGraphPresentationProvider fTimeGraphProvider = null;
    private ItemData _data = null;
    private List<SelectionListener> _selectionListeners;
    private List<ISelectionChangedListener> _selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private List<ITimeGraphTreeListener> _treeListeners = new ArrayList<ITimeGraphTreeListener>();
    private Cursor _dragCursor3;
    private Cursor _WaitCursor;
    private boolean _visibleVerticalScroll = true;
    private int _borderWidth = 0;
    private int _headerHeight = 0;
    private Listener mouseScrollFilterListener;
    protected LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    protected Color[] fEventColorMap = null;

    public TimeGraphControl(Composite parent, TimeGraphColorScheme colors) {
        super(parent, colors, 537133312);
        this._data = new ItemData();
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        this.addMouseWheelListener(this);
        this.addTraverseListener(this);
        this.addKeyListener(this);
        this.addControlListener(this);
        ScrollBar scrollHor = this.getHorizontalBar();
        if (scrollHor != null) {
            scrollHor.addSelectionListener((SelectionListener)this);
        }
        this._dragCursor3 = new Cursor((Device)super.getDisplay(), 9);
        this._WaitCursor = new Cursor((Device)super.getDisplay(), 1);
    }

    @Override
    public void dispose() {
        super.dispose();
        this._dragCursor3.dispose();
        this._WaitCursor.dispose();
        this.fResourceManager.dispose();
    }

    public void setTimeGraphProvider(ITimeGraphPresentationProvider timeGraphProvider) {
        this.fTimeGraphProvider = timeGraphProvider;
        this._data.provider = timeGraphProvider;
        StateItem[] stateItems = this.fTimeGraphProvider.getStateTable();
        if (stateItems != null) {
            this.fEventColorMap = new Color[stateItems.length];
            int i = 0;
            while (i < stateItems.length) {
                this.fEventColorMap[i] = this.fResourceManager.createColor(stateItems[i].getStateColor());
                ++i;
            }
        } else {
            this.fEventColorMap = new Color[0];
        }
    }

    public void setTimeProvider(ITimeDataProvider timeProvider) {
        this._timeProvider = timeProvider;
        this.adjustScrolls();
        this.redraw();
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this._selectionListeners == null) {
            this._selectionListeners = new ArrayList<SelectionListener>();
        }
        this._selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this._selectionListeners != null) {
            this._selectionListeners.remove(listener);
        }
    }

    public void fireSelectionChanged() {
        if (this._selectionListeners != null) {
            for (SelectionListener listener : this._selectionListeners) {
                listener.widgetSelected(null);
            }
        }
    }

    public void fireDefaultSelection() {
        if (this._selectionListeners != null) {
            for (SelectionListener listener : this._selectionListeners) {
                listener.widgetDefaultSelected(null);
            }
        }
    }

    public ITimeGraphEntry[] getTraces() {
        return this._data.getTraces();
    }

    public boolean[] getTraceFilter() {
        return this._data.getTraceFilter();
    }

    public void refreshData() {
        this._data.refreshData();
        this.adjustScrolls();
        this.redraw();
    }

    public void refreshData(ITimeGraphEntry[] traces) {
        this._data.refreshData(traces);
        this.adjustScrolls();
        this.redraw();
    }

    public void adjustScrolls() {
        if (this._timeProvider == null) {
            this.getHorizontalBar().setValues(0, 1, 1, 1, 1, 1);
            return;
        }
        long time0 = this._timeProvider.getTime0();
        long time1 = this._timeProvider.getTime1();
        long timeMin = this._timeProvider.getMinTime();
        long timeMax = this._timeProvider.getMaxTime();
        long delta = timeMax - timeMin;
        int timePos = 0;
        int thumb = 0x7FFFFFFE;
        if (delta != 0L) {
            thumb = Math.max(1, (int)(2.147483646E9 * ((double)(time1 - time0) / (double)delta)));
            timePos = (int)(2.147483646E9 * ((double)(time0 - timeMin) / (double)delta));
        }
        this.getHorizontalBar().setValues(timePos, 0, 0x7FFFFFFE, thumb, Math.max(1, thumb / 2), Math.max(2, thumb));
    }

    boolean ensureVisibleItem(int idx, boolean redraw) {
        boolean changed = false;
        if (idx < 0) {
            idx = 0;
            while (idx < this._data._expandedItems.length) {
                if (this._data._expandedItems[idx]._selected) break;
                ++idx;
            }
        }
        if (idx >= this._data._expandedItems.length) {
            return changed;
        }
        if (idx < this._topIndex) {
            this.setTopIndex(idx);
            if (redraw) {
                this.redraw();
            }
            changed = true;
        } else {
            int page = this.countPerPage();
            if (idx >= this._topIndex + page) {
                this.setTopIndex(idx - page + 1);
                if (redraw) {
                    this.redraw();
                }
                changed = true;
            }
        }
        return changed;
    }

    public void setTopIndex(int idx) {
        idx = Math.min(idx, this._data._expandedItems.length - this.countPerPage());
        this._topIndex = idx = Math.max(0, idx);
        this.redraw();
    }

    public void setExpandedState(ITimeGraphEntry entry, boolean expanded) {
        TimeGraphItem item = this._data.findItem(entry);
        if (item != null && item._expanded != expanded) {
            item._expanded = expanded;
            this._data.updateExpandedItems();
            this.redraw();
        }
    }

    public void addTreeListener(ITimeGraphTreeListener listener) {
        if (!this._treeListeners.contains(listener)) {
            this._treeListeners.add(listener);
        }
    }

    public void removeTreeListener(ITimeGraphTreeListener listener) {
        if (this._treeListeners.contains(listener)) {
            this._treeListeners.remove(listener);
        }
    }

    public void fireTreeEvent(ITimeGraphEntry entry, boolean expanded) {
        TimeGraphTreeExpansionEvent event = new TimeGraphTreeExpansionEvent((Object)this, entry);
        for (ITimeGraphTreeListener listener : this._treeListeners) {
            if (expanded) {
                listener.treeExpanded(event);
                continue;
            }
            listener.treeCollapsed(event);
        }
    }

    public ISelection getSelection() {
        TimeGraphSelection sel = new TimeGraphSelection();
        ITimeGraphEntry trace = this.getSelectedTrace();
        if (trace != null && this._timeProvider != null) {
            long selectedTime = this._timeProvider.getSelectedTime();
            ITimeEvent event = Utils.findEvent(trace, selectedTime, 0);
            if (event != null) {
                sel.add(event);
            } else {
                sel.add(trace);
            }
        }
        return sel;
    }

    public ISelection getSelectionTrace() {
        TimeGraphSelection sel = new TimeGraphSelection();
        ITimeGraphEntry trace = this.getSelectedTrace();
        if (trace != null) {
            sel.add(trace);
        }
        return sel;
    }

    public void selectTrace(int n) {
        if (n != 1 && n != -1) {
            return;
        }
        boolean changed = false;
        int lastSelection = -1;
        int i = 0;
        while (i < this._data._expandedItems.length) {
            TimeGraphItem item = this._data._expandedItems[i];
            if (item._selected) {
                lastSelection = i;
                if (1 == n && i < this._data._expandedItems.length - 1) {
                    item._selected = false;
                    if (item._hasChildren) {
                        this._data.expandItem(i);
                        this.fireTreeEvent(item._trace, item._expanded);
                    }
                    item = this._data._expandedItems[i + 1];
                    if (item._hasChildren) {
                        this._data.expandItem(i + 1);
                        this.fireTreeEvent(item._trace, item._expanded);
                        item = this._data._expandedItems[i + 2];
                    }
                    item._selected = true;
                    changed = true;
                    break;
                }
                if (-1 != n || i <= 0) break;
                TimeGraphItem prevItem = this._data._expandedItems[--i];
                if (prevItem._hasChildren) {
                    if (prevItem._expanded && i > 0) {
                        prevItem = this._data._expandedItems[--i];
                    }
                    if (prevItem._expanded) break;
                    this._data.expandItem(i);
                    this.fireTreeEvent(prevItem._trace, prevItem._expanded);
                    prevItem = this._data._expandedItems[i + prevItem.children.size()];
                    item._selected = false;
                    prevItem._selected = true;
                    changed = true;
                    break;
                }
                item._selected = false;
                prevItem._selected = true;
                changed = true;
                break;
            }
            ++i;
        }
        if (lastSelection < 0 && this._data._expandedItems.length > 0) {
            TimeGraphItem item = this._data._expandedItems[0];
            if (item._hasChildren) {
                this._data.expandItem(0);
                this.fireTreeEvent(item._trace, item._expanded);
                item = this._data._expandedItems[1];
                item._selected = true;
                changed = true;
            } else {
                item._selected = true;
                changed = true;
            }
        }
        if (changed) {
            this.ensureVisibleItem(-1, false);
            this.redraw();
            this.fireSelectionChanged();
        }
    }

    public void selectEvent(int n) {
        if (this._timeProvider == null) {
            return;
        }
        ITimeGraphEntry trace = this.getSelectedTrace();
        if (trace == null) {
            return;
        }
        long selectedTime = this._timeProvider.getSelectedTime();
        long endTime = this._timeProvider.getEndTime();
        ITimeEvent nextEvent = -1 == n && selectedTime > endTime ? Utils.findEvent(trace, selectedTime, 0) : Utils.findEvent(trace, selectedTime, n);
        if (nextEvent == null && -1 == n) {
            nextEvent = Utils.getFirstEvent(trace);
        }
        if (nextEvent != null) {
            long nextTime = nextEvent.getTime();
            if (nextTime <= selectedTime && n == 1 && (nextTime = nextEvent.getTime() + nextEvent.getDuration()) > endTime) {
                nextTime = endTime;
            }
            this._timeProvider.setSelectedTimeInt(nextTime, true);
            this.fireSelectionChanged();
        } else if (1 == n) {
            this._timeProvider.setSelectedTimeInt(endTime, true);
            this.fireSelectionChanged();
        }
    }

    public void selectNextEvent() {
        this.selectEvent(1);
        this._timeProvider.setStartFinishTimeNotify(this._timeProvider.getTime0(), this._timeProvider.getTime1());
    }

    public void selectPrevEvent() {
        this.selectEvent(-1);
        this._timeProvider.setStartFinishTimeNotify(this._timeProvider.getTime0(), this._timeProvider.getTime1());
    }

    public void selectNextTrace() {
        this.selectTrace(1);
    }

    public void selectPrevTrace() {
        this.selectTrace(-1);
    }

    public void zoom(boolean zoomIn) {
        int globalX = this.getDisplay().getCursorLocation().x;
        Point p = this.toControl(globalX, 0);
        int nameSpace = this._timeProvider.getNameSpace();
        int timeSpace = this._timeProvider.getTimeSpace();
        int xPos = Math.max(nameSpace, Math.min(nameSpace + timeSpace, p.x));
        long time0 = this._timeProvider.getTime0();
        long time1 = this._timeProvider.getTime1();
        long interval = time1 - time0;
        if (interval == 0L) {
            interval = 1L;
        }
        long newInterval = zoomIn ? Math.max(Math.round((double)interval * 0.8), this._timeProvider.getMinTimeInterval()) : (long)Math.ceil((double)interval * 1.25);
        long center = time0 + Math.round((double)(xPos - nameSpace) / (double)timeSpace * (double)interval);
        long newTime0 = center - Math.round((double)newInterval * (double)(center - time0) / (double)interval);
        long newTime1 = newTime0 + newInterval;
        this._timeProvider.setStartFinishTime(newTime0, newTime1);
    }

    public void zoomIn() {
        long _time0 = this._timeProvider.getTime0();
        long _time1 = this._timeProvider.getTime1();
        long _range = _time1 - _time0;
        long selTime = this._timeProvider.getSelectedTime();
        if (selTime <= _time0 || selTime >= _time1) {
            selTime = (_time0 + _time1) / 2L;
        }
        long time0 = selTime - (long)((double)(selTime - _time0) / 1.5);
        long time1 = selTime + (long)((double)(_time1 - selTime) / 1.5);
        long inaccuracy = this._timeProvider.getMaxTime() - this._timeProvider.getMinTime() - (time1 - time0);
        if (inaccuracy > 0L && inaccuracy < 100L) {
            this._timeProvider.setStartFinishTimeNotify(this._timeProvider.getMinTime(), this._timeProvider.getMaxTime());
            return;
        }
        long m = this._timeProvider.getMinTimeInterval();
        if (time1 - time0 < m) {
            time0 = selTime - (selTime - _time0) * m / _range;
            time1 = time0 + m;
        }
        this._timeProvider.setStartFinishTimeNotify(time0, time1);
    }

    public void zoomOut() {
        long _time0 = this._timeProvider.getTime0();
        long _time1 = this._timeProvider.getTime1();
        long selTime = this._timeProvider.getSelectedTime();
        if (selTime <= _time0 || selTime >= _time1) {
            selTime = (_time0 + _time1) / 2L;
        }
        long time0 = (long)((double)selTime - (double)(selTime - _time0) * 1.5);
        long time1 = (long)((double)selTime + (double)(_time1 - selTime) * 1.5);
        long inaccuracy = this._timeProvider.getMaxTime() - this._timeProvider.getMinTime() - (time1 - time0);
        if (inaccuracy > 0L && inaccuracy < 100L) {
            this._timeProvider.setStartFinishTimeNotify(this._timeProvider.getMinTime(), this._timeProvider.getMaxTime());
            return;
        }
        this._timeProvider.setStartFinishTimeNotify(time0, time1);
    }

    public ITimeGraphEntry getSelectedTrace() {
        ITimeGraphEntry trace = null;
        int idx = this.getSelectedIndex();
        if (idx >= 0) {
            trace = this._data._expandedItems[idx]._trace;
        }
        return trace;
    }

    public int getSelectedIndex() {
        int idx = -1;
        int i = 0;
        while (i < this._data._expandedItems.length) {
            TimeGraphItem item = this._data._expandedItems[i];
            if (item._selected) {
                idx = i;
                break;
            }
            ++i;
        }
        return idx;
    }

    boolean toggle(int idx) {
        boolean toggled = false;
        if (idx >= 0 && idx < this._data._expandedItems.length) {
            TimeGraphItem item = this._data._expandedItems[idx];
            if (item._hasChildren) {
                item._expanded = !item._expanded;
                this._data.updateExpandedItems();
                this.adjustScrolls();
                this.redraw();
                toggled = true;
                this.fireTreeEvent(item._trace, item._expanded);
            }
        }
        return toggled;
    }

    int getItemIndexAtY(int y) {
        if (y < 0) {
            return -1;
        }
        if (this._itemHeight == -1) {
            int ySum = 0;
            int idx = this._topIndex;
            while (idx < this._data._expandedItems.length) {
                if (y < (ySum += this._data._expandedItems[idx].itemHeight)) {
                    return idx;
                }
                ++idx;
            }
            return -1;
        }
        int idx = y / this._itemHeight;
        if ((idx += this._topIndex) < this._data._expandedItems.length) {
            return idx;
        }
        return -1;
    }

    boolean isOverSplitLine(int x) {
        if (x < 0 || this._timeProvider == null) {
            return false;
        }
        int w = 4;
        int nameWidth = this._timeProvider.getNameSpace();
        return x > nameWidth - w && x < nameWidth + w;
    }

    TimeGraphItem getItem(Point pt) {
        int idx = this.getItemIndexAtY(pt.y);
        return idx >= 0 ? this._data._expandedItems[idx] : null;
    }

    long getTimeAtX(int x) {
        if (this._timeProvider == null) {
            return -1L;
        }
        long hitTime = -1L;
        Point size = this.getCtrlSize();
        long time0 = this._timeProvider.getTime0();
        long time1 = this._timeProvider.getTime1();
        int nameWidth = this._timeProvider.getNameSpace();
        if ((x -= nameWidth) >= 0 && size.x >= nameWidth) {
            hitTime = time1 - time0 > (long)(size.x - nameWidth - 1) ? time0 + (long)((double)(time1 - time0) * ((double)(x + 1) / (double)(size.x - nameWidth - 1))) - 1L : time0 + (long)((double)(time1 - time0) * ((double)x / (double)(size.x - nameWidth - 1)));
        }
        return hitTime;
    }

    void selectItem(int idx, boolean addSelection) {
        boolean changed = false;
        if (addSelection) {
            if (idx >= 0 && idx < this._data._expandedItems.length) {
                TimeGraphItem item = this._data._expandedItems[idx];
                changed = !item._selected;
                item._selected = true;
            }
        } else {
            int i = 0;
            while (i < this._data._expandedItems.length) {
                TimeGraphItem item = this._data._expandedItems[i];
                if (i == idx && !item._selected || idx == -1 && item._selected) {
                    changed = true;
                }
                item._selected = i == idx;
                ++i;
            }
        }
        if (changed |= this.ensureVisibleItem(idx, true)) {
            this.redraw();
        }
    }

    public void selectItem(ITimeGraphEntry trace, boolean addSelection) {
        int idx = this._data.findItemIndex(trace);
        this.selectItem(idx, addSelection);
    }

    public int countPerPage() {
        int height = this.getCtrlSize().y;
        int count = 0;
        if (this._itemHeight == -1) {
            int ySum = 0;
            int idx = this._topIndex;
            while (idx < this._data._expandedItems.length) {
                if ((ySum += this._data._expandedItems[idx].itemHeight) >= height) {
                    return count;
                }
                ++count;
                ++idx;
            }
            idx = this._topIndex - 1;
            while (idx >= 0) {
                if ((ySum += this._data._expandedItems[idx].itemHeight) >= height) {
                    return count;
                }
                ++count;
                --idx;
            }
            return count;
        }
        if (height > 0) {
            count = height / this._itemHeight;
        }
        return count;
    }

    public int getTopIndex() {
        return this._topIndex;
    }

    public int getExpandedElementCount() {
        return this._data._expandedItems.length;
    }

    Point getCtrlSize() {
        Point size = this.getSize();
        if (this.getHorizontalBar().isVisible()) {
            size.y -= this.getHorizontalBar().getSize().y;
        }
        return size;
    }

    Rectangle getNameRect(Rectangle bound, int idx, int nameWidth) {
        int x = bound.x;
        int y = bound.y + (idx - this._topIndex) * this._itemHeight;
        int width = nameWidth;
        int height = this._itemHeight;
        if (this._itemHeight == -1) {
            int ySum = 0;
            int i = this._topIndex;
            while (i < idx) {
                ySum += this._data._expandedItems[i].itemHeight;
                ++i;
            }
            y = bound.y + ySum;
            height = this._data._expandedItems[idx].itemHeight;
        }
        return new Rectangle(x, y, width, height);
    }

    Rectangle getStatesRect(Rectangle bound, int idx, int nameWidth) {
        int x = bound.x + nameWidth;
        int y = bound.y + (idx - this._topIndex) * this._itemHeight;
        int width = bound.width - x;
        int height = this._itemHeight;
        if (this._itemHeight == -1) {
            int ySum = 0;
            int i = this._topIndex;
            while (i < idx) {
                ySum += this._data._expandedItems[i].itemHeight;
                ++i;
            }
            y = bound.y + ySum;
            height = this._data._expandedItems[idx].itemHeight;
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    void paint(Rectangle bounds, PaintEvent e) {
        GC gc = e.gc;
        gc.setBackground(this._colors.getColor(32));
        this.drawBackground(gc, bounds.x, bounds.y, bounds.width, bounds.height);
        if (bounds.width < 2 || bounds.height < 2 || this._timeProvider == null) {
            return;
        }
        this._idealNameSpace = 0;
        int nameSpace = this._timeProvider.getNameSpace();
        gc.setBackground(this._colors.getBkColor(false, false, true));
        this.drawBackground(gc, bounds.x, bounds.y, nameSpace, bounds.height);
        this.drawItems(bounds, this._timeProvider, this._data._expandedItems, this._topIndex, nameSpace, gc);
        long time0 = this._timeProvider.getTime0();
        long time1 = this._timeProvider.getTime1();
        long selectedTime = this._timeProvider.getSelectedTime();
        double pixelsPerNanoSec = bounds.width - nameSpace <= 1 ? 0.0 : (double)(bounds.width - nameSpace - 1) / (double)(time1 - time0);
        int x = bounds.x + nameSpace + (int)((double)(selectedTime - time0) * pixelsPerNanoSec);
        if (x >= nameSpace && x < bounds.x + bounds.width) {
            gc.setForeground(this._colors.getColor(68));
            gc.drawLine(x, bounds.y, x, bounds.y + bounds.height);
        }
        if (2 == this._dragState) {
            gc.setForeground(this._colors.getColor(43));
            gc.drawLine(bounds.x + nameSpace, bounds.y, bounds.x + nameSpace, bounds.y + bounds.height - 1);
        } else if (this._dragState == 0 && this._mouseOverSplitLine && this._timeProvider.getNameSpace() > 0) {
            gc.setForeground(this._colors.getColor(62));
            gc.drawLine(bounds.x + nameSpace, bounds.y, bounds.x + nameSpace, bounds.y + bounds.height - 1);
        }
    }

    public void drawItems(Rectangle bounds, ITimeDataProvider timeProvider, TimeGraphItem[] items, int topIndex, int nameSpace, GC gc) {
        int i = topIndex;
        while (i < items.length) {
            TimeGraphItem item = items[i];
            this.drawItem(item, bounds, timeProvider, i, nameSpace, gc);
            ++i;
        }
        this.fTimeGraphProvider.postDrawControl(bounds, gc);
    }

    protected void drawItem(TimeGraphItem item, Rectangle bounds, ITimeDataProvider timeProvider, int i, int nameSpace, GC gc) {
        boolean group;
        ITimeGraphEntry entry = item._trace;
        long time0 = timeProvider.getTime0();
        long time1 = timeProvider.getTime1();
        long selectedTime = timeProvider.getSelectedTime();
        Rectangle nameRect = this.getNameRect(bounds, i, nameSpace);
        if (nameRect.y >= bounds.y + bounds.height) {
            return;
        }
        if (item._trace.getTimeEventsIterator() == null) {
            Rectangle statesRect = this.getStatesRect(bounds, i, nameSpace);
            nameRect.width += statesRect.width;
            this.drawName(item, nameRect, gc);
        } else {
            this.drawName(item, nameRect, gc);
        }
        Rectangle rect = this.getStatesRect(bounds, i, nameSpace);
        if (rect.isEmpty()) {
            this.fTimeGraphProvider.postDrawEntry(entry, bounds, gc);
            return;
        }
        if (time1 <= time0) {
            gc.setBackground(this._colors.getBkColor(false, false, false));
            gc.fillRectangle(rect);
            this.fTimeGraphProvider.postDrawEntry(entry, bounds, gc);
            return;
        }
        Rectangle stateRect = Utils.clone(rect);
        boolean selected = item._selected;
        double pixelsPerNanoSec = rect.width <= 1 ? 0.0 : (double)(rect.width - 1) / (double)(time1 - time0);
        boolean bl = group = item._trace.getTimeEventsIterator() == null;
        if (!group) {
            this.fillSpace(rect, gc, selected);
            stateRect.y += 3;
            stateRect.height -= 6;
            long maxDuration = timeProvider.getTimeSpace() == 0 ? Long.MAX_VALUE : 1L * (time1 - time0) / (long)timeProvider.getTimeSpace();
            Iterator iterator = entry.getTimeEventsIterator(time0, time1, maxDuration);
            int lastX = -1;
            while (iterator.hasNext()) {
                ITimeEvent event = (ITimeEvent)iterator.next();
                int x = rect.x + (int)((double)(event.getTime() - time0) * pixelsPerNanoSec);
                int xEnd = rect.x + (int)((double)(event.getTime() + event.getDuration() - time0) * pixelsPerNanoSec);
                if (x >= rect.x + rect.width || xEnd < rect.x) continue;
                xEnd = Math.min(rect.x + rect.width, xEnd);
                stateRect.x = Math.max(rect.x, x);
                stateRect.width = Math.max(0, xEnd - stateRect.x + 1);
                if (stateRect.x == lastX) {
                    --stateRect.width;
                    if (stateRect.width > 0) {
                        gc.setForeground(Display.getDefault().getSystemColor(2));
                        gc.drawPoint(stateRect.x, stateRect.y - 2);
                        ++stateRect.x;
                    }
                } else {
                    lastX = x;
                }
                boolean timeSelected = selectedTime >= event.getTime() && selectedTime < event.getTime() + event.getDuration();
                this.drawState(this._colors, event, stateRect, gc, selected, timeSelected);
            }
        }
        this.fTimeGraphProvider.postDrawEntry(entry, bounds, gc);
    }

    protected void drawName(TimeGraphItem item, Rectangle bounds, GC gc) {
        boolean group;
        boolean bl = group = item._trace.getTimeEventsIterator() == null;
        if (group) {
            gc.setBackground(this._colors.getBkColorGroup(item._selected, this._isInFocus));
            gc.fillRectangle(bounds);
            if (item._selected && this._isInFocus) {
                gc.setForeground(this._colors.getBkColor(item._selected, this._isInFocus, false));
                gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            }
        } else {
            gc.setBackground(this._colors.getBkColor(item._selected, this._isInFocus, true));
            gc.setForeground(this._colors.getFgColor(item._selected, this._isInFocus));
            gc.fillRectangle(bounds);
        }
        if (this._timeProvider.getNameSpace() == 0) {
            return;
        }
        int leftMargin = 4 + item.level * 9;
        if (item._hasChildren) {
            gc.setForeground(this._colors.getFgColorGroup(false, false));
            gc.setBackground(this._colors.getBkColor(false, false, false));
            Rectangle rect = Utils.clone(bounds);
            rect.x += leftMargin;
            rect.y += (bounds.height - 9) / 2;
            rect.width = 9;
            rect.height = 9;
            gc.fillRectangle(rect);
            gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
            int midy = rect.y + rect.height / 2;
            gc.drawLine(rect.x + 2, midy, rect.x + rect.width - 3, midy);
            if (!item._expanded) {
                int midx = rect.x + rect.width / 2;
                gc.drawLine(midx, rect.y + 2, midx, rect.y + rect.height - 3);
            }
        }
        leftMargin += 13;
        Image img = this.fTimeGraphProvider.getItemImage(item._trace);
        if (img != null) {
            int imgHeight = img.getImageData().height;
            int imgWidth = img.getImageData().width;
            int x = leftMargin;
            int y = bounds.y + (bounds.height - imgHeight) / 2;
            gc.drawImage(img, x, y);
            leftMargin += imgWidth + 4;
        }
        String name = item._name;
        Point size = gc.stringExtent(name);
        if (this._idealNameSpace < leftMargin + size.x + 4) {
            this._idealNameSpace = leftMargin + size.x + 4;
        }
        if (!group) {
            int width = bounds.width - leftMargin;
            int cuts = 0;
            while (size.x > width && name.length() > 1) {
                ++cuts;
                name = name.substring(0, name.length() - 1);
                size = gc.stringExtent(String.valueOf(name) + "...");
            }
            if (cuts > 0) {
                name = String.valueOf(name) + "...";
            }
        }
        Rectangle rect = Utils.clone(bounds);
        rect.x += leftMargin;
        rect.width -= leftMargin;
        if (rect.width > 0) {
            rect.y += (bounds.height - gc.stringExtent((String)name).y) / 2;
            gc.setForeground(this._colors.getFgColor(item._selected, this._isInFocus));
            int textWidth = Utils.drawText(gc, name, rect, true);
            leftMargin += textWidth + 4;
            rect.y -= 2;
            if (!group) {
                int x = bounds.x + leftMargin;
                int width = bounds.width - x;
                int midy = bounds.y + bounds.height / 2;
                gc.setForeground(this._colors.getColor(61));
                gc.drawLine(x, midy, x + width, midy);
            }
        }
    }

    protected void drawState(TimeGraphColorScheme colors, ITimeEvent event, Rectangle rect, GC gc, boolean selected, boolean timeSelected) {
        boolean visible;
        int colorIdx = this.fTimeGraphProvider.getEventTableIndex(event);
        if (colorIdx < 0) {
            return;
        }
        boolean bl = visible = rect.width != 0;
        if (visible) {
            Color stateColor = null;
            stateColor = colorIdx < this.fEventColorMap.length ? this.fEventColorMap[colorIdx] : Display.getDefault().getSystemColor(2);
            timeSelected = timeSelected && selected;
            gc.setBackground(stateColor);
            gc.fillRectangle(rect);
            gc.setForeground(Display.getDefault().getSystemColor(2));
            if (!timeSelected) {
                gc.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
            }
        } else {
            gc.setForeground(Display.getDefault().getSystemColor(2));
            gc.drawPoint(rect.x, rect.y - 2);
        }
        this.fTimeGraphProvider.postDrawEvent(event, rect, gc);
    }

    protected void fillSpace(Rectangle rect, GC gc, boolean selected) {
        gc.setBackground(this._colors.getBkColor(selected, this._isInFocus, false));
        gc.fillRectangle(rect);
        gc.setForeground(this._colors.getColor(61));
        int midy = rect.y + rect.height / 2;
        gc.drawLine(rect.x, midy, rect.x + rect.width, midy);
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.detail == 16 || e.detail == 8) {
            e.doit = true;
        }
    }

    public void keyPressed(KeyEvent e) {
        int idx = -1;
        if (this._data._expandedItems.length == 0) {
            return;
        }
        if (0x1000007 == e.keyCode) {
            idx = 0;
        } else if (0x1000008 == e.keyCode) {
            idx = this._data._expandedItems.length - 1;
        } else if (0x1000002 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            } else if (idx < this._data._expandedItems.length - 1) {
                ++idx;
            }
        } else if (0x1000001 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            } else if (idx > 0) {
                --idx;
            }
        } else if (0x1000003 == e.keyCode) {
            this.selectPrevEvent();
        } else if (0x1000004 == e.keyCode) {
            this.selectNextEvent();
        } else if (0x1000006 == e.keyCode) {
            int page = this.countPerPage();
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            }
            if ((idx += page) >= this._data._expandedItems.length) {
                idx = this._data._expandedItems.length - 1;
            }
        } else if (0x1000005 == e.keyCode) {
            int page = this.countPerPage();
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            }
            if ((idx -= page) < 0) {
                idx = 0;
            }
        } else if (13 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx >= 0) {
                if (this._data._expandedItems[idx]._hasChildren) {
                    this.toggle(idx);
                } else {
                    this.fireDefaultSelection();
                }
            }
            idx = -1;
        }
        if (idx >= 0) {
            this.selectItem(idx, false);
            this.fireSelectionChanged();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this._isInFocus = true;
        this.redraw();
    }

    public void focusLost(FocusEvent e) {
        this._isInFocus = false;
        if (this._dragState != 0) {
            this.setCapture(false);
            this._dragState = 0;
        }
        this.redraw();
    }

    public boolean isInFocus() {
        return this._isInFocus;
    }

    public void waitCursor(boolean waitInd) {
        if (waitInd) {
            this.setCursor(this._WaitCursor);
            this._isWaitCursor = true;
        } else {
            this.setCursor(null);
            this._isWaitCursor = false;
        }
        this._isDragCursor3 = false;
    }

    void updateCursor(int x, int y) {
        if (!this._isWaitCursor) {
            boolean isSplitLine = this.isOverSplitLine(x);
            if (isSplitLine && !this._isDragCursor3 && this._timeProvider.getNameSpace() > 0) {
                this.setCursor(this._dragCursor3);
                this._isDragCursor3 = true;
            } else if (!isSplitLine && this._isDragCursor3) {
                this.setCursor(null);
                this._isDragCursor3 = false;
            }
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this._timeProvider == null) {
            return;
        }
        Point size = this.getCtrlSize();
        if (1 == this._dragState) {
            int nameWidth = this._timeProvider.getNameSpace();
            int x = e.x - nameWidth;
            if (x > 0 && size.x > nameWidth && this._dragX != x) {
                long time0;
                long maxTime;
                this._dragX = x;
                double pixelsPerNanoSec = size.x - nameWidth <= 1 ? 0.0 : (double)(size.x - nameWidth - 1) / (double)(this._time1bak - this._time0bak);
                long timeDelta = (long)(pixelsPerNanoSec == 0.0 ? 0.0 : (double)(this._dragX - this._dragX0) / pixelsPerNanoSec);
                long time1 = this._time1bak - timeDelta;
                if (time1 > (maxTime = this._timeProvider.getMaxTime())) {
                    time1 = maxTime;
                }
                if ((time0 = time1 - (this._time1bak - this._time0bak)) < this._timeProvider.getMinTime()) {
                    time0 = this._timeProvider.getMinTime();
                    time1 = time0 + (this._time1bak - this._time0bak);
                }
                this._timeProvider.setStartFinishTime(time0, time1);
            }
        } else if (2 == this._dragState) {
            this._dragX = e.x;
            this._timeProvider.setNameSpace(e.x);
        } else if (this._dragState == 0) {
            boolean mouseOverSplitLine = this.isOverSplitLine(e.x);
            if (this._mouseOverSplitLine != mouseOverSplitLine) {
                this.redraw();
            }
            this._mouseOverSplitLine = mouseOverSplitLine;
            this._timeProvider.notifyStartFinishTime();
        }
        this.updateCursor(e.x, e.y);
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this._timeProvider == null) {
            return;
        }
        if (1 == e.button) {
            if (this.isOverSplitLine(e.x) && this._timeProvider.getNameSpace() != 0) {
                this._timeProvider.setNameSpace(this._idealNameSpace);
                boolean mouseOverSplitLine = this.isOverSplitLine(e.x);
                if (this._mouseOverSplitLine != mouseOverSplitLine) {
                    this.redraw();
                }
                this._mouseOverSplitLine = mouseOverSplitLine;
                return;
            }
            int idx = this.getItemIndexAtY(e.y);
            if (idx >= 0) {
                this.selectItem(idx, false);
                this.fireDefaultSelection();
            }
        }
    }

    public void mouseDown(MouseEvent e) {
        if (this._timeProvider == null) {
            return;
        }
        if (1 == e.button) {
            int nameSpace = this._timeProvider.getNameSpace();
            if (nameSpace != 0 && this.isOverSplitLine(e.x)) {
                this._dragState = 2;
                this._dragX = this._dragX0 = e.x;
                this._time0bak = this._timeProvider.getTime0();
                this._time1bak = this._timeProvider.getTime1();
                this.redraw();
                return;
            }
            int idx = this.getItemIndexAtY(e.y);
            if (idx >= 0) {
                TimeGraphItem item = this._data._expandedItems[idx];
                if (item._hasChildren && e.x < nameSpace && e.x < 4 + (item.level + 1) * 9) {
                    this.toggle(idx);
                } else {
                    long hitTime = this.getTimeAtX(e.x);
                    if (hitTime >= 0L) {
                        this.setCapture(true);
                        this._dragState = 1;
                        this._dragX = this._dragX0 = e.x - nameSpace;
                        this._time0bak = this._timeProvider.getTime0();
                        this._time1bak = this._timeProvider.getTime1();
                    }
                }
                this.selectItem(idx, false);
                this.fireSelectionChanged();
            } else {
                this.selectItem(idx, false);
                this.redraw();
                this.fireSelectionChanged();
            }
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this._dragState != 0) {
            this.setCapture(false);
            if (1 == this._dragState) {
                this._timeProvider.notifyStartFinishTime();
                if (this._dragX == this._dragX0) {
                    long time = this.getTimeAtX(e.x);
                    this._timeProvider.setSelectedTimeInt(time, false);
                }
            } else if (2 == this._dragState) {
                this.redraw();
            }
            this._dragState = 0;
        }
    }

    public void mouseEnter(MouseEvent e) {
        if (this.mouseScrollFilterListener == null) {
            this.mouseScrollFilterListener = new Listener(){

                public void handleEvent(Event event) {
                    event.doit = false;
                }
            };
            this.getDisplay().addFilter(37, this.mouseScrollFilterListener);
        }
    }

    public void mouseExit(MouseEvent e) {
        if (this.mouseScrollFilterListener != null) {
            this.getDisplay().removeFilter(37, this.mouseScrollFilterListener);
            this.mouseScrollFilterListener = null;
        }
        if (this._mouseOverSplitLine) {
            this._mouseOverSplitLine = false;
            this.redraw();
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseScrolled(MouseEvent e) {
        if (this.mouseScrollFilterListener == null || this._dragState != 0) {
            return;
        }
        if (e.x < this._timeProvider.getNameSpace() || e.x > this.getSize().x) {
            this.setTopIndex(this.getTopIndex() - e.count);
        } else if (this._timeProvider.getTime0() != this._timeProvider.getTime1()) {
            if (e.count > 0) {
                this.zoom(true);
            } else if (e.count < 0) {
                this.zoom(false);
            }
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.adjustScrolls();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.getVerticalBar()) {
            this.setTopIndex(this.getVerticalBar().getSelection());
        } else if (e.widget == this.getHorizontalBar() && this._timeProvider != null) {
            int start = this.getHorizontalBar().getSelection();
            long time0 = this._timeProvider.getTime0();
            long time1 = this._timeProvider.getTime1();
            long timeMin = this._timeProvider.getMinTime();
            long timeMax = this._timeProvider.getMaxTime();
            long delta = timeMax - timeMin;
            long range = time1 - time0;
            time0 = timeMin + Math.round((double)delta * ((double)start / 2.147483646E9));
            time1 = time0 + range;
            if (e.detail == 1) {
                this._timeProvider.setStartFinishTime(time0, time1);
            } else {
                this._timeProvider.setStartFinishTimeNotify(time0, time1);
            }
        }
    }

    public boolean isVisibleVerticalScroll() {
        return this._visibleVerticalScroll;
    }

    public int getBorderWidth() {
        return this._borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this._borderWidth = borderWidth;
    }

    public int getHeaderHeight() {
        return this._headerHeight;
    }

    public void setHeaderHeight(int headerHeight) {
        this._headerHeight = headerHeight;
    }

    public int getItemHeight() {
        return this._itemHeight;
    }

    public void setItemHeight(int rowHeight) {
        this._itemHeight = rowHeight;
    }

    public void setMinimumItemWidth(int width) {
        this._minimumItemWidth = width;
    }

    public int getMinimumItemWidth() {
        return this._minimumItemWidth;
    }

    public Vector<ITimeGraphEntry> getFilteredOut() {
        return this._data.getFilteredOut();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null && !this._selectionChangedListeners.contains(listener)) {
            this._selectionChangedListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this._selectionChangedListeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        TimeGraphSelection sel;
        Object ob;
        if (selection instanceof TimeGraphSelection && (ob = (sel = (TimeGraphSelection)selection).getFirstElement()) instanceof ITimeGraphEntry) {
            ITimeGraphEntry trace = (ITimeGraphEntry)ob;
            this.selectItem(trace, false);
        }
    }
}

