/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.StateHistorySystem;
import org.eclipse.linuxtools.tmf.core.component.TmfComponent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateChangeInput;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateHistoryBackend;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemBuilder;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier;
import org.eclipse.linuxtools.tmf.core.statesystem.StateSystemBuildRequest;

public class HistoryBuilder
extends TmfComponent {
    private static final Semaphore hbSem = new Semaphore(1);
    private ITmfEventRequest<CtfTmfEvent> currentRequest = null;
    private boolean isRunning = false;
    private final IStateChangeInput sci;
    private final StateHistorySystem shs;
    private final IStateHistoryBackend hb;

    public HistoryBuilder(IStateChangeInput stateChangeInput, IStateHistoryBackend backend) throws IOException {
        if (stateChangeInput == null || backend == null) {
            throw new IllegalArgumentException();
        }
        this.sci = stateChangeInput;
        this.hb = backend;
        this.shs = new StateHistorySystem(this.hb, true);
        this.sci.assignTargetStateSystem(this.shs);
    }

    public static IStateSystemBuilder openExistingHistory(IStateHistoryBackend hb) throws IOException {
        return new StateHistorySystem(hb, false);
    }

    public IStateSystemBuilder getStateSystemBuilder() {
        return this.shs;
    }

    public IStateSystemQuerier getStateSystemQuerier() {
        return this.shs;
    }

    @TmfSignalHandler
    public void startBuilding(TmfExperimentRangeUpdatedSignal signal) {
        if (!this.isRunning) {
            hbSem.acquireUninterruptibly();
            this.currentRequest = new StateSystemBuildRequest(this);
            this.isRunning = true;
            this.sci.getTrace().sendRequest(this.currentRequest);
        }
    }

    @TmfSignalHandler
    public void cancelCurrentBuild(TmfExperimentSelectedSignal<? extends ITmfEvent> signal) {
        if (this.isRunning && this.currentRequest != null) {
            this.currentRequest.cancel();
        }
    }

    IStateChangeInput getInputPlugin() {
        return this.sci;
    }

    void finish(boolean deleteFile) {
        this.sci.dispose();
        if (deleteFile) {
            this.hb.removeFiles();
        }
        this.currentRequest = null;
        this.isRunning = false;
        TmfSignalManager.deregister(this);
        hbSem.release();
    }
}

