/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog;

import java.io.File;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ClientSession;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ScpClient;
import org.eclipse.linuxtools.systemtap.ui.consolelog.dialogs.ErrorMessage;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.DMRequest;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.DMResponse;
import org.eclipse.linuxtools.systemtap.ui.structures.LoggingStreamDaemon;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IGobblerListener;
import org.eclipse.linuxtools.systemtap.ui.structures.runnable.StreamGobbler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscription
extends Thread {
    private int scriptid;
    private boolean running;
    private final ClientSession session;
    private final String filename;
    private final boolean isGuru;
    private boolean disposed = false;
    private PipedOutputStream pos = null;
    private PipedInputStream pis = null;
    private StreamGobbler inputGobbler = null;
    private StreamGobbler errorGobbler = null;
    private ArrayList<IGobblerListener> inputListeners = new ArrayList();
    private ArrayList<IGobblerListener> errorListeners = new ArrayList();
    private LoggingStreamDaemon logger;

    public Subscription(int scriptid) {
        this.scriptid = scriptid;
        this.filename = null;
        this.running = false;
        this.session = ClientSession.getInstance();
        this.isGuru = false;
    }

    public Subscription(String filename, boolean isGuru) {
        this.filename = filename;
        this.scriptid = -1;
        this.running = false;
        this.session = ClientSession.getInstance();
        this.isGuru = isGuru;
    }

    public boolean init() {
        if (!ClientSession.isConnected()) {
            return false;
        }
        try {
            ScpClient scpclient = new ScpClient();
            scpclient.transfer(this.filename, "/tmp/" + this.filename.substring(this.filename.lastIndexOf(47) + 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.scriptid = ClientSession.getNewScriptId();
        DMRequest subreq = new DMRequest(2, this.scriptid, this.filename, this.session.getcid(), 0, this.isGuru);
        this.session.sendRequest(subreq);
        this.session.addSubscription(this.scriptid);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        DMResponse subrep = this.session.recvResponse(this.scriptid);
        if (subrep.isValid()) {
            this.scriptid = subrep.getscriptID();
            this.logger = new LoggingStreamDaemon();
            this.inputListeners.add((IGobblerListener)this.logger);
            try {
                this.pos = new PipedOutputStream();
                this.pis = new PipedInputStream(this.pos);
                this.pos.flush();
            }
            catch (Exception exception) {
                new ErrorMessage("Could not subscribe!", "See stderr for more details").open();
            }
            this.inputGobbler = new StreamGobbler((InputStream)this.pis);
            this.addInputStreamListener((IGobblerListener)this.logger);
            return true;
        }
        this.session.delSubscription(this.scriptid);
        new ErrorMessage("Could not subscribe!", "Response from Server not valid \n See stderr for more details").open();
        return false;
    }

    @Override
    public void run() {
        DMRequest unsub;
        this.running = true;
        DMResponse subrep = null;
        this.inputGobbler.start();
        while (!Thread.interrupted() && ClientSession.isConnected()) {
            String str;
            int n;
            int n2;
            String[] stringArray;
            String[] lines;
            String outp;
            subrep = this.session.recvResponse(this.scriptid);
            if (subrep == null) break;
            if (subrep.isValid() && subrep.getsource() == 2) {
                outp = new String(this.session.recvData(this.scriptid, subrep.getsize()));
                stringArray = lines = outp.trim().split("\n");
                n2 = lines.length;
                n = 0;
                while (n < n2) {
                    str = stringArray[n];
                    try {
                        this.inputGobbler.fireNewDataEvent(String.valueOf(str) + "\n");
                    }
                    catch (Exception e) {
                        System.err.println(e.toString());
                    }
                    ++n;
                }
                return;
            }
            if (!subrep.isValid()) continue;
            outp = new String(this.session.recvData(this.scriptid, subrep.getsize()));
            stringArray = lines = outp.trim().split("\n");
            n2 = lines.length;
            n = 0;
            while (n < n2) {
                str = stringArray[n];
                try {
                    this.inputGobbler.fireNewDataEvent(String.valueOf(str) + "\n");
                }
                catch (Exception e) {
                    System.err.println(e.toString());
                }
                ++n;
            }
        }
        if (!this.session.sendRequest(unsub = new DMRequest(3, this.scriptid, this.session.getcid(), 0))) {
            System.err.println("Failed Unsubscribing: " + this.session.getcid());
        }
        subrep = this.session.recvResponse(this.scriptid);
        this.delSubscription();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getScriptName(int script) {
        return "table" + script;
    }

    public String getOutput() {
        return this.logger.getOutput();
    }

    public boolean saveLog(File file) {
        return this.logger.saveLog(file);
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.inputListeners = null;
            this.errorListeners = null;
            if (this.inputGobbler != null) {
                this.inputGobbler.dispose();
                this.inputGobbler.stop();
            }
            this.inputGobbler = null;
            if (this.errorGobbler != null) {
                this.errorGobbler.dispose();
                this.errorGobbler.stop();
            }
            this.errorGobbler = null;
        }
    }

    public void addInputStreamListener(IGobblerListener listener) {
        if (this.inputGobbler != null) {
            this.inputGobbler.addDataListener(listener);
        } else {
            this.inputListeners.add(listener);
        }
    }

    public void addErrorStreamListener(IGobblerListener listener) {
        if (this.errorGobbler != null) {
            this.errorGobbler.addDataListener(listener);
        } else {
            this.errorListeners.add(listener);
        }
    }

    public ArrayList<IGobblerListener> getInputStreamListeners() {
        if (this.inputGobbler != null) {
            return this.inputListeners;
        }
        return this.inputGobbler.getDataListeners();
    }

    public ArrayList<IGobblerListener> getErrorStreamListeners() {
        if (this.errorGobbler != null) {
            return this.errorListeners;
        }
        return this.errorGobbler.getDataListeners();
    }

    public void removeInputStreamListener(IGobblerListener listener) {
        if (this.inputGobbler != null) {
            this.inputGobbler.removeDataListener(listener);
        } else {
            this.inputListeners.remove(listener);
        }
    }

    public void removeErrorStreamListener(IGobblerListener listener) {
        if (this.errorGobbler != null) {
            this.errorGobbler.removeDataListener(listener);
        } else {
            this.errorListeners.remove(listener);
        }
    }

    public void delSubscription() {
        this.session.delSubscription(this.scriptid);
    }
}

