/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.state.model;

public class LttngSoftIRQState
implements Cloneable {
    private Long pending = 0L;
    private Long running = 0L;

    public LttngSoftIRQState clone() {
        LttngSoftIRQState newState = null;
        try {
            newState = (LttngSoftIRQState)super.clone();
            newState.pending = this.pending;
            newState.running = this.running;
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Cloning failed with : " + e.getMessage());
        }
        return newState;
    }

    public void setPending(Long pending) {
        this.pending = pending;
    }

    public Long getPending() {
        return this.pending;
    }

    public void setRunning(Long running) {
        this.running = running;
    }

    public Long getRunning() {
        return this.running;
    }

    public void reset() {
        this.pending = 0L;
        this.running = 0L;
    }

    public void incrementRunning() {
        this.running = this.running + 1L;
    }

    public void incrementPending() {
        this.pending = this.pending + 1L;
    }

    public void decrementRunning() {
        if (this.running > 0L) {
            this.running = this.running - 1L;
        }
    }

    public void decrementPending() {
        if (this.pending > 0L) {
            this.pending = this.pending - 1L;
        }
    }
}

