/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.editor.actions.file;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.systemtap.ui.editor.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.editor.RecentFileLog;
import org.eclipse.linuxtools.internal.systemtap.ui.editor.actions.EditorAction;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenFileAction
extends EditorAction {
    private boolean successful;

    public OpenFileAction() {
        this.setEnabled(true);
        this.successful = false;
    }

    public void run(IAction act) {
        this.run();
    }

    public void run() {
        File file;
        this.successful = false;
        if (this.window == null) {
            this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        if ((file = this.queryFile()) != null) {
            IEditorInput input = this.createEditorInput(file);
            String editorId = this.getEditorId(file);
            IWorkbenchPage page = this.window.getActivePage();
            try {
                page.openEditor(input, editorId);
                RecentFileLog.updateRecentFiles(file);
                this.successful = true;
            }
            catch (PartInitException partInitException) {}
        } else if (file != null) {
            String msg = MessageFormat.format(Localization.getString("OpenFileAction.FileIsNull"), file.getName());
            MessageDialog.openWarning((Shell)this.window.getShell(), (String)Localization.getString("OpenFileAction.Problem"), (String)msg);
        }
    }

    protected File queryFile() {
        FileDialog dialog = new FileDialog(this.window.getShell(), 4096);
        dialog.setText(Localization.getString("OpenFileAction.OpenFile"));
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            return new File(path);
        }
        return null;
    }

    protected String getEditorId(File file) {
        IEditorDescriptor[] descriptors;
        IWorkbench workbench = this.window.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor[] iEditorDescriptorArray = descriptors = editorRegistry.getEditors(file.getName());
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor d = iEditorDescriptorArray[n2];
            if (d.getId().startsWith("org.eclipse.linuxtools.systemtap.ui.ide.editors") || d.getId().startsWith("org.eclipse.linuxtools.internal.systemtap.ui.ide.editors")) {
                return d.getId();
            }
            ++n2;
        }
        return "org.eclipse.linuxtools.systemtap.ui.editor.SimpleEditor";
    }

    protected IEditorInput createEditorInput(File file) {
        Path location = new Path(file.getAbsolutePath());
        PathEditorInput input = new PathEditorInput((IPath)location);
        return input;
    }

    public boolean isSuccessful() {
        return this.successful;
    }
}

