/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.SequenceDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.internal.ctf.core.event.io.BitBuffer;

public class SequenceDefinition
extends Definition {
    private final SequenceDeclaration declaration;
    private final IntegerDefinition lengthDefinition;
    private Definition[] definitions;
    private int currentLength;

    public SequenceDefinition(SequenceDeclaration declaration, IDefinitionScope definitionScope, String fieldName) throws CTFReaderException {
        super(definitionScope, fieldName);
        Definition lenDef = null;
        this.declaration = declaration;
        if (definitionScope != null) {
            lenDef = definitionScope.lookupDefinition(declaration.getLengthName());
        }
        if (lenDef == null) {
            throw new CTFReaderException("Sequence length field not found");
        }
        if (!(lenDef instanceof IntegerDefinition)) {
            throw new CTFReaderException("Sequence length field not integer");
        }
        this.lengthDefinition = (IntegerDefinition)lenDef;
        if (this.lengthDefinition.getDeclaration().isSigned()) {
            throw new CTFReaderException("Sequence length must not be signed");
        }
    }

    public SequenceDeclaration getDeclaration() {
        return this.declaration;
    }

    public int getLength() {
        return this.currentLength;
    }

    public Definition getElem(int i) {
        if (i > this.definitions.length) {
            return null;
        }
        return this.definitions[i];
    }

    public boolean isString() {
        IntegerDeclaration elemInt;
        return this.declaration.getElementType() instanceof IntegerDeclaration && (elemInt = (IntegerDeclaration)this.declaration.getElementType()).isCharacter();
    }

    @Override
    public void read(BitBuffer input) {
        this.currentLength = (int)this.lengthDefinition.getValue();
        if (this.definitions == null || this.definitions.length < this.currentLength) {
            Definition[] newDefinitions = new Definition[this.currentLength];
            int i = 0;
            if (this.definitions != null) {
                while (i < this.definitions.length) {
                    newDefinitions[i] = this.definitions[i];
                    ++i;
                }
            }
            while (i < this.currentLength) {
                newDefinitions[i] = this.declaration.getElementType().createDefinition(this.definitionScope, String.valueOf(this.fieldName) + "[" + i + "]");
                ++i;
            }
            this.definitions = newDefinitions;
        }
        int i = 0;
        while (i < this.currentLength) {
            this.definitions[i].read(input);
            ++i;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isString()) {
            int i = 0;
            while (i < this.currentLength) {
                IntegerDefinition character = (IntegerDefinition)this.definitions[i];
                if (character.getValue() != 0L) {
                    b.append(character.toString());
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            b.append('[');
            if (this.currentLength > 0) {
                int i = 0;
                while (i < this.currentLength - 1) {
                    b.append(' ');
                    b.append(this.definitions[i].toString());
                    b.append(',');
                    ++i;
                }
                b.append(' ');
                b.append(this.definitions[this.currentLength - 1].toString());
            }
            b.append(" ]");
        }
        return b.toString();
    }
}

