/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.systemtapgui;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.systemtapgui.internal.Localization;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.part.CoolItemGroupMarker;

public final class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private IContributionItem views;
    private IContributionItem perspectives;

    public ApplicationActionBarAdvisor(IActionBarConfigurer actionBarConfigurer) {
        super(actionBarConfigurer);
        LogManager.logDebug((String)("Start/End ApplicationActionBarAdvisor: actionBarConfigurer-" + actionBarConfigurer), (Object)((Object)this));
    }

    protected void fillCoolBar(ICoolBarManager cbManager) {
        LogManager.logDebug((String)("Start fillCollBar: cbManager-" + cbManager), (Object)((Object)this));
        cbManager.add((IContributionItem)new GroupMarker("group.file"));
        ToolBarManager fileToolBar = new ToolBarManager(cbManager.getStyle());
        fileToolBar.add((IContributionItem)new Separator("fileStart"));
        fileToolBar.add((IContributionItem)new GroupMarker("new.group"));
        fileToolBar.add((IContributionItem)new GroupMarker("new.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("open.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("import.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("export.ext"));
        fileToolBar.add((IContributionItem)new Separator("save.group"));
        fileToolBar.add((IContributionItem)new GroupMarker("save.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("print.ext"));
        fileToolBar.add((IContributionItem)new Separator("fileEnd"));
        fileToolBar.add((IContributionItem)new Separator("editStart"));
        fileToolBar.add((IContributionItem)new GroupMarker("cut.ext"));
        fileToolBar.add((IContributionItem)new Separator("editEnd"));
        fileToolBar.add((IContributionItem)new GroupMarker("history.group"));
        fileToolBar.add((IContributionItem)new Separator("build.group"));
        fileToolBar.add((IContributionItem)new CoolItemGroupMarker("build.ext"));
        fileToolBar.add((IContributionItem)new CoolItemGroupMarker("stop.ext"));
        fileToolBar.add((IContributionItem)new Separator("additions"));
        cbManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)fileToolBar, "org.eclipse.ui.workbench.file"));
        cbManager.add((IContributionItem)new GroupMarker("additions"));
        cbManager.add((IContributionItem)new GroupMarker("group.editor"));
        LogManager.logDebug((String)"End fillCoolBar:", (Object)((Object)this));
    }

    protected void fillMenuBar(IMenuManager menubar) {
        LogManager.logDebug((String)("Start fillMenuBar: menubar-" + menubar), (Object)((Object)this));
        menubar.add((IContributionItem)this.createFakeFileMenu());
        menubar.add((IContributionItem)this.createFakeHelpMenu());
        menubar.add((IContributionItem)this.createFileMenu());
        menubar.add((IContributionItem)this.createEditMenu());
        menubar.add((IContributionItem)this.createNavigateMenu());
        menubar.add((IContributionItem)this.createBuildMenu());
        menubar.add((IContributionItem)this.createWindowMenu());
        menubar.add((IContributionItem)new GroupMarker("additions"));
        menubar.add((IContributionItem)this.createHelpMenu());
        LogManager.logDebug((String)"End fillMenuBar:", (Object)((Object)this));
    }

    private MenuManager createFakeFileMenu() {
        LogManager.logDebug((String)"Start createFakeFileMenu:", (Object)((Object)this));
        MenuManager menu = new MenuManager(Localization.getString("ApplicationActionBarAdvisor.File"), "file");
        menu.setVisible(false);
        LogManager.logDebug((String)"End createFakeFileMenu:", (Object)((Object)this));
        return menu;
    }

    private MenuManager createFakeHelpMenu() {
        LogManager.logDebug((String)"Start createFakeHelpMenu:", (Object)((Object)this));
        MenuManager menu = new MenuManager(Localization.getString("ApplicationActionBarAdvisor.Help"), "help");
        menu.setVisible(false);
        LogManager.logDebug((String)"End createFakeHelpMenu:", (Object)((Object)this));
        return menu;
    }

    private MenuManager createFileMenu() {
        LogManager.logDebug((String)"Start createFileMenu:", (Object)((Object)this));
        MenuManager menu = new MenuManager(Localization.getString("ApplicationActionBarAdvisor.File"), "file2");
        menu.add((IContributionItem)new Separator("fileStart"));
        menu.add((IContributionItem)new Separator("new.ext"));
        menu.add((IContributionItem)new Separator("close.ext"));
        menu.add((IContributionItem)new Separator("save.ext"));
        menu.add((IContributionItem)new Separator("print.ext"));
        menu.add((IContributionItem)new Separator("import.ext"));
        menu.add((IContributionItem)new GroupMarker("export.ext"));
        menu.add((IContributionItem)new Separator("recentFiles.ext"));
        menu.add((IContributionItem)new Separator("close.ext"));
        menu.add(this.getAction(ActionFactory.QUIT.getId()));
        menu.add((IContributionItem)new Separator("fileEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        LogManager.logDebug((String)("End createFileMenu: returnVal-" + menu), (Object)((Object)this));
        return menu;
    }

    private MenuManager createEditMenu() {
        LogManager.logDebug((String)"Start createEditMenu:", (Object)((Object)this));
        MenuManager menu = new MenuManager(Localization.getString("ApplicationActionBarAdvisor.Edit"), "edit");
        menu.add((IContributionItem)new Separator("editStart"));
        menu.add((IContributionItem)new Separator("undo.ext"));
        menu.add((IContributionItem)new Separator("cut.ext"));
        menu.add((IContributionItem)new Separator("find.ext"));
        menu.add((IContributionItem)new Separator("add.ext"));
        menu.add((IContributionItem)new Separator("editEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        LogManager.logDebug((String)("End createEditMenu: returnVal-" + menu), (Object)((Object)this));
        return menu;
    }

    private MenuManager createNavigateMenu() {
        LogManager.logDebug((String)"Start createNavigateMenu:", (Object)((Object)this));
        MenuManager menu = new MenuManager(Localization.getString("ApplicationActionBarAdvisor.Navigate"), "navigate");
        menu.add((IContributionItem)new Separator("navStart"));
        menu.add(this.getAction(ActionFactory.FORWARD_HISTORY.getId()));
        menu.add(this.getAction(ActionFactory.BACKWARD_HISTORY.getId()));
        menu.add((IContributionItem)new Separator("navEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        LogManager.logDebug((String)("End createNavigateMenu: returnVal-" + menu), (Object)((Object)this));
        return menu;
    }

    private MenuManager createBuildMenu() {
        LogManager.logDebug((String)"Start createBuildMenu:", (Object)((Object)this));
        MenuManager menu = new MenuManager(Localization.getString("ApplicationActionBarAdvisor.Run"), "launch");
        menu.add((IContributionItem)new Separator("wbStart"));
        menu.add((IContributionItem)new GroupMarker("build.group"));
        menu.add((IContributionItem)new GroupMarker("build.ext"));
        menu.add((IContributionItem)new Separator("build.stop"));
        menu.add((IContributionItem)new Separator("wbEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        LogManager.logDebug((String)("End createBuildMenu: returnVal-" + menu), (Object)((Object)this));
        return menu;
    }

    private MenuManager createWindowMenu() {
        LogManager.logDebug((String)"Start createWindowMenu:", (Object)((Object)this));
        MenuManager menu = new MenuManager(Localization.getString("ApplicationActionBarAdvisor.Window"), "window");
        menu.add((IContributionItem)new Separator("projStart"));
        menu.add(this.getAction(ActionFactory.OPEN_NEW_WINDOW.getId()));
        menu.add((IContributionItem)new Separator("perspective.ext"));
        MenuManager menuPerspectives = new MenuManager(Localization.getString("ApplicationActionBarAdvisor.OpenPerspective"));
        menuPerspectives.add(this.perspectives);
        menu.add((IContributionItem)menuPerspectives);
        menu.add((IContributionItem)new GroupMarker("additions"));
        MenuManager menuViews = new MenuManager(Localization.getString("ApplicationActionBarAdvisor.ShowViews"));
        menuViews.add(this.views);
        menu.add((IContributionItem)menuViews);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("projEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add(this.getAction(ActionFactory.PREFERENCES.getId()));
        LogManager.logDebug((String)("End createWindowMenu: returnVal-" + menu), (Object)((Object)this));
        return menu;
    }

    private MenuManager createHelpMenu() {
        LogManager.logDebug((String)"Start createHelpMenu:", (Object)((Object)this));
        MenuManager menu = new MenuManager(Localization.getString("ApplicationActionBarAdvisor.Help"), "help2");
        menu.add((IContributionItem)new Separator("helpStart"));
        menu.add(this.getAction(ActionFactory.HELP_CONTENTS.getId()));
        menu.add(this.getAction(ActionFactory.HELP_SEARCH.getId()));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("helpEnd"));
        menu.add(this.getAction(ActionFactory.ABOUT.getId()));
        LogManager.logDebug((String)("End createHelpMenu: returnVal-" + menu), (Object)((Object)this));
        return menu;
    }

    protected void makeActions(IWorkbenchWindow window) {
        LogManager.logDebug((String)("Start makeActions: window-" + window), (Object)((Object)this));
        this.registerAsGlobal((IAction)ActionFactory.QUIT.create(window));
        this.registerAsGlobal((IAction)ActionFactory.FIND.create(window));
        this.registerAsGlobal((IAction)ActionFactory.OPEN_NEW_WINDOW.create(window));
        this.registerAsGlobal((IAction)ActionFactory.PREFERENCES.create(window));
        this.registerAsGlobal((IAction)ActionFactory.FORWARD_HISTORY.create(window));
        this.registerAsGlobal((IAction)ActionFactory.BACKWARD_HISTORY.create(window));
        this.registerAsGlobal((IAction)ActionFactory.ABOUT.create(window));
        this.registerAsGlobal((IAction)ActionFactory.HELP_CONTENTS.create(window));
        this.registerAsGlobal((IAction)ActionFactory.HELP_SEARCH.create(window));
        this.views = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        this.perspectives = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window);
        LogManager.logDebug((String)"End makeActions:", (Object)((Object)this));
    }

    private void registerAsGlobal(IAction action) {
        LogManager.logDebug((String)("Start registerAsGlobal: action-" + action), (Object)((Object)this));
        this.getActionBarConfigurer().registerGlobalAction(action);
        this.register(action);
        LogManager.logDebug((String)"End registerAsGlobal:", (Object)((Object)this));
    }
}

