/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.UUID;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.linuxtools.ctf.core.event.metadata.IOStructGen;
import org.eclipse.linuxtools.ctf.core.event.metadata.exceptions.ParseException;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.ctf.core.trace.Utils;
import org.eclipse.linuxtools.ctf.parser.CTFLexer;
import org.eclipse.linuxtools.ctf.parser.CTFParser;

public class Metadata {
    final String METADATA_FILENAME = "metadata";
    final int METADATA_PACKET_HEADER_SIZE = 37;
    private File metadataFile = null;
    private ByteOrder detectedByteOrder = null;
    private CTFTrace trace = null;

    public Metadata(CTFTrace trace) {
        this.trace = trace;
        String metadataPath = String.valueOf(trace.getTraceDirectory().getPath()) + Utils.SEPARATOR + "metadata";
        this.metadataFile = new File(metadataPath);
    }

    public ByteOrder getDetectedByteOrder() {
        return this.detectedByteOrder;
    }

    public void parse() throws CTFReaderException {
        CTFParser.parse_return ret;
        ANTLRReaderStream antlrStream;
        FileChannel metadataFileChannel;
        try {
            metadataFileChannel = new FileInputStream(this.metadataFile).getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CTFReaderException("Cannot find metadata file!");
        }
        Reader metadataTextInput = null;
        if (this.isPacketBased(metadataFileChannel)) {
            StringBuffer metadataText = new StringBuffer();
            MetadataPacketHeader packetHeader = this.readMetadataPacket(metadataFileChannel, metadataText);
            while (packetHeader != null) {
                packetHeader = this.readMetadataPacket(metadataFileChannel, metadataText);
            }
            metadataTextInput = new StringReader(metadataText.toString());
        } else {
            try {
                metadataTextInput = new FileReader(this.metadataFile);
            }
            catch (FileNotFoundException e) {
                throw new CTFReaderException(e);
            }
        }
        try {
            antlrStream = new ANTLRReaderStream(metadataTextInput);
        }
        catch (IOException e) {
            throw new CTFReaderException(e);
        }
        CTFLexer ctfLexer = new CTFLexer((CharStream)antlrStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)ctfLexer);
        CTFParser ctfParser = new CTFParser((TokenStream)tokens, false);
        try {
            ret = ctfParser.parse();
        }
        catch (RecognitionException e) {
            throw new CTFReaderException((Exception)((Object)e));
        }
        CommonTree tree = (CommonTree)ret.getTree();
        IOStructGen gen = new IOStructGen(tree, this.trace);
        try {
            gen.generate();
        }
        catch (ParseException e) {
            throw new CTFReaderException(e);
        }
    }

    private boolean isPacketBased(FileChannel metadataFileChannel) throws CTFReaderException {
        ByteBuffer magicByteBuffer = ByteBuffer.allocate(4);
        try {
            metadataFileChannel.read(magicByteBuffer, 0L);
        }
        catch (IOException iOException) {
            throw new CTFReaderException("Unable to read metadata file channel.");
        }
        int magic = magicByteBuffer.getInt(0);
        if (1976638807 == magic) {
            this.detectedByteOrder = ByteOrder.BIG_ENDIAN;
            return true;
        }
        magicByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        magic = magicByteBuffer.getInt(0);
        if (1976638807 == magic) {
            this.detectedByteOrder = ByteOrder.LITTLE_ENDIAN;
            return true;
        }
        return false;
    }

    private MetadataPacketHeader readMetadataPacket(FileChannel metadataFileChannel, StringBuffer metadataText) throws CTFReaderException {
        int nbBytesRead;
        ByteBuffer headerByteBuffer = ByteBuffer.allocate(37);
        try {
            nbBytesRead = metadataFileChannel.read(headerByteBuffer);
        }
        catch (IOException iOException) {
            throw new CTFReaderException("Error reading the metadata header.");
        }
        if (nbBytesRead < 0) {
            return null;
        }
        headerByteBuffer.position(0);
        headerByteBuffer.order(this.detectedByteOrder);
        assert (nbBytesRead == 37);
        MetadataPacketHeader header = new MetadataPacketHeader();
        header.magic = headerByteBuffer.getInt();
        headerByteBuffer.get(header.uuid);
        header.checksum = headerByteBuffer.getInt();
        header.contentSize = headerByteBuffer.getInt();
        header.packetSize = headerByteBuffer.getInt();
        header.compressionScheme = headerByteBuffer.get();
        header.encryptionScheme = headerByteBuffer.get();
        header.checksumScheme = headerByteBuffer.get();
        header.ctfMajorVersion = headerByteBuffer.get();
        header.ctfMinorVersion = headerByteBuffer.get();
        if (header.magic != 1976638807) {
            throw new CTFReaderException("TSDL magic number does not match");
        }
        UUID uuid = Utils.makeUUID(header.uuid);
        if (!this.trace.UUIDIsSet()) {
            this.trace.setUUID(uuid);
        } else if (!this.trace.getUUID().equals(uuid)) {
            throw new CTFReaderException("UUID mismatch");
        }
        int payloadSize = header.contentSize / 8 - 37;
        int skipSize = (header.packetSize - header.contentSize) / 8;
        ByteBuffer payloadByteBuffer = ByteBuffer.allocateDirect(payloadSize + skipSize);
        try {
            metadataFileChannel.read(payloadByteBuffer);
        }
        catch (IOException iOException) {
            throw new CTFReaderException("Error reading metadata packet payload.");
        }
        payloadByteBuffer.rewind();
        byte[] payloadByteArray = new byte[payloadByteBuffer.remaining()];
        payloadByteBuffer.get(payloadByteArray, 0, payloadSize);
        String str = new String(payloadByteArray, 0, payloadSize);
        metadataText.append(str);
        return header;
    }

    static class MetadataPacketHeader {
        public int magic;
        public byte[] uuid = new byte[16];
        public int checksum;
        public int contentSize;
        public int packetSize;
        public byte compressionScheme;
        public byte encryptionScheme;
        public byte checksumScheme;
        public byte ctfMajorVersion;
        public byte ctfMinorVersion;

        MetadataPacketHeader() {
        }

        public String toString() {
            return "MetadataPacketHeader [magic=0x" + Integer.toHexString(this.magic) + ", uuid=" + Arrays.toString(this.uuid) + ", checksum=" + this.checksum + ", contentSize=" + this.contentSize + ", packetSize=" + this.packetSize + ", compressionScheme=" + this.compressionScheme + ", encryptionScheme=" + this.encryptionScheme + ", checksumScheme=" + this.checksumScheme + ", ctfMajorVersion=" + this.ctfMajorVersion + ", ctfMinorVersion=" + this.ctfMinorVersion + ']';
        }
    }
}

