/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.treeviewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.callgraph.StapData;
import org.eclipse.linuxtools.internal.callgraph.StapGraph;

public class StapTreeContentProvider
implements ITreeContentProvider {
    private StapGraph graph;

    public Object[] getChildren(Object parentElement) {
        ArrayList<StapData> EMPTY = new ArrayList<StapData>();
        if (parentElement instanceof StapData) {
            StapData parent = (StapData)parentElement;
            List<Integer> childrenIDs = parent.collapsedChildren;
            for (int val : childrenIDs) {
                if (this.graph.getNodeData(val) == null) continue;
                EMPTY.add(this.graph.getNodeData(val));
            }
        }
        return EMPTY.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof StapData) {
            return this.graph.getNodeData(((StapData)element).collapsedParent);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof StapData) {
            return element == null ? false : ((StapData)element).children.size() > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setGraph(StapGraph graph) {
        this.graph = graph;
    }
}

