/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.structures;

import java.util.StringTokenizer;

public final class Query {
    public String tableName;
    public String where;
    public String groupBy;
    public String orderBy;
    public String[] columnNames;
    public String[] newColumnNames;

    private Query() {
        this.where = null;
        this.groupBy = null;
        this.orderBy = null;
        this.newColumnNames = null;
    }

    public Query(String tableName, String[] columnNames) {
        this();
        this.tableName = tableName;
        this.columnNames = columnNames;
    }

    public Query(Query query) {
        this.tableName = query.tableName;
        this.columnNames = query.columnNames;
        this.newColumnNames = query.newColumnNames;
        this.where = query.where;
        this.groupBy = query.groupBy;
        this.orderBy = query.orderBy;
    }

    public Query(String tableName) {
        this();
        this.tableName = tableName;
        this.columnNames = null;
    }

    public Query(String tableName, String[] columnNames, String[] newColumnNames, String where, String groupBy, String orderBy) {
        this.tableName = tableName;
        this.columnNames = columnNames;
        this.newColumnNames = newColumnNames;
        this.where = where;
        this.groupBy = groupBy;
        this.orderBy = orderBy;
    }

    public String toString() {
        return this.buildQuery(this.tableName, this.columnNames, this.newColumnNames, this.where, this.groupBy, this.orderBy);
    }

    private String buildQuery(String tableName, String[] fields, String[] columnNames, String whereClauses, String groupBy, String orderBy) {
        String query = "SELECT ";
        if (fields == null) {
            query = String.valueOf(query) + "* ";
        } else {
            int i = 0;
            while (i < fields.length) {
                query = String.valueOf(query) + fields[i];
                if (columnNames != null && columnNames.length == fields.length) {
                    query = String.valueOf(query) + " AS " + columnNames[i];
                }
                if (i != fields.length - 1) {
                    query = String.valueOf(query) + ", ";
                }
                ++i;
            }
        }
        query = String.valueOf(query) + " FROM " + tableName;
        if (whereClauses != null) {
            query = String.valueOf(query) + " WHERE " + whereClauses;
        }
        if (groupBy != null) {
            query = String.valueOf(query) + " GROUP BY " + groupBy;
        }
        if (orderBy != null) {
            query = String.valueOf(query) + " ORDER BY " + orderBy;
        }
        return query;
    }

    public String toSavableQueryString() {
        String element;
        int n;
        int n2;
        String[] stringArray;
        String query = String.valueOf(this.tableName) + ":: COLS ";
        if (this.columnNames != null) {
            stringArray = this.columnNames;
            n2 = this.columnNames.length;
            n = 0;
            while (n < n2) {
                element = stringArray[n];
                query = String.valueOf(query) + element + " ";
                ++n;
            }
        } else {
            query = String.valueOf(query) + "*";
        }
        query = String.valueOf(query) + ":: NEW_COLS ";
        if (this.columnNames != null) {
            stringArray = this.newColumnNames;
            n2 = this.newColumnNames.length;
            n = 0;
            while (n < n2) {
                element = stringArray[n];
                query = String.valueOf(query) + element + " ";
                ++n;
            }
        }
        query = String.valueOf(query) + ":: WHERE " + this.where;
        query = String.valueOf(query) + ":: GROUP " + this.groupBy;
        query = String.valueOf(query) + ":: ORDER " + this.orderBy;
        return query;
    }

    public static Query getQueryFromString(String query) {
        if (query == null) {
            return null;
        }
        String[] subQuery = query.split("::");
        Query tempQuery = new Query(subQuery[0]);
        int i = 1;
        while (i < subQuery.length) {
            int j;
            String next;
            StringTokenizer tok;
            String temp;
            subQuery[i] = subQuery[i].trim();
            if (subQuery[i].startsWith("COLS ")) {
                temp = subQuery[i].replace("COLS ", "");
                tok = new StringTokenizer(temp = temp.trim());
                next = tok.nextToken();
                if (next.equals("null") || next.equals("*")) {
                    tempQuery.columnNames = null;
                } else {
                    tempQuery.columnNames = new String[tok.countTokens() + 1];
                    tempQuery.columnNames[0] = next;
                    j = 1;
                    while (j < tempQuery.columnNames.length) {
                        tempQuery.columnNames[j] = tok.nextToken();
                        ++j;
                    }
                }
            } else if (subQuery[i].startsWith("NEW_COLS ")) {
                temp = subQuery[i].replace("NEW_COLS ", "");
                tok = new StringTokenizer(temp = temp.trim());
                next = tok.nextToken();
                if (next.equals("null")) {
                    tempQuery.newColumnNames = null;
                } else {
                    tempQuery.newColumnNames = new String[tok.countTokens() + 1];
                    tempQuery.newColumnNames[0] = next;
                    j = 1;
                    while (j < tempQuery.newColumnNames.length) {
                        tempQuery.newColumnNames[j] = tok.nextToken();
                        ++j;
                    }
                }
            } else if (subQuery[i].startsWith("WHERE ")) {
                temp = subQuery[i].replace("WHERE ", "");
                tempQuery.where = (temp = temp.trim()).equals("null") ? null : temp;
            } else if (subQuery[i].startsWith("GROUP ")) {
                temp = subQuery[i].replace("GROUP ", "");
                tempQuery.groupBy = (temp = temp.trim()).equals("null") ? null : temp;
            } else if (subQuery[i].startsWith("ORDER ")) {
                temp = subQuery[i].replace("ORDER ", "");
                tempQuery.orderBy = (temp = temp.trim()).equals("null") ? null : temp;
            }
            ++i;
        }
        return tempQuery;
    }
}

