/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphicalrun.actions;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ScpClient;
import org.eclipse.linuxtools.systemtap.ui.consolelog.dialogs.SelectServerDialog;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.IErrorParser;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.linuxtools.systemtap.ui.graphicalrun.structures.ChartStreamDaemon2;
import org.eclipse.linuxtools.systemtap.ui.graphing.GraphingConstants;
import org.eclipse.linuxtools.systemtap.ui.graphing.GraphingPerspective;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetWizard;
import org.eclipse.linuxtools.systemtap.ui.ide.IDESessionSettings;
import org.eclipse.linuxtools.systemtap.ui.ide.actions.RunScriptAction;
import org.eclipse.linuxtools.systemtap.ui.ide.structures.StapErrorParser;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.IPasswordPrompt;
import org.eclipse.linuxtools.systemtap.ui.structures.PasswordPrompt;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IGobblerListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class RunScriptChartAction
extends RunScriptAction
implements IWorkbenchWindowActionDelegate {
    private IDataSet dataSet = null;
    private IDataSetParser parser = null;

    public RunScriptChartAction() {
        LogManager.logDebug((String)"initialized", (Object)((Object)this));
    }

    public void dispose() {
        LogManager.logDebug((String)"disposed", (Object)((Object)this));
        super.dispose();
    }

    public void run() {
        LogManager.logDebug((String)"Start run:", (Object)((Object)this));
        this.continueRun = true;
        if (!ConsoleLogPlugin.getDefault().getPluginPreferences().getBoolean("rememberServer")) {
            new SelectServerDialog(this.fWindow.getShell()).open();
        }
        if (this.isValid()) {
            try {
                ScpClient scpclient = new ScpClient();
                this.serverfileName = this.fileName.substring(this.fileName.lastIndexOf(47) + 1);
                this.tmpfileName = "/tmp/" + this.serverfileName;
                scpclient.transfer(this.fileName, this.tmpfileName);
            }
            catch (Exception exception) {
                this.continueRun = false;
            }
            String[] script = null;
            if (this.continueRun) {
                script = this.buildScript();
            }
            if (this.continueRun) {
                String[] envVars = this.getEnvironmentVariables();
                ScriptConsole console = ScriptConsole.getInstance((String)this.serverfileName);
                console.run(script, envVars, (IPasswordPrompt)new PasswordPrompt(IDESessionSettings.password), (IErrorParser)new StapErrorParser());
                console.getCommand().addInputStreamListener((IGobblerListener)new ChartStreamDaemon2(console, this.dataSet, this.parser));
                try {
                    IWorkbenchPage p = PlatformUI.getWorkbench().showPerspective(GraphingPerspective.ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    IViewPart ivp = p.findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView");
                    String name = console.getName();
                    ((GraphSelectorView)ivp).createScriptSet(name.substring(name.lastIndexOf(47) + 1), this.dataSet);
                }
                catch (WorkbenchException workbenchException) {}
            }
        }
        LogManager.logDebug((String)"End run:", (Object)((Object)this));
    }

    protected String[] buildScript() {
        this.getChartingOptions();
        String[] script = this.buildStandardScript();
        return script;
    }

    protected void getChartingOptions() {
        DataSetWizard wizard = new DataSetWizard(GraphingConstants.DataSetMetaData, this.getFilePath());
        IWorkbench workbench = PlatformUI.getWorkbench();
        wizard.init(workbench, null);
        WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        this.parser = wizard.getParser();
        this.dataSet = wizard.getDataSet();
        if (this.parser == null || this.dataSet == null) {
            this.continueRun = false;
        }
        wizard.dispose();
    }
}

