/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.timeframe;

import org.eclipse.linuxtools.lttng.ui.views.timeframe.TimeFrameView;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerGroup {
    private static final int NS_PER_SECOND = 1000000000;
    private static final byte NS_SCALING_FACTOR = -9;
    private static final String SECONDS_LABEL = "sec";
    private static final String NANOSEC_LABEL = "ns";
    private Group group;
    private Spinner seconds;
    private Spinner nanosec;
    private TmfTimestamp startTime;
    private int startSeconds;
    private int startNanosec;
    private TmfTimestamp endTime;
    private int endSeconds;
    private int endNanosec;
    private TmfTimestamp currentTime;
    private int currentSeconds;
    private int currentNanosec;
    private TimeFrameView fOwner;

    public SpinnerGroup(TimeFrameView owner, Composite parent, String groupName, TmfTimeRange range, TmfTimestamp current) {
        this.fOwner = owner;
        this.group = new Group(parent, 2048);
        this.group.setText(groupName);
        GridData gridData = new GridData(16384, 128, true, false);
        gridData.horizontalAlignment = 4;
        this.group.setLayoutData((Object)gridData);
        this.seconds = new Spinner((Composite)this.group, 2048);
        this.seconds.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SpinnerGroup.this.currentSeconds = SpinnerGroup.this.seconds.getSelection();
                SpinnerGroup.this.refreshCurrentTime();
            }
        });
        this.seconds.setBounds(5, 25, 110, 25);
        Label label = new Label((Composite)this.group, 16384);
        label.setText(SECONDS_LABEL);
        label.setBounds(120, 28, 25, 22);
        this.nanosec = new Spinner((Composite)this.group, 2048);
        this.nanosec.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SpinnerGroup.this.currentNanosec = SpinnerGroup.this.nanosec.getSelection();
                if (SpinnerGroup.this.currentNanosec < 0) {
                    SpinnerGroup spinnerGroup = SpinnerGroup.this;
                    spinnerGroup.currentSeconds = spinnerGroup.currentSeconds - 1;
                    SpinnerGroup.this.currentNanosec = 999999999;
                }
                if (SpinnerGroup.this.currentNanosec >= 1000000000) {
                    SpinnerGroup spinnerGroup = SpinnerGroup.this;
                    spinnerGroup.currentSeconds = spinnerGroup.currentSeconds + 1;
                    SpinnerGroup.this.currentNanosec = 0;
                }
                SpinnerGroup.this.refreshCurrentTime();
            }
        });
        this.nanosec.setBounds(150, 25, 110, 25);
        label = new Label((Composite)this.group, 16384);
        label.setText(NANOSEC_LABEL);
        label.setBounds(265, 28, 25, 22);
        this.setContent(range, current);
    }

    private void refreshCurrentTime() {
        TmfTimestamp ts;
        long newCurrentTime = (long)this.currentSeconds * 1000000000L + (long)this.currentNanosec;
        this.currentTime = ts = new TmfTimestamp(newCurrentTime, -9, 0L);
    }

    public TmfTimestamp getStartTime() {
        return this.startTime;
    }

    public TmfTimestamp getEndTime() {
        return this.endTime;
    }

    public TmfTimestamp getCurrentTime() {
        return this.currentTime;
    }

    public TmfTimestamp getSpan() {
        TmfTimestamp span = new TmfTimestamp(this.startTime.getAdjustment(this.endTime, (byte)-9), -9, 0L);
        return span;
    }

    public TmfTimeRange getTimeRange() {
        TmfTimeRange range = new TmfTimeRange(this.startTime, this.endTime);
        return range;
    }

    public void setStartTime(TmfTimestamp ts) {
        try {
            this.startTime = ts.synchronize(0L, (byte)-9);
            this.startSeconds = (int)(this.startTime.getValue() / 1000000000L);
            this.startNanosec = (int)(this.startTime.getValue() % 1000000000L);
        }
        catch (ArithmeticException arithmeticException) {}
    }

    public void setEndTime(TmfTimestamp ts) {
        try {
            this.endTime = ts.synchronize(0L, (byte)-9);
            this.endSeconds = (int)(this.endTime.getValue() / 1000000000L);
            this.endNanosec = (int)(this.endTime.getValue() % 1000000000L);
        }
        catch (ArithmeticException arithmeticException) {}
    }

    public void setCurrentTime(TmfTimestamp ts) {
        try {
            this.currentTime = ts.synchronize(0L, (byte)-9);
            this.currentSeconds = (int)(this.currentTime.getValue() / 1000000000L);
            this.currentNanosec = (int)(this.currentTime.getValue() % 1000000000L);
        }
        catch (ArithmeticException arithmeticException) {}
    }

    public void setContent(TmfTimeRange range, TmfTimestamp current) {
        if (range != null) {
            TmfTimestamp start = range.getStartTime();
            TmfTimestamp end = range.getEndTime();
            this.setStartTime(start);
            if (end.compareTo(start, false) < 0) {
                end = start;
            }
            this.setEndTime(end);
            if (current.compareTo(start, false) < 0) {
                current = start;
            }
            if (current.compareTo(end, false) > 0) {
                current = end;
            }
        }
        this.setCurrentTime(current);
        this.updateSpinners();
    }

    public void setValue(TmfTimestamp current) {
        if (current.compareTo(this.startTime, false) < 0) {
            current = this.startTime;
        }
        if (current.compareTo(this.endTime, false) > 0) {
            current = this.endTime;
        }
        this.setCurrentTime(current);
        this.updateSpinners();
    }

    public void updateSpinners() {
        if (this.seconds.isDisposed()) {
            return;
        }
        this.seconds.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!SpinnerGroup.this.seconds.isDisposed() && !SpinnerGroup.this.nanosec.isDisposed()) {
                    int startns = -1;
                    if (SpinnerGroup.this.currentSeconds <= SpinnerGroup.this.startSeconds) {
                        SpinnerGroup.this.currentSeconds = SpinnerGroup.this.startSeconds;
                        startns = SpinnerGroup.this.startNanosec;
                        if (SpinnerGroup.this.currentNanosec < startns) {
                            SpinnerGroup.this.currentNanosec = startns;
                        }
                    }
                    int endns = 1000000000;
                    if (SpinnerGroup.this.currentSeconds >= SpinnerGroup.this.endSeconds) {
                        SpinnerGroup.this.currentSeconds = SpinnerGroup.this.endSeconds;
                        endns = SpinnerGroup.this.endNanosec;
                        if (SpinnerGroup.this.currentNanosec > endns) {
                            SpinnerGroup.this.currentNanosec = endns;
                        }
                    }
                    SpinnerGroup.this.seconds.setValues(SpinnerGroup.this.currentSeconds, SpinnerGroup.this.startSeconds, SpinnerGroup.this.endSeconds, 0, 1, 10);
                    SpinnerGroup.this.nanosec.setValues(SpinnerGroup.this.currentNanosec, startns, endns, 0, 100000, 10000000);
                    SpinnerGroup.this.seconds.setEnabled(SpinnerGroup.this.startSeconds != SpinnerGroup.this.endSeconds);
                    SpinnerGroup.this.nanosec.setEnabled(startns != endns);
                }
            }
        });
    }
}

