/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.lttng.ui.views.project.model.ILTTngProjectTreeNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngExperimentFolderNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectTreeNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngTraceFolderNode;

public class LTTngProjectNode
extends LTTngProjectTreeNode
implements IAdaptable {
    public static final String TRACE_FOLDER_NAME = "Traces";
    public static final String EXPER_FOLDER_NAME = "Experiments";
    private final IProject fProject;
    private boolean fIsLTTngProject;
    private boolean fIsOpen;
    private LTTngTraceFolderNode fTracesFolder;
    private LTTngExperimentFolderNode fExperimentsFolder;

    public LTTngProjectNode(IProject project) {
        this(null, project);
    }

    public LTTngProjectNode(ILTTngProjectTreeNode parent, IProject project) {
        super(parent);
        this.fProject = project;
        this.updateState();
    }

    @Override
    public String getName() {
        return this.fProject.getName();
    }

    @Override
    public void refreshChildren() {
        if (!this.fIsOpen || !this.fIsLTTngProject) {
            return;
        }
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = this.fProject.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 2) {
                    String name = resource.getName();
                    if (name.equals(TRACE_FOLDER_NAME) && !this.isIncluded(true, name, this.fChildren)) {
                        this.fTracesFolder = new LTTngTraceFolderNode(this, (IFolder)resource);
                        this.fChildren.add(this.fTracesFolder);
                    } else if (name.equals(EXPER_FOLDER_NAME) && !this.isIncluded(false, name, this.fChildren)) {
                        this.fExperimentsFolder = new LTTngExperimentFolderNode(this, (IFolder)resource);
                        this.fChildren.add(this.fExperimentsFolder);
                    }
                }
                ++n2;
            }
            ArrayList<ILTTngProjectTreeNode> toRemove = new ArrayList<ILTTngProjectTreeNode>();
            for (ILTTngProjectTreeNode node : this.fChildren) {
                if (this.exists(node.getName(), resources)) {
                    node.refreshChildren();
                    continue;
                }
                toRemove.add(node);
            }
            for (ILTTngProjectTreeNode node : toRemove) {
                this.fChildren.remove(node);
            }
        }
        catch (CoreException coreException) {}
    }

    private boolean isIncluded(boolean isTraces, String name, List<ILTTngProjectTreeNode> list) {
        boolean found = false;
        for (ILTTngProjectTreeNode node : list) {
            if (node instanceof LTTngTraceFolderNode && isTraces) {
                found |= node.getName().equals(name);
                continue;
            }
            if (!(node instanceof LTTngExperimentFolderNode) || isTraces) continue;
            found |= node.getName().equals(name);
        }
        return found;
    }

    private boolean exists(String name, IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void openProject() {
        try {
            this.fProject.open(null);
            this.updateState();
            this.refreshChildren();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void closeProject() {
        try {
            this.fProject.close(null);
            this.updateState();
            this.removeChildren();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private boolean isLTTngProject(IProject project) {
        boolean result = false;
        if (project != null && project.isAccessible()) {
            try {
                result = project.hasNature("org.eclipse.linuxtools.lttng.LTTngProjectNature");
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    public void updateState() {
        this.fIsOpen = this.fProject != null ? this.fProject.isAccessible() : false;
        this.fIsLTTngProject = this.isLTTngProject(this.fProject);
    }

    public boolean isLTTngProject() {
        return this.fIsLTTngProject;
    }

    public boolean isOpen() {
        return this.fIsOpen;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public LTTngTraceFolderNode getTracesFolder() {
        return this.fTracesFolder;
    }

    public LTTngExperimentFolderNode getExperimentsFolder() {
        return this.fExperimentsFolder;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            return this.getProject();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

