/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.lttng.ui.views.project.dialogs.Messages;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngExperimentFolderNode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.CreateLinkedResourceGroup;

@Deprecated
public class NewExperimentDialog
extends SelectionStatusDialog {
    private Text folderNameField;
    private final IContainer container;
    private boolean firstLinkCheck = true;
    private CreateLinkedResourceGroup linkedResourceGroup;

    public NewExperimentDialog(Shell parentShell, LTTngExperimentFolderNode experimentFolder) {
        super(parentShell);
        this.container = experimentFolder.getFolder();
        this.setTitle(Messages.NewExperimentDialog_DialogTitle);
        this.setStatusLineAboveButtons(true);
    }

    protected void computeResult() {
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void createLinkResourceGroup(Composite parent) {
        this.linkedResourceGroup = new CreateLinkedResourceGroup(2, new Listener(){

            public void handleEvent(Event e) {
                NewExperimentDialog.this.validateLinkedResource();
                NewExperimentDialog.this.firstLinkCheck = false;
            }
        }, new CreateLinkedResourceGroup.IStringValue(){

            public void setValue(String string) {
                NewExperimentDialog.this.folderNameField.setText(string);
            }

            public String getValue() {
                return NewExperimentDialog.this.folderNameField.getText();
            }

            public IResource getResource() {
                return null;
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createFolderNameGroup(composite);
        this.createLinkResourceGroup(composite);
        return composite;
    }

    private void createFolderNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite folderGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        folderGroup.setLayout((Layout)layout);
        folderGroup.setLayoutData((Object)new GridData(768));
        Label folderLabel = new Label(folderGroup, 0);
        folderLabel.setFont(font);
        folderLabel.setText(Messages.NewExperimentDialog_ExperimentLabel);
        this.folderNameField = new Text(folderGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.folderNameField.setLayoutData((Object)data);
        this.folderNameField.setFont(font);
        this.folderNameField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewExperimentDialog.this.validateLinkedResource();
            }
        });
    }

    private IFolder createFolderHandle(String folderName) {
        IWorkspaceRoot workspaceRoot = this.container.getWorkspace().getRoot();
        IPath folderPath = this.container.getFullPath().append(folderName);
        IFolder folderHandle = workspaceRoot.getFolder(folderPath);
        return folderHandle;
    }

    private IFolder createNewFolder(String folderName, final URI linkTarget) {
        final IFolder folderHandle = this.createFolderHandle(folderName);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(IDEWorkbenchMessages.NewFolderDialog_progress, 2000);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (linkTarget == null) {
                        folderHandle.create(false, true, monitor);
                    } else {
                        folderHandle.createLink(linkTarget, 16, monitor);
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException exception) {
            if (exception.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.NewFolderDialog_errorTitle, null, (IStatus)((CoreException)exception.getTargetException()).getStatus());
            } else {
                IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), (String)"createNewExperiment", (Throwable)exception.getTargetException());
                MessageDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.NewFolderDialog_errorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.NewFolderDialog_internalError, (Object)exception.getTargetException().getMessage()));
            }
            return null;
        }
        return folderHandle;
    }

    protected void updateStatus(IStatus status) {
        if (this.firstLinkCheck && status != null) {
            Status newStatus = new Status(0, status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
            super.updateStatus((IStatus)newStatus);
        } else {
            super.updateStatus(status);
        }
    }

    private void updateStatus(int severity, String message) {
        this.updateStatus((IStatus)new Status(severity, "org.eclipse.ui.ide", severity, message, null));
    }

    private void validateLinkedResource() {
        boolean valid = this.validateFolderName();
        if (valid) {
            IFolder linkHandle = this.createFolderHandle(this.folderNameField.getText());
            IStatus status = this.linkedResourceGroup.validateLinkLocation((IResource)linkHandle);
            if (status.getSeverity() != 4) {
                this.getOkButton().setEnabled(true);
            } else {
                this.getOkButton().setEnabled(false);
            }
            if (!status.isOK()) {
                this.updateStatus(status);
            }
        } else {
            this.getOkButton().setEnabled(false);
        }
    }

    private boolean validateFolderName() {
        String name = this.folderNameField.getText();
        IWorkspace workspace = this.container.getWorkspace();
        IStatus nameStatus = workspace.validateName(name, 2);
        if ("".equals(name)) {
            this.updateStatus(4, "Experiment name is empty");
            return false;
        }
        if (!nameStatus.isOK()) {
            this.updateStatus(nameStatus);
            return false;
        }
        Path path = new Path(name);
        if (this.container.getFolder((IPath)path).exists() || this.container.getFile((IPath)path).exists()) {
            this.updateStatus(4, NLS.bind((String)"Experiment already exists", (Object)name));
            return false;
        }
        this.updateStatus(0, "");
        return true;
    }

    protected void okPressed() {
        URI linkTarget = this.linkedResourceGroup.getLinkTargetURI();
        IFolder folder = this.createNewFolder(this.folderNameField.getText(), linkTarget);
        if (folder == null) {
            return;
        }
        this.setSelectionResult(new IFolder[]{folder});
        super.okPressed();
    }
}

