/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramUtils;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramView;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class HistogramTextControl
implements FocusListener,
KeyListener {
    protected final HistogramView fParentView;
    private final Composite fParent;
    private final Group fGroup;
    protected final Text fTextValue;
    private long fValue;

    public HistogramTextControl(HistogramView parentView, Composite parent, int textStyle, int groupStyle) {
        this(parentView, parent, textStyle, groupStyle, "", HistogramUtils.nanosecondsToString(0L));
    }

    public HistogramTextControl(HistogramView parentView, Composite parent, int textStyle, int groupStyle, String groupValue, String textValue) {
        this.fParentView = parentView;
        this.fParent = parent;
        Font font = parent.getFont();
        FontData fontData = font.getFontData()[0];
        Font adjustedFont = new Font(font.getDevice(), fontData.getName(), fontData.getHeight() + -1, fontData.getStyle());
        int maxChars = ".9223372036854775807".length();
        int textBoxSize = HistogramUtils.getTextSizeInControl(parent, ".9223372036854775807");
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.fGroup = new Group(this.fParent, groupStyle);
        this.fGroup.setText(groupValue);
        this.fGroup.setFont(adjustedFont);
        this.fGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        gridData.horizontalIndent = 0;
        gridData.verticalIndent = 0;
        gridData.minimumWidth = textBoxSize;
        this.fTextValue = new Text((Composite)this.fGroup, textStyle);
        this.fTextValue.setTextLimit(maxChars);
        this.fTextValue.setText(textValue);
        this.fTextValue.setFont(adjustedFont);
        this.fTextValue.setLayoutData((Object)gridData);
        this.fTextValue.addFocusListener((FocusListener)this);
        this.fTextValue.addKeyListener((KeyListener)this);
    }

    public boolean isDisposed() {
        return this.fGroup.isDisposed();
    }

    protected abstract void updateValue();

    public void setLayoutData(GridData layoutData) {
        this.fGroup.setLayoutData((Object)layoutData);
    }

    public void setValue(String timeString) {
        long timeValue = HistogramUtils.stringToNanoseconds(timeString);
        this.setValue(timeValue);
    }

    public void setValue(final long time) {
        Display display = Display.getCurrent();
        if (display != null) {
            this.fValue = time;
            this.fTextValue.setText(HistogramUtils.nanosecondsToString(time));
            return;
        }
        if (!this.isDisposed()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!HistogramTextControl.this.isDisposed()) {
                        HistogramTextControl.this.setValue(time);
                    }
                }
            });
        }
    }

    public long getValue() {
        return this.fValue;
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        this.updateValue();
    }

    public void keyPressed(KeyEvent event) {
        switch (event.keyCode) {
            case 13: {
                this.updateValue();
                break;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

