/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.tracecontrol.model.config;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.linuxtools.lttng.tracecontrol.model.config.TraceChannel;
import org.eclipse.linuxtools.lttng.ui.LTTngUiPlugin;
import org.eclipse.swt.graphics.Image;

public class TraceChannelTableLabelProvider
implements ITableLabelProvider {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof TraceChannel) {
            TraceChannel chan = (TraceChannel)element;
            switch (columnIndex) {
                case 1: {
                    return this.getImage(chan.isEnabled() && chan.isEnabledStatusKnown());
                }
                case 2: {
                    return this.getImage(chan.isChannelOverride() && chan.isChannelOverrideStatusKnown());
                }
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof TraceChannel) {
            TraceChannel chan = (TraceChannel)element;
            switch (columnIndex) {
                case 0: {
                    return chan.getName();
                }
                case 1: {
                    if (chan.isEnabledStatusKnown()) break;
                    return "?";
                }
                case 2: {
                    if (chan.isChannelOverrideStatusKnown()) break;
                    return "?";
                }
                case 3: {
                    if (chan.getSubbufNum() == -1L) {
                        return "?";
                    }
                    return String.valueOf(chan.getSubbufNum());
                }
                case 4: {
                    if (chan.getSubbufSize() == -1L) {
                        return "?";
                    }
                    return String.valueOf(chan.getSubbufSize());
                }
                case 5: {
                    if (chan.getTimer() == -1L) {
                        return "?";
                    }
                    return String.valueOf(chan.getTimer());
                }
            }
        }
        return null;
    }

    private Image getImage(boolean isSelected) {
        if (isSelected) {
            return LTTngUiPlugin.getDefault().getImage("ICON_ID_CHECKED");
        }
        return LTTngUiPlugin.getDefault().getImage("ICON_ID_UNCHECKED");
    }
}

