/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Ovidio Mallo - bug 242166
 *******************************************************************************/
package org.eclipse.jface.databinding.conformance.util;

import java.util.List;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;

/**
 * Listener for tracking the firing of StaleEvents.
 * @since 1.1
 */
public class StaleEventTracker implements IStaleListener {
	public int count;

	public StaleEvent event;

	/**
	 * Queue that the listener will add itself too when it is notified of an
	 * event. Used to determine order of notifications of listeners. Can be
	 * null.
	 */
	public final List queue;

	public StaleEventTracker() {
		this(null);
	}

	public StaleEventTracker(List notificationQueue) {
		this.queue = notificationQueue;
	}

	public void handleStale(StaleEvent event) {
		count++;
		this.event = event;
		if (queue != null) {
			queue.add(this);
		}
	}

	/**
	 * Convenience method to register a new listener.
	 * 
	 * @param observable
	 * @return tracker
	 */
	public static StaleEventTracker observe(IObservable observable) {
		StaleEventTracker tracker = new StaleEventTracker();
		observable.addStaleListener(tracker);
		return tracker;
	}
}
