/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report;

import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class NormalizedFileNames {
    private static final BitSet LEGAL_CHARS = new BitSet();
    private final Map<String, String> mapping = new HashMap<String, String>();
    private final Set<String> usedNames = new HashSet<String>();

    NormalizedFileNames() {
    }

    public String getFileName(String id) {
        String name = this.mapping.get(id);
        if (name != null) {
            return name;
        }
        name = this.replaceIllegalChars(id);
        name = this.ensureUniqueness(name);
        this.mapping.put(id, name);
        return name;
    }

    private String replaceIllegalChars(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            sb.append(LEGAL_CHARS.get(c) ? c : (char)'_');
        }
        return sb.toString();
    }

    private String ensureUniqueness(String s) {
        String unique = s;
        String lower = unique.toLowerCase();
        int idx = 1;
        while (this.usedNames.contains(lower)) {
            unique = s + '~' + idx++;
            lower = unique.toLowerCase();
        }
        this.usedNames.add(lower);
        return unique;
    }

    static {
        String legal = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWYXZ0123456789$-._";
        for (char c : "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWYXZ0123456789$-._".toCharArray()) {
            LEGAL_CHARS.set(c);
        }
    }
}

