/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.prov.engine;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.prov.engine.EngineActivator;
import org.eclipse.equinox.prov.core.helpers.ServiceHelper;
import org.eclipse.equinox.prov.installregistry.IInstallRegistry;
import org.eclipse.equinox.prov.installregistry.IProfileInstallRegistry;
import org.eclipse.equinox.prov.metadata.IInstallableUnit;
import org.eclipse.equinox.prov.metadata.RequiredCapability;
import org.eclipse.equinox.prov.query.IQueryable;
import org.eclipse.equinox.prov.query.QueryableArray;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.BundleContext;

public class Profile
implements IQueryable {
    public static String PROP_FLAVOR = "eclipse.prov.flavor";
    public static final String PROP_INSTALL_FOLDER = "eclipse.prov.installFolder";
    public static final String PROP_NL = "eclipse.prov.nl";
    public static final String PROP_DESCRIPTION = "eclipse.prov.description";
    public static final String PROP_NAME = "eclipse.prov.name";
    public static final String PROP_ENVIRONMENTS = "eclipse.prov.environments";
    public static final String PROP_ROAMING = "eclipse.prov.roaming";
    public static final String PROP_CACHE = "eclipse.prov.cache";
    private String profileId;
    private Profile parentProfile;
    private Properties storage = new Properties();
    static /* synthetic */ Class class$0;

    public Profile(String profileId) {
        if (profileId == null || profileId.length() == 0) {
            throw new IllegalArgumentException("Profile id must be set.");
        }
        this.profileId = profileId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public Profile getParentProfile() {
        return this.parentProfile;
    }

    public String getValue(String key) {
        return this.storage.getProperty(key);
    }

    public void setValue(String key, String value) {
        this.storage.setProperty(key, value);
    }

    public Dictionary getSelectionContext() {
        Properties result = new Properties(this.storage);
        String environments = this.storage.getProperty(PROP_ENVIRONMENTS);
        if (environments == null) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(environments, ",");
        while (tokenizer.hasMoreElements()) {
            String entry = tokenizer.nextToken();
            int i = entry.indexOf(61);
            String key = entry.substring(0, i).trim();
            String value = entry.substring(i + 1).trim();
            result.put(key, value);
        }
        return result;
    }

    private IInstallableUnit[] getAllInstallableUnits() {
        IInstallRegistry registry;
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.prov.installregistry.IInstallRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((registry = (IInstallRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return null;
        }
        IProfileInstallRegistry profile = registry.getProfileInstallRegistry(new Profile(this.profileId));
        if (profile == null) {
            return null;
        }
        return profile.getInstallableUnits();
    }

    public Iterator getIterator(String id, VersionRange range, RequiredCapability[] requirements, boolean and) {
        return new QueryableArray(this.getAllInstallableUnits()).getIterator(id, range, requirements, and);
    }

    public IInstallableUnit[] query(String id, VersionRange range, RequiredCapability[] requirements, boolean and, IProgressMonitor progress) {
        return new QueryableArray(this.getAllInstallableUnits()).query(id, range, requirements, and, progress);
    }

    public Iterator getInstallableUnits() {
        return Arrays.asList(this.getAllInstallableUnits()).iterator();
    }
}

