/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.teststubs.osgi.service.event.internal;

import java.util.Arrays;
import org.osgi.service.event.Event;

public final class EventUtils {
    public static boolean eventsAreEqual(Event event, Event candidate) {
        Object[] candidatePropertyNames;
        Object[] propertyNames;
        if (candidate.getTopic().equals(event.getTopic()) && Arrays.equals(propertyNames = event.getPropertyNames(), candidatePropertyNames = candidate.getPropertyNames())) {
            Object[] objectArray = propertyNames;
            int n = propertyNames.length;
            int n2 = 0;
            while (n2 < n) {
                Object propertyName = objectArray[n2];
                Object value = event.getProperty((String)propertyName);
                Object candidateValue = candidate.getProperty((String)propertyName);
                if (value.getClass().isArray() ? !EventUtils.arraysAreEqual(value, candidateValue) : !value.equals(candidateValue)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    static boolean arraysAreEqual(Object value, Object candidateValue) {
        boolean arraysAreEqual = false;
        Class<?> componentType = value.getClass().getComponentType();
        arraysAreEqual = !componentType.isPrimitive() ? Arrays.equals((Object[])value, (Object[])candidateValue) : (componentType.equals(Boolean.TYPE) ? Arrays.equals((boolean[])value, (boolean[])candidateValue) : (componentType.equals(Byte.TYPE) ? Arrays.equals((byte[])value, (byte[])candidateValue) : (componentType.equals(Character.TYPE) ? Arrays.equals((char[])value, (char[])candidateValue) : (componentType.equals(Double.TYPE) ? Arrays.equals((double[])value, (double[])candidateValue) : (componentType.equals(Float.TYPE) ? Arrays.equals((float[])value, (float[])candidateValue) : (componentType.equals(Integer.TYPE) ? Arrays.equals((int[])value, (int[])candidateValue) : (componentType.equals(Long.TYPE) ? Arrays.equals((long[])value, (long[])candidateValue) : Arrays.equals((short[])value, (short[])candidateValue))))))));
        return arraysAreEqual;
    }
}

