/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CDTDebugPropertyTester
extends PropertyTester {
    private static final String IS_CDT_DEBUGGING = "isCDTDebugging";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_CDT_DEBUGGING.equals(property)) {
            return this.isCdtLaunchConfigDebugMode();
        }
        return false;
    }

    private boolean isCdtLaunchConfigDebugMode() {
        ISteppingModeTarget gdbTarget = CDTDebugPropertyTester.getSteppingModeTarget();
        return gdbTarget != null && gdbTarget.supportsInstructionStepping();
    }

    public static ISteppingModeTarget getSteppingModeTarget() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        if (workbenchPage == null) {
            return null;
        }
        IViewPart debugView = workbenchPage.findView("org.eclipse.debug.ui.DebugView");
        if (debugView == null) {
            return null;
        }
        IDebugView debugViewClazz = (IDebugView)debugView.getAdapter(IDebugView.class);
        ISelection selection = debugViewClazz.getViewer().getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        return CDTDebugPropertyTester.getTargetFromSelection(element);
    }

    public static ISteppingModeTarget getTargetFromSelection(Object element) {
        IDebugTarget debugTarget;
        ISteppingModeTarget target = null;
        if (element instanceof IDebugElement && (debugTarget = ((IDebugElement)element).getDebugTarget()) instanceof ISteppingModeTarget) {
            target = (ISteppingModeTarget)debugTarget;
        }
        if (target == null && element instanceof IAdaptable) {
            target = (ISteppingModeTarget)((IAdaptable)element).getAdapter(ISteppingModeTarget.class);
        }
        return target;
    }
}

