/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.autotools.ui.properties.IProjectPropertyListener;
import org.eclipse.cdt.internal.autotools.ui.properties.IPropertyChangeManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ListenerList;

public class AutotoolsPropertyManager
implements IPropertyChangeManager {
    private static volatile AutotoolsPropertyManager fInstance;
    private Map<IProject, ListenerList<IProjectPropertyListener>> projectList = new HashMap<IProject, ListenerList<IProjectPropertyListener>>();

    private AutotoolsPropertyManager() {
    }

    public static AutotoolsPropertyManager getDefault() {
        if (fInstance == null) {
            fInstance = new AutotoolsPropertyManager();
        }
        return fInstance;
    }

    @Override
    public synchronized void addProjectPropertyListener(IProject project, IProjectPropertyListener listener) {
        ListenerList list = this.projectList.get(project);
        if (list == null) {
            list = new ListenerList();
            this.projectList.put(project, (ListenerList<IProjectPropertyListener>)list);
        }
        list.add((Object)listener);
    }

    @Override
    public synchronized void notifyPropertyListeners(IProject project, String property) {
        ListenerList<IProjectPropertyListener> list = this.projectList.get(project);
        if (list != null) {
            Object[] listeners = list.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IProjectPropertyListener)listeners[i]).handleProjectPropertyChanged(project, property);
                ++i;
            }
        }
    }

    @Override
    public synchronized void removeProjectPropertyListener(IProject project, IProjectPropertyListener listener) {
        ListenerList<IProjectPropertyListener> list = this.projectList.get(project);
        if (list != null) {
            list.remove((Object)listener);
        }
    }
}

