/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

import java.io.IOException;
import org.eclipse.cdt.utils.coff.Coff64;
import org.eclipse.cdt.utils.coff.PE64;

public final class PEHelper64 {
    private final PE64 pe64;

    public PEHelper64(PE64 pe64) {
        this.pe64 = pe64;
    }

    public Sizes getSizes() throws IOException {
        long bss = 0L;
        long data = 0L;
        long text = 0L;
        boolean isExecutable = (this.pe64.getFileHeader().f_flags & 2) != 0;
        Coff64.SectionHeader[] sectionHeaderArray = this.pe64.getSectionHeaders();
        int n = sectionHeaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coff64.SectionHeader section = sectionHeaderArray[n2];
            if ((section.s_flags & 0x2000000) == 0) {
                long size = isExecutable ? section.s_paddr : section.s_size;
                if ((section.s_flags & 0x80) != 0) {
                    bss += size;
                } else if ((section.s_flags & 0x40) != 0) {
                    if ((section.s_flags & Integer.MIN_VALUE) != 0) {
                        data += size;
                    } else {
                        text += size;
                    }
                } else if ((section.s_flags & 0x20) != 0) {
                    text += size;
                }
            }
            ++n2;
        }
        return new Sizes(text, data, bss);
    }

    public record Sizes(long text, long data, long bss) {
        public long total() {
            return this.text + this.data + this.bss;
        }
    }
}

