/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.model;

import org.eclipse.cdt.codan.core.model.ICodanProblemMarker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemReporter;
import org.eclipse.cdt.codan.internal.core.CheckersRegistry;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemMarker;
import org.eclipse.core.resources.IResource;

public abstract class AbstractProblemReporter
implements IProblemReporter {
    @Override
    public void reportProblem(String id, IProblemLocation loc, Object ... args) {
        IResource file = loc.getFile();
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        IProblem problem = CheckersRegistry.getInstance().getResourceProfile(file).findProblem(id);
        if (problem == null) {
            throw new IllegalArgumentException("Id is not registered:" + id);
        }
        if (!problem.isEnabled()) {
            return;
        }
        CodanProblemMarker codanProblemMarker = new CodanProblemMarker(problem, loc, args);
        this.reportProblem(codanProblemMarker);
    }

    protected abstract void reportProblem(ICodanProblemMarker var1);
}

