/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report.srcviewer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.eclipse.actf.util.JapaneseEncodingDetector;
import org.eclipse.actf.visualization.internal.ui.report.Messages;
import org.eclipse.actf.visualization.internal.ui.report.srcviewer.DialogTextSearch;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SrcViewer {
    private Composite parentCom;
    private Display display;
    private StyledText styledText;
    private StyledText lineText;
    private Text lineNo;
    private Text columnNo;
    int start;
    int end;
    Color hlFg;
    Color hlBg;
    Vector<Integer> startV;
    Vector<Integer> lenV;
    Vector<Color> fgV;
    Vector<Color> bgV;
    private static Shell searchDlgShell;
    private String highLightedText = "";
    private boolean highlighted = false;
    private Button copyButton;

    public SrcViewer(Composite composite) {
        this.parentCom = composite;
        this.display = composite.getDisplay();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(32);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        composite3.setLayoutData((Object)gridData);
        Label label = new Label(composite3, 0);
        label.setText(Messages.SrcViewer_3);
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        label.setLayoutData((Object)gridData);
        this.lineNo = new Text(composite3, 133120);
        gridData = new GridData();
        gridData.widthHint = 70;
        this.lineNo.setLayoutData((Object)gridData);
        this.lineNo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.stateMask == 262144 && (keyEvent.keyCode == 102 || keyEvent.keyCode == 70)) {
                    SrcViewer.this.openSearchDialog();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.stateMask != 0) {
                    return;
                }
                try {
                    SrcViewer.this.clearHighlight(false);
                    int n = Integer.parseInt(SrcViewer.this.lineNo.getText());
                    int n2 = SrcViewer.this.styledText.getLineCount();
                    if (n < 1) {
                        n = 1;
                        SrcViewer.this.lineNo.setText(String.valueOf(n));
                    } else if (n > n2) {
                        n = n2;
                        SrcViewer.this.lineNo.setText(String.valueOf(n));
                    }
                    SrcViewer.this.columnNo.setText("0");
                    SrcViewer.this.highlight(n, 0, n + 1, 0, false);
                }
                catch (NumberFormatException numberFormatException) {
                    SrcViewer.this.lineNo.setText("");
                }
            }
        });
        label = new Label(composite3, 0);
        label.setText(Messages.SrcViewer_6);
        gridData = new GridData();
        gridData.horizontalIndent = 10;
        label.setLayoutData((Object)gridData);
        this.columnNo = new Text(composite3, 133120);
        gridData = new GridData();
        gridData.widthHint = 70;
        this.columnNo.setLayoutData((Object)gridData);
        this.columnNo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.stateMask == 262144 && (keyEvent.keyCode == 102 || keyEvent.keyCode == 70)) {
                    SrcViewer.this.openSearchDialog();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.stateMask != 0) {
                    return;
                }
                try {
                    SrcViewer.this.clearHighlight(false);
                    int n = Integer.parseInt(SrcViewer.this.lineNo.getText());
                    int n2 = n < SrcViewer.this.styledText.getLineCount() ? SrcViewer.this.styledText.getOffsetAtLine(n) - SrcViewer.this.styledText.getOffsetAtLine(n - 1) - 1 : SrcViewer.this.styledText.getCharCount() - SrcViewer.this.styledText.getOffsetAtLine(n - 1);
                    int n3 = Integer.parseInt(SrcViewer.this.columnNo.getText());
                    if (n3 < 0) {
                        n3 = 0;
                        SrcViewer.this.columnNo.setText(String.valueOf(n3));
                    } else if (n3 >= n2) {
                        n3 = n2;
                        SrcViewer.this.columnNo.setText(String.valueOf(n3));
                    }
                    SrcViewer.this.highlight(n, n3, n + 1, 0, false);
                }
                catch (NumberFormatException numberFormatException) {
                    SrcViewer.this.columnNo.setText("");
                }
            }
        });
        Button button = new Button(composite3, 8);
        button.setText(Messages.SrcViewer_8);
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SrcViewer.this.openSearchDialog();
            }
        });
        this.copyButton = new Button(composite3, 8);
        this.copyButton.setText(Messages.SrcViewer_9);
        gridData = new GridData();
        gridData.horizontalIndent = 10;
        this.copyButton.setLayoutData((Object)gridData);
        this.copyButton.setEnabled(false);
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SrcViewer.this.copyToClipBoard();
            }
        });
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        composite4.setLayoutData((Object)gridData);
        this.lineText = new StyledText(composite4, 0);
        gridData = new GridData(16);
        gridData.widthHint = 32;
        gridData.grabExcessVerticalSpace = true;
        this.lineText.setLayoutData((Object)gridData);
        this.lineText.setEditable(false);
        this.styledText = new StyledText(composite4, 2816);
        gridData = new GridData(1808);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.styledText.setLayoutData((Object)gridData);
        this.styledText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SrcViewer.this.getSelectionLineCol();
                SrcViewer.this.setCopyButton();
            }
        });
        this.styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                SrcViewer.this.getSelectionLineCol();
            }
        });
        this.styledText.setKeyBinding(0x43 | SWT.MOD1, 0);
        this.styledText.setKeyBinding(0x58 | SWT.MOD1, 0);
        this.styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000006 || keyEvent.keyCode == 0x1000005 || keyEvent.keyCode == 0x1000007 || keyEvent.keyCode == 0x1000008 || keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001 || keyEvent.keyCode == 0x1000003 || keyEvent.keyCode == 0x1000004) {
                    SrcViewer.this.getSelectionLineCol();
                    SrcViewer.this.setLineText();
                } else if (keyEvent.stateMask == 262144) {
                    if (keyEvent.keyCode == 102 || keyEvent.keyCode == 70) {
                        SrcViewer.this.openSearchDialog();
                    } else if (keyEvent.keyCode == 99 || keyEvent.keyCode == 67) {
                        SrcViewer.this.copyToClipBoard();
                    }
                }
            }
        });
        this.styledText.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SrcViewer.this.setLineText();
            }
        });
        this.parentCom.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.stateMask == 262144) {
                    if (keyEvent.keyCode == 102 || keyEvent.keyCode == 70) {
                        SrcViewer.this.openSearchDialog();
                    } else if (keyEvent.keyCode == 99 || keyEvent.keyCode == 67) {
                        SrcViewer.this.copyToClipBoard();
                    }
                }
            }
        });
        this.hlFg = this.styledText.getSelectionForeground();
        this.hlBg = this.styledText.getSelectionBackground();
        this.startV = new Vector();
        this.lenV = new Vector();
        this.fgV = new Vector();
        this.bgV = new Vector();
    }

    private void setCopyButton() {
        String string = this.styledText.getSelectionText();
        if (string.equals("") && this.highLightedText.equals("") || !string.equals("") && this.highlighted) {
            this.copyButton.setEnabled(false);
        } else {
            this.copyButton.setEnabled(true);
        }
    }

    private void copyToClipBoard() {
        if (!this.copyButton.getEnabled()) {
            return;
        }
        String string = !this.highLightedText.equals("") ? this.highLightedText : this.styledText.getSelectionText();
        Clipboard clipboard = new Clipboard(this.display);
        clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void openSearchDialog() {
        if (searchDlgShell == null || searchDlgShell.isDisposed()) {
            searchDlgShell = new Shell(this.parentCom.getShell(), 34912);
            searchDlgShell.setSize(600, 170);
            searchDlgShell.setLayout((Layout)new FillLayout());
            new DialogTextSearch(searchDlgShell, this);
            searchDlgShell.open();
        } else {
            searchDlgShell.forceActive();
        }
    }

    private void setLineText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.lineText.getBounds().height / this.styledText.getLineHeight();
        int n2 = this.styledText.getTopIndex();
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(String.valueOf(String.valueOf(n2 + n3 + 1)) + "\r\n");
            ++n3;
        }
        this.lineText.setText(stringBuffer.toString());
        this.styledText.setTopIndex(n2);
    }

    public void setHighlightColor(Color color, Color color2) {
        this.hlFg = color;
        this.hlBg = color2;
    }

    public void getSelectionLineCol() {
        int n = this.styledText.getSelectionRange().x;
        int n2 = this.styledText.getLineAtOffset(n) + 1;
        this.lineNo.setText(new Integer(n2).toString());
        this.columnNo.setText(new Integer(n - this.styledText.getOffsetAtLine(n2 - 1)).toString());
    }

    public void openFile(File file) {
        this.styledText.setText("");
        try {
            String string = "MS932";
            JapaneseEncodingDetector japaneseEncodingDetector = null;
            InputStreamReader inputStreamReader = null;
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                japaneseEncodingDetector = new JapaneseEncodingDetector((InputStream)fileInputStream);
                string = japaneseEncodingDetector.detect();
                inputStreamReader = new InputStreamReader(japaneseEncodingDetector.getInputStream(), string);
            }
            catch (Exception exception) {}
            BufferedReader bufferedReader = null;
            bufferedReader = inputStreamReader != null ? new BufferedReader(inputStreamReader) : new BufferedReader(new FileReader(file));
            String string2 = new String();
            try {
                while ((string2 = bufferedReader.readLine()) != null) {
                    this.styledText.append(String.valueOf(string2) + "\n");
                }
            }
            catch (Exception exception) {
                try {
                    inputStreamReader = new InputStreamReader(japaneseEncodingDetector.getInputStream(), "MS932");
                    this.styledText.setText("");
                    bufferedReader = new BufferedReader(inputStreamReader);
                    while ((string2 = bufferedReader.readLine()) != null) {
                        this.styledText.append(String.valueOf(string2) + "\n");
                    }
                }
                catch (Exception exception2) {
                    this.styledText.setText(String.valueOf(Messages.SrcViewer_0) + file.getName());
                }
            }
            ((InputStream)fileInputStream).close();
            bufferedReader.close();
            inputStreamReader.close();
        }
        catch (Exception exception) {}
        this.setLineText();
        this.initializeColor();
    }

    public void setText(String string) {
        this.styledText.setText(string);
        this.setLineText();
        this.initializeColor();
    }

    private void initializeColor() {
        this.startV.clear();
        this.lenV.clear();
        this.fgV.clear();
        this.bgV.clear();
        this.lineNo.setText("");
        this.columnNo.setText("");
    }

    public void selectByOffset(int n, int n2) {
        this.clearHighlight();
        this.styledText.setSelection(n, n + n2);
        this.getSelectionLineCol();
        this.setLineText();
    }

    private void setStyleByOffset(int n, int n2, Color color, Color color2) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = n;
        styleRange.length = n2;
        styleRange.foreground = color;
        styleRange.background = color2;
        this.styledText.setStyleRange(styleRange);
    }

    public void clearColor() {
        this.styledText.setStyleRange(null);
        this.initializeColor();
    }

    public void setColor(int n, int n2, int n3, int n4, Color color, Color color2) {
        this.calculateStartEnd(n, n2, n3, n4);
        this.setStyleByOffset(this.start, this.end - this.start, color, color2);
        this.startV.add(new Integer(this.start));
        this.lenV.add(new Integer(this.end - this.start));
        this.fgV.add(color);
        this.bgV.add(color2);
    }

    public void clearHighlight() {
        this.clearHighlight(true);
        this.highlighted = false;
        this.highLightedText = "";
        this.setCopyButton();
    }

    private void clearHighlight(boolean bl) {
        this.styledText.setStyleRange(null);
        int n = 0;
        while (n < this.startV.size()) {
            StyleRange styleRange = new StyleRange();
            styleRange.start = this.startV.get(n);
            styleRange.length = this.lenV.get(n);
            styleRange.foreground = this.fgV.get(n);
            styleRange.background = this.bgV.get(n);
            this.styledText.setStyleRange(styleRange);
            ++n;
        }
        if (bl) {
            this.lineNo.setText("");
            this.columnNo.setText("");
        }
    }

    public void highlight(int n, int n2, int n3, int n4) {
        this.highlight(n, n2, n3, n4, true);
    }

    private void highlight(int n, int n2, int n3, int n4, boolean bl) {
        this.calculateStartEnd(n, n2, n3, n4);
        this.styledText.setSelection(this.styledText.getText().length());
        this.styledText.setSelection(this.start);
        this.setLineText();
        this.setStyleByOffset(this.start, this.end - this.start, this.hlFg, this.hlBg);
        if (this.end > this.start) {
            if (this.highlighted) {
                this.highLightedText = "";
            } else {
                this.highLightedText = this.styledText.getText(this.start, this.end);
                this.highlighted = true;
            }
            this.setCopyButton();
        }
        if (bl) {
            this.lineNo.setText(new Integer(n).toString());
            this.columnNo.setText(new Integer(n2).toString());
        }
    }

    public void highlightLine(int n) {
        this.highlightLines(n, n);
    }

    public void highlightLines(int n, int n2) {
        this.highlight(n, 0, n2 + 1, 0);
    }

    private void calculateStartEnd(int n, int n2, int n3, int n4) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        try {
            this.start = this.styledText.getOffsetAtLine(n - 1) + n2;
        }
        catch (Exception exception) {
            this.start = this.styledText.getCharCount();
        }
        try {
            this.end = this.styledText.getOffsetAtLine(n3 - 1) + n4;
        }
        catch (Exception exception) {
            this.end = this.styledText.getCharCount();
        }
        if (this.start > this.end) {
            this.start = this.end;
        }
    }

    public StyledText getStyledText() {
        return this.styledText;
    }

    public void closeSearchDlgShell() {
        if (searchDlgShell != null && !searchDlgShell.isDisposed()) {
            searchDlgShell.dispose();
        }
    }
}

