/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.flash.as;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.actf.model.flash.as.ASObject;

public class ASDeserializer {
    private static final Map<String, Object> tokenDic = new HashMap<String, Object>();
    private static final Object UNDEFINED = "undefined".intern();
    private static final Object NULL = "null".intern();
    private int idx = 0;
    private String str;

    static {
        tokenDic.put("true", true);
        tokenDic.put("false", false);
        tokenDic.put("undefined", UNDEFINED);
        tokenDic.put("null", NULL);
    }

    /*
     * Unable to fully structure code
     */
    private int skipSP() {
        if (this.str != null) ** GOTO lbl10
        return -1;
lbl-1000:
        // 1 sources

        {
            var1_1 = this.str.charAt(this.idx);
            switch (var1_1) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.idx;
                    break;
                }
                default: {
                    return this.idx;
                }
            }
lbl10:
            // 2 sources

            ** while (this.idx < this.str.length())
        }
lbl11:
        // 1 sources

        return -1;
    }

    private int getTokenEndIdx() {
        int n = this.idx;
        while (n < this.str.length()) {
            char c = this.str.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ']': 
                case '}': {
                    return n;
                }
            }
            ++n;
        }
        return n;
    }

    private String deserializeString() {
        StringBuffer stringBuffer = new StringBuffer();
        ++this.idx;
        while (this.idx < this.str.length()) {
            char c = this.str.charAt(this.idx);
            switch (c) {
                case '\"': {
                    ++this.idx;
                    return stringBuffer.toString();
                }
                case '\\': {
                    ++this.idx;
                    if (this.idx == this.str.length()) {
                        throw new IllegalArgumentException("Abnormal end of the string:" + this.str);
                    }
                    stringBuffer.append(this.str.charAt(this.idx));
                    ++this.idx;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    ++this.idx;
                }
            }
        }
        throw new IllegalArgumentException("Invalid String:" + this.str);
    }

    private Object[] deserializeArray() {
        ++this.idx;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (this.idx < this.str.length()) {
            this.skipSP();
            char c = this.str.charAt(this.idx);
            if (c == ']') {
                ++this.idx;
                return arrayList.toArray(new Object[arrayList.size()]);
            }
            arrayList.add(this.deserialize());
            this.skipSP();
            c = this.str.charAt(this.idx);
            if (c == ']') {
                ++this.idx;
                return arrayList.toArray(new Object[arrayList.size()]);
            }
            if (c != ',') {
                throw new IllegalArgumentException("Missing ',':" + this.str);
            }
            ++this.idx;
        }
        throw new IllegalArgumentException("Abnormal end of the array:" + this.str);
    }

    private ASObject deserializeASObject() {
        ++this.idx;
        ASObject aSObject = new ASObject();
        while (this.idx < this.str.length()) {
            this.skipSP();
            char c = this.str.charAt(this.idx);
            if (c == '}') {
                ++this.idx;
                return aSObject;
            }
            String string = this.deserializeString();
            this.skipSP();
            if (this.str.charAt(this.idx) != ':') {
                throw new IllegalArgumentException("Missing ':':" + this.str);
            }
            ++this.idx;
            Object object = this.deserialize();
            aSObject.put(string, object);
            this.skipSP();
            c = this.str.charAt(this.idx);
            if (c == '}') {
                ++this.idx;
                return aSObject;
            }
            if (this.str.charAt(this.idx) != ',') {
                throw new IllegalArgumentException("Missing ',':" + this.str);
            }
            ++this.idx;
        }
        throw new IllegalArgumentException("Abnormal end of the array:" + this.str);
    }

    public Object deserialize() {
        int n = this.skipSP();
        if (n < 0) {
            return null;
        }
        char c = this.str.charAt(this.idx);
        switch (c) {
            case '[': {
                return this.deserializeArray();
            }
            case '{': {
                return this.deserializeASObject();
            }
            case '\"': {
                return this.deserializeString();
            }
        }
        int n2 = this.getTokenEndIdx();
        String string = this.str.substring(this.idx, n2);
        Object object = tokenDic.get(string);
        this.idx = n2;
        if (object == NULL) {
            return null;
        }
        if (object != null) {
            return object;
        }
        try {
            int n3 = Integer.parseInt(string);
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d = Double.parseDouble(string);
                return new Double(d);
            }
            catch (NumberFormatException numberFormatException2) {
                throw new IllegalArgumentException(String.valueOf(string) + " is not a valid token.");
            }
        }
    }

    public ASDeserializer(String string) {
        this.str = string;
    }
}

