/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ooo;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.model.dom.odf.ODFParser;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.util.converter.ODFConverter;
import org.eclipse.actf.model.dom.odf.util.converter.ODFConverterCreator;
import org.eclipse.actf.model.internal.ui.editors.ooo.OOoEditorScrollManager;
import org.eclipse.actf.model.internal.ui.editors.ooo.OOoEditorToolbar;
import org.eclipse.actf.model.internal.ui.editors.ooo.OOoWindowComposite;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.ODFException;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.OOoNavigation;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.IModelServiceScrollManager;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.actf.model.ui.editors.ooo.initializer.util.OOoEditorInitUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOoComposite
extends Composite
implements IModelService {
    private OOoWindowComposite _oOoWindowComposite = null;
    private Composite _comp;
    private OOoEditorScrollManager scrollManager;
    OOoEditorToolbar _toolbar;
    private String lastURL = null;
    private String title = "";
    private IModelServiceHolder holder;

    public OOoComposite(Composite composite, int n, IModelServiceHolder iModelServiceHolder) {
        super(composite, n);
        if (OOoEditorInitUtil.isOOoInstalled((boolean)true)) {
            this.init();
        }
        this.holder = iModelServiceHolder;
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this._toolbar = new OOoEditorToolbar(this, this, 0, true);
        this._comp = new Composite((Composite)this, 0x1000000);
        this._comp.setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            this._comp.setLayout((Layout)gridLayout);
            this._oOoWindowComposite = new OOoWindowComposite(this._comp, 0x1000000);
            this._oOoWindowComposite.setLayoutData(new GridData(4, 4, true, true));
            this.scrollManager = new OOoEditorScrollManager(this._oOoWindowComposite);
        }
        catch (ODFException oDFException) {
            oDFException.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
    }

    public String[] getSupportMIMETypes() {
        return MIMETYPES_ODF;
    }

    public String[] getSupportExtensions() {
        return EXTS_ODF;
    }

    public void open(String string) {
        File file;
        if (string != null && this._oOoWindowComposite != null && (file = new File(string)).exists()) {
            this._oOoWindowComposite.open(string);
            this._toolbar.getAddressText().setText(string);
            this.titleChange(file.getName());
        }
    }

    public void open(File file) {
    }

    public String getURL() {
        if (this._oOoWindowComposite != null) {
            return this._oOoWindowComposite.getUrl();
        }
        return "";
    }

    public List<Element> getElemList(Node node) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2 instanceof Element) {
                arrayList.add((Element)node2);
            }
            if (node2.hasChildNodes()) {
                arrayList.addAll(this.getElemList(node2));
            }
            ++n;
        }
        return arrayList;
    }

    public Document getDocument() {
        String string = this.getURL();
        if (string == null) {
            return null;
        }
        OOoNavigation oOoNavigation = this._oOoWindowComposite.getOooNavigation();
        ODFDocument oDFDocument = oOoNavigation.getContentXML();
        if (oDFDocument != null && string.equals(this.lastURL)) {
            return oDFDocument;
        }
        ODFParser oDFParser = new ODFParser();
        oDFDocument = oDFParser.getDocument(string);
        int n = 0;
        List<Element> list = this.getElemList(oDFDocument.getDocumentElement());
        int n2 = 0;
        while (n2 < list.size()) {
            Element element = list.get(n2);
            element.setAttribute("actf-odf-content-id", new Integer(n).toString());
            ++n;
            ++n2;
        }
        oOoNavigation.setContentXML(oDFDocument);
        this.lastURL = string;
        return oDFDocument;
    }

    public Document getLiveDocument() {
        return null;
    }

    public Composite getTargetComposite() {
        return this._comp;
    }

    public File saveDocumentAsHTMLFile(String string) {
        if (string == null) {
            return null;
        }
        ODFDocument oDFDocument = (ODFDocument)this.getDocument();
        ODFConverter oDFConverter = ODFConverterCreator.createHTMLConverter();
        oDFConverter.setDocument(oDFDocument);
        oDFConverter.convertDocument(string, false);
        return new File(string);
    }

    public IModelServiceScrollManager getScrollManager() {
        return this.scrollManager;
    }

    public void jumpToNode(Node node) {
        if (node != null) {
            new OOoNavigationThread(node).start();
        }
    }

    public String getCurrentMIMEType() {
        return MIMETYPES_ODF[0];
    }

    private void titleChange(String string) {
        this.title = string;
        this.holder.setEditorTitle(string);
    }

    public Object getAttribute(String string) {
        return null;
    }

    public String getID() {
        return String.valueOf(OOoComposite.class.getName()) + ":" + (Object)((Object)this);
    }

    public String getTitle() {
        return this.title;
    }

    public File saveOriginalDocument(String string) {
        return null;
    }

    public ImagePositionInfo[] getAllImagePosition() {
        return new ImagePositionInfo[0];
    }

    public IModelServiceHolder getModelServiceHolder() {
        return this.holder;
    }

    private class OOoNavigationThread
    extends Thread {
        private Node _targetNode;

        public OOoNavigationThread(Node node) {
            this._targetNode = node;
        }

        public void run() {
            try {
                OOoComposite.this._oOoWindowComposite.getOooNavigation().jumpToProblemPosition(this._targetNode);
            }
            catch (ODFException oDFException) {
                oDFException.printStackTrace();
            }
        }
    }
}

