/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.util.Comparator;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeQueue {
    private Object[] fQueue;
    private int fSize;
    private int fNextIndex = 0;
    private int fMinIndex = 0;

    public FixedSizeQueue(int n) {
        this.fQueue = new Object[n];
        this.fSize = n;
    }

    public int getQueueSize() {
        return this.fSize;
    }

    public synchronized void clear() {
        if (this.fMinIndex != this.fNextIndex) {
            do {
                this.fQueue[this.fMinIndex++] = null;
                if (this.fMinIndex <= this.fSize) continue;
                this.fMinIndex = 0;
            } while (this.fMinIndex != this.fNextIndex);
        }
        this.fNextIndex = 0;
        this.fMinIndex = 0;
        this.fQueue[0] = null;
    }

    public synchronized boolean isEmpty() {
        return this.fNextIndex == this.fMinIndex;
    }

    public synchronized int getSize() {
        int n = this.fNextIndex - this.fMinIndex;
        return n >= 0 ? n : n + this.fSize;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void put(Object var1_1) throws InterruptedException {
        if (var1_1 != null) ** GOTO lbl4
        throw new IllegalArgumentException("null");
lbl-1000:
        // 1 sources

        {
            this.wait();
lbl4:
            // 2 sources

            ** while (this.fQueue[this.fNextIndex] != null)
        }
lbl5:
        // 1 sources

        this.fQueue[this.fNextIndex++] = var1_1;
        if (this.fNextIndex >= this.fSize) {
            this.fNextIndex = 0;
        }
        this.notifyAll();
    }

    public synchronized void put(Object object, long l) throws TimeoutException, InterruptedException {
        if (l == 0L) {
            this.put(object);
        } else {
            if (object == null) {
                throw new IllegalArgumentException("null");
            }
            if (this.fQueue[this.fNextIndex] != null) {
                long l2;
                long l3 = System.currentTimeMillis();
                long l4 = l;
                boolean bl = true;
                do {
                    this.wait(l4);
                    if (this.fQueue[this.fNextIndex] != null) continue;
                    bl = false;
                    break;
                } while ((l4 = l - (l2 = System.currentTimeMillis() - l3)) > 0L);
                if (bl) {
                    throw new TimeoutException("FixedSizeQueue.put");
                }
            }
            this.fQueue[this.fNextIndex++] = object;
            if (this.fNextIndex >= this.fSize) {
                this.fNextIndex = 0;
            }
            this.notifyAll();
        }
    }

    public synchronized Object remove() throws InterruptedException {
        Object object;
        while ((object = this.fQueue[this.fMinIndex]) == null) {
            this.wait();
        }
        this.fQueue[this.fMinIndex++] = null;
        if (this.fMinIndex >= this.fSize) {
            this.fMinIndex = 0;
        }
        this.notifyAll();
        return object;
    }

    public synchronized Object remove(long l) throws TimeoutException, InterruptedException {
        Object object = this.fQueue[this.fMinIndex];
        if (object == null) {
            long l2;
            long l3 = System.currentTimeMillis();
            long l4 = l;
            do {
                this.wait(l4);
            } while ((object = this.fQueue[this.fMinIndex]) == null && (l4 = l - (l2 = System.currentTimeMillis() - l3)) > 0L);
            if (object == null) {
                throw new TimeoutException("FixedSizeQueue.remove");
            }
        }
        this.fQueue[this.fMinIndex++] = null;
        if (this.fMinIndex >= this.fSize) {
            this.fMinIndex = 0;
        }
        this.notifyAll();
        return object;
    }

    public synchronized Object nonBlockingRemove() {
        Object object = this.fQueue[this.fMinIndex];
        if (object != null) {
            this.fQueue[this.fMinIndex++] = null;
            if (this.fMinIndex >= this.fSize) {
                this.fMinIndex = 0;
            }
            this.notifyAll();
        }
        return object;
    }

    public synchronized Object matchAndRemove(Object object, Comparator<Object> comparator) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Object object2 = this.fQueue[this.fMinIndex];
        if (object2 == null) {
            return null;
        }
        if (comparator.compare(object, object2) == 0) {
            this.fQueue[this.fMinIndex++] = null;
            if (this.fMinIndex >= this.fSize) {
                this.fMinIndex = 0;
            }
            this.notifyAll();
            return object2;
        }
        return null;
    }
}

