/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.io;

import java.awt.image.BufferedImage;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ImageUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.BMPReader;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.ImageFileReader;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.IoUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.JPEGReader;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.PBMReader;

public class ImageReader {
    public static BufferedImage readBufferedImage(String string) throws LowVisionIOException {
        short s = IoUtil.getFileType(string);
        if (s != 0) {
            return ImageReader.readBufferedImage(string, s);
        }
        throw new LowVisionIOException("Unknown image format: _fileName");
    }

    public static BufferedImage readBufferedImage(String string, short s) throws LowVisionIOException {
        BufferedImage bufferedImage = null;
        if (s == 1) {
            bufferedImage = BMPReader.readBufferedImage(string);
        } else if (s == 2) {
            bufferedImage = JPEGReader.readBufferedImage(string);
        } else if (s == 5) {
            bufferedImage = ImageFileReader.readBufferedImage(string);
        } else if (s == 6) {
            bufferedImage = ImageFileReader.readBufferedImage(string);
        } else {
            throw new LowVisionIOException("Unknown image format: _fileName");
        }
        if (bufferedImage == null) {
            throw new LowVisionIOException("The image file cannot be read: " + string);
        }
        return bufferedImage;
    }

    public static IInt2D readInt2D(String string) throws LowVisionIOException {
        try {
            return ImageUtil.bufferedImageToInt2D(ImageReader.readBufferedImage(string));
        }
        catch (ImageException imageException) {
            imageException.printStackTrace();
            throw new LowVisionIOException("ImageException occurred while converting BufferedImage into Int2D.");
        }
    }

    public static IInt2D readInt2D(String string, short s) throws LowVisionIOException {
        try {
            return ImageUtil.bufferedImageToInt2D(ImageReader.readBufferedImage(string, s));
        }
        catch (ImageException imageException) {
            imageException.printStackTrace();
            throw new LowVisionIOException("ImageException occurred while converting BufferedImage into Int2D.");
        }
    }

    public static BinaryImage readBinaryImage(String string) throws LowVisionIOException {
        short s = IoUtil.getFileType(string);
        if (s != 0) {
            return ImageReader.readBinaryImage(string, s);
        }
        throw new LowVisionIOException("Unknown image format.");
    }

    public static BinaryImage readBinaryImage(String string, short s) throws LowVisionIOException {
        if (s == 3) {
            return PBMReader.readBinaryImage(string);
        }
        throw new LowVisionIOException("Unknown image format.");
    }
}

