/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.core.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.actf.core.config.AbstractConfiguration;
import org.eclipse.actf.core.config.ConfigurationException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class EclipseConfiguration
extends AbstractConfiguration {
    static final long serialVersionUID = 7981371198710093969L;
    public static final String MODEL_NAME_ATTRIBUTE = "name";
    public static final String ALIAS_ID = "alias";
    private transient HashMap modelMap;
    private transient HashMap filterMap;
    private transient HashMap pluginMap;
    private transient HashMap attributeMap;
    private Stack elementStack = new Stack();
    private String pluginId;

    public String[] getModelTypes() {
        IExtensionPoint[] iExtensionPointArray;
        IExtensionPoint[] iExtensionPointArray2 = iExtensionPointArray = Platform.getExtensionRegistry().getExtensionPoints("org.eclipse.actf.model");
        int n = iExtensionPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionPoint iExtensionPoint = iExtensionPointArray2[n2];
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n3 = iExtensionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IExtension iExtension = iExtensionArray[n4];
                try {
                    this.addConfigurationData(iExtension);
                }
                catch (ConfigurationException configurationException) {
                    Logger.getLogger("org.eclipse.actf.core").log(Level.WARNING, "Could not configure for " + iExtension.getNamespaceIdentifier() + ", " + iExtension.getSimpleIdentifier());
                }
                ++n4;
            }
            ++n2;
        }
        return super.getModelTypes();
    }

    public void addConfigurationData(Object object) throws ConfigurationException {
        if (object instanceof IConfigurationElement) {
            IConfigurationElement iConfigurationElement = (IConfigurationElement)object;
            this.pluginId = iConfigurationElement.getNamespaceIdentifier();
            this.addElement(iConfigurationElement);
        } else if (object instanceof IExtension) {
            IExtension iExtension = (IExtension)object;
            this.pluginId = iExtension.getNamespaceIdentifier();
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                this.addElement(iConfigurationElement);
                ++n2;
            }
        }
    }

    private void addElement(IConfigurationElement iConfigurationElement) throws ConfigurationException {
        String string = iConfigurationElement.getName();
        if (string.equals("model")) {
            String string2;
            if (this._configMap.containsKey(string)) {
                this.setSymbolPool(string);
                this.modelMap = (HashMap)this._configMap.get(string);
            } else {
                this.createSymbolPool(string);
                this.modelMap = new HashMap();
                this._configMap.put(string, this.modelMap);
            }
            this.attributeMap = new HashMap();
            String[] stringArray = iConfigurationElement.getAttributeNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string2 = stringArray[n2];
                String string3 = iConfigurationElement.getAttribute(string2);
                if (string2.equals("class")) {
                    try {
                        Object object = iConfigurationElement.createExecutableExtension("class");
                        if (object != null) {
                            this.attributeMap.put("modelInstance", object);
                        }
                    }
                    catch (Exception exception) {}
                }
                this.attributeMap.put(string2, string3);
                ++n2;
            }
            string2 = (String)this.attributeMap.get(MODEL_NAME_ATTRIBUTE);
            this.modelMap.put(string2, this.attributeMap);
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
            if (iConfigurationElementArray.length > 0) {
                this.elementStack.push(string2);
                n = 0;
                while (n < iConfigurationElementArray.length) {
                    this.addElement(iConfigurationElementArray[n]);
                    ++n;
                }
                this.elementStack.pop();
            }
        } else if (string.equals("filter")) {
            String string4;
            if (this._configMap.containsKey(string)) {
                this.setSymbolPool(string);
                this.filterMap = (HashMap)this._configMap.get(string);
            } else {
                this.createSymbolPool(string);
                this.filterMap = new HashMap();
                this._configMap.put(string, this.filterMap);
            }
            this.attributeMap = new HashMap();
            String[] stringArray = iConfigurationElement.getAttributeNames();
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                string4 = stringArray[n3];
                String string5 = iConfigurationElement.getAttribute(string4);
                this.attributeMap.put(string4, string5);
                ++n3;
            }
            string4 = (String)this.attributeMap.get("model");
            this.filterMap.put(string4, this.attributeMap);
        } else if (string.equals(ALIAS_ID)) {
            String string6 = iConfigurationElement.getAttribute(MODEL_NAME_ATTRIBUTE);
            String string7 = iConfigurationElement.getAttribute("value");
            this.setParameter(string6, string7);
        } else {
            throw new ConfigurationException("addElement - unknown element " + string);
        }
    }

    protected Map addConfigurationData(Object object, Map map) throws ConfigurationException {
        this._configMap = map;
        this.addConfigurationData(object);
        return this._configMap;
    }
}

