/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report.srcviewer;

import org.eclipse.actf.ui.util.IDialogConstants;
import org.eclipse.actf.visualization.internal.ui.report.Messages;
import org.eclipse.actf.visualization.internal.ui.report.srcviewer.SrcViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DialogTextSearch {
    private Shell shell;
    private SrcViewer viewer;
    private StyledText styledText;
    private Button searchButton;

    public DialogTextSearch(Shell shell, SrcViewer srcViewer) {
        this.shell = shell;
        this.shell.setText(Messages.DialogTextSearch_0);
        this.viewer = srcViewer;
        this.styledText = this.viewer.getStyledText();
        this.createSettingControls();
    }

    private void createSettingControls() {
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite3, 0);
        label.setText(Messages.DialogTextSearch_1);
        final Text text = new Text(composite3, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (text.getText().equals("")) {
                    DialogTextSearch.this.searchButton.setEnabled(false);
                } else {
                    DialogTextSearch.this.searchButton.setEnabled(true);
                }
            }
        });
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        final Button button = new Button(composite4, 32);
        button.setText(Messages.DialogTextSearch_3);
        Group group = new Group(composite4, 0);
        group.setText(Messages.DialogTextSearch_4);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        Button button2 = new Button((Composite)group, 16);
        button2.setText(Messages.DialogTextSearch_5);
        final Button button3 = new Button((Composite)group, 16);
        button3.setText(Messages.DialogTextSearch_6);
        button3.setSelection(true);
        Composite composite5 = new Composite(composite, 0);
        composite5.setLayout((Layout)new GridLayout());
        composite5.setLayoutData((Object)new GridData(2));
        this.searchButton = new Button(composite5, 8);
        this.searchButton.setText(Messages.DialogTextSearch_7);
        this.searchButton.setEnabled(false);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.searchButton.setLayoutData((Object)gridData);
        this.shell.setDefaultButton(this.searchButton);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                String string = text.getText();
                String string2 = DialogTextSearch.this.styledText.getText();
                if (button3.getSelection()) {
                    int n2 = ((DialogTextSearch)DialogTextSearch.this).styledText.getSelectionRange().x + ((DialogTextSearch)DialogTextSearch.this).styledText.getSelectionRange().y;
                    if (button.getSelection()) {
                        n = string2.indexOf(string, n2);
                        if (n == -1 && n2 > 0) {
                            if (256 == DialogTextSearch.this.popupMessage(Messages.DialogTextSearch_8, 288)) {
                                return;
                            }
                            n = string2.indexOf(string, 0);
                        }
                    } else {
                        n = string2.toLowerCase().indexOf(string.toLowerCase(), n2);
                        if (n == -1 && n2 > 0) {
                            if (256 == DialogTextSearch.this.popupMessage(Messages.DialogTextSearch_8, 288)) {
                                return;
                            }
                            n = string2.toLowerCase().indexOf(string.toLowerCase(), 0);
                        }
                    }
                } else {
                    int n3 = ((DialogTextSearch)DialogTextSearch.this).styledText.getSelectionRange().x;
                    if (button.getSelection()) {
                        n = string2.lastIndexOf(string, n3 - 1);
                        if (n == -1 && n3 < string2.length()) {
                            if (256 == DialogTextSearch.this.popupMessage(Messages.DialogTextSearch_10, 288)) {
                                return;
                            }
                            n = string2.lastIndexOf(string, string2.length());
                        }
                    } else {
                        n = string2.toLowerCase().lastIndexOf(string.toLowerCase(), n3 - 1);
                        if (n == -1 && n3 < string2.length()) {
                            if (256 == DialogTextSearch.this.popupMessage(Messages.DialogTextSearch_10, 288)) {
                                return;
                            }
                            n = string2.toLowerCase().lastIndexOf(string.toLowerCase(), string2.length());
                        }
                    }
                }
                if (n == -1) {
                    DialogTextSearch.this.popupMessage(Messages.DialogTextSearch_12, 32);
                } else {
                    DialogTextSearch.this.viewer.selectByOffset(n, string.length());
                }
            }
        });
        Button button4 = new Button(composite5, 8);
        button4.setText(IDialogConstants.CANCEL);
        gridData = new GridData();
        gridData.widthHint = 100;
        button4.setLayoutData((Object)gridData);
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DialogTextSearch.this.shell.close();
            }
        });
    }

    private int popupMessage(String string, int n) {
        MessageBox messageBox = new MessageBox(this.shell, n);
        messageBox.setMessage(string);
        return messageBox.open();
    }
}

