/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.actf.visualization.engines.blind.ParamBlind;
import org.eclipse.actf.visualization.engines.blind.TextChecker;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacketCollection;
import org.eclipse.actf.visualization.eval.html.HtmlTagUtil;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.blind.html.BlindProblem;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.TextCounter;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInfoCreator {
    private static final String HEADING_TAGS = "h1|h2|h3|h4|h5|h6";
    private static final String LIST_TAGS = "ul|ol|dl";
    private static final Set<String> BLOCK_TAG_SET = HtmlTagUtil.getBlockElementSet();
    private VisualizeMapDataImpl mapData;
    private TextChecker textChecker;
    private List<IProblemItem> problems;
    private Set<String> invisibleIdSet;
    private TextCounter textCounter;

    public NodeInfoCreator(VisualizeMapDataImpl visualizeMapDataImpl, TextChecker textChecker, List<IProblemItem> list, Set<String> set, ParamBlind paramBlind) {
        this.mapData = visualizeMapDataImpl;
        this.textChecker = textChecker;
        this.problems = list;
        this.invisibleIdSet = set;
        this.textCounter = new TextCounter(paramBlind.iLanguage);
    }

    private String removePeriod(String string, Node node) {
        String string2;
        if (node != null && ((string2 = node.getNodeName()).equals("img") || string2.equals("applet")) && string.endsWith(".]")) {
            string = String.valueOf(string.substring(0, string.lastIndexOf(".]"))) + "]";
        }
        return string;
    }

    private boolean isIdRequiredInput(Element element) {
        String string;
        String string2 = element.getNodeName();
        if (string2.equals("select")) {
            return true;
        }
        if (string2.equals("textarea")) {
            return true;
        }
        return string2.equals("input") && (string = element.getAttribute("type").toLowerCase()).length() == 0 | string.equals("text") | string.equals("textarea") | string.equals("radio") | string.equals("checkbox");
    }

    public void prepareNodeInfo(IPacketCollection iPacketCollection) {
        int n = 0;
        if (iPacketCollection == null) {
            return;
        }
        n = iPacketCollection.size();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        IPacket iPacket = null;
        int n5 = 0;
        while (n5 < n) {
            Object object;
            Object object2;
            String string2;
            IPacket iPacket2 = (IPacket)iPacketCollection.get(n5);
            Node node = iPacket2.getNode();
            if (node.getNodeType() != 1 || !(!(string2 = node.getNodeName()).equals("option") ? string2.equals("area") || string2.equals("map") : (object2 = (object = (Element)node).getAttributeNode("selected")) == null)) {
                string2 = iPacket2.getText();
                if (string2 != null && string2.length() > 0) {
                    if (this.textChecker.isSeparatedJapaneseChars(string2) && !((String)(object = iPacket2.getNode().getNodeName())).matches("img|input|area")) {
                        object2 = new BlindProblem(15, string2);
                        ((BlindProblem)object2).setNode(iPacket2.getNode());
                        object2.setTargetNode(this.mapData.getOrigNode(iPacket2.getNode()));
                        this.problems.add((IProblemItem)object2);
                    }
                    if (iPacket != null && iPacket2.getContext().isInsideAnchor() == iPacket.getContext().isInsideAnchor()) {
                        object = iPacket2.getNode();
                        object2 = iPacket.getNode();
                        if (!object.getNodeName().equals("input") && this.textChecker.isRedundantText(string, string2) && !HtmlTagUtil.hasAncestor((Node)object, (String)"noscript") && !HtmlTagUtil.hasAncestor((Node)object2, (String)"noscript")) {
                            string = this.removePeriod(string, (Node)object2);
                            string2 = this.removePeriod(string2, (Node)object);
                            BlindProblem blindProblem = new BlindProblem(9, "\"" + string + "\" & \"" + string2 + "\"");
                            blindProblem.setNode((Node)object2);
                            blindProblem.addNode((Node)object);
                            if (object2.getNodeName().equals("img")) {
                                blindProblem.setTargetNode(this.mapData.getOrigNode((Node)object2));
                                blindProblem.setTargetStringForExport(string);
                                this.problems.add(blindProblem);
                            } else if (object.getNodeName().equals("img")) {
                                blindProblem.setTargetNode(this.mapData.getOrigNode((Node)object));
                                blindProblem.setTargetStringForExport(string2);
                                this.problems.add(blindProblem);
                            }
                        }
                    }
                    string = string2;
                    iPacket = iPacket2;
                }
                if ((object = this.mapData.getNodeInfo(iPacket2.getNode())) == null) {
                    object2 = new VisualizationNodeInfo();
                    ((VisualizationNodeInfo)object2).setPacket(iPacket2);
                    int n6 = this.textCounter.getWordCount(iPacket2.getText());
                    boolean bl = true;
                    Node node2 = iPacket2.getNode();
                    while (node2 != null) {
                        String string3 = node2.getNodeName();
                        if (node2.getNodeType() == 1) {
                            Element element = (Element)node2;
                            if (element.hasAttribute("accesskey")) {
                                ((VisualizationNodeInfo)object2).setAccesskey(true);
                            }
                            if (this.invisibleIdSet.contains(element.getAttribute("id"))) {
                                ((VisualizationNodeInfo)object2).setInvisible(true);
                                bl = false;
                            }
                        }
                        if (string3.matches(HEADING_TAGS)) {
                            ((VisualizationNodeInfo)object2).setHeading(true);
                            ((VisualizationNodeInfo)object2).appendComment("Heading: " + string3 + ".");
                        } else if (string3.equals("th")) {
                            ((VisualizationNodeInfo)object2).setTableHeader(true);
                            ((VisualizationNodeInfo)object2).appendComment("Table header.");
                        } else if (string3.equals("label")) {
                            ((VisualizationNodeInfo)object2).setLabel(true);
                            ((VisualizationNodeInfo)object2).appendComment("Label for '" + ((Element)node2).getAttribute("for") + "'. ");
                        }
                        if (string3.equals("body")) break;
                        node2 = node2.getParentNode();
                    }
                    if (bl) {
                        ((VisualizationNodeInfo)object2).setWords(n6);
                        ((VisualizationNodeInfo)object2).setTotalWords(n2);
                        ((VisualizationNodeInfo)object2).setOrgTotalWords(n2);
                        n2 += n6;
                        if (n6 > 0) {
                            ++n3;
                        }
                        ((VisualizationNodeInfo)object2).setTotalLines(n4);
                        ((VisualizationNodeInfo)object2).setOrgTotalLines(n4);
                        ((VisualizationNodeInfo)object2).setLines(n3 - n4);
                        n4 = n3;
                    } else {
                        ((VisualizationNodeInfo)object2).setWords(0);
                        ((VisualizationNodeInfo)object2).setTotalWords(n2);
                        ((VisualizationNodeInfo)object2).setOrgTotalWords(n2);
                        ((VisualizationNodeInfo)object2).setTotalLines(n4);
                        ((VisualizationNodeInfo)object2).setOrgTotalLines(n4);
                        ((VisualizationNodeInfo)object2).setLines(0);
                    }
                    ((VisualizationNodeInfo)object2).setPacketId(n5);
                    this.mapData.addNodeInfoMapping(iPacket2.getNode(), (VisualizationNodeInfo)object2);
                }
            }
            ++n5;
        }
    }

    public void createAdditionalNodeInfo(Document document) {
        int n = 0;
        int n2 = 0;
        Map<String, String> map = VisualizeMapUtil.createMapTextMap(document);
        NodeList nodeList = document.getElementsByTagName("body");
        if (nodeList.getLength() > 0) {
            Element element;
            if (nodeList.getLength() > 1) {
                System.out.println("multiple body");
            }
            if ((element = (Element)nodeList.item(0)).hasChildNodes()) {
                Stack<Node> stack = new Stack<Node>();
                stack.push(element);
                Node node = element.getFirstChild();
                VisualizationNodeInfo visualizationNodeInfo = null;
                int n3 = 0;
                int n4 = 0;
                while (node != null && stack.size() > 0) {
                    String string = node.getNodeName();
                    VisualizationNodeInfo visualizationNodeInfo2 = this.mapData.getNodeInfo(node);
                    if (node.getNodeType() == 3) {
                        if (visualizationNodeInfo2 != null) {
                            visualizationNodeInfo2.setId(n3);
                            this.mapData.addNodeInfoIntoList(visualizationNodeInfo2);
                            ++n3;
                            visualizationNodeInfo = visualizationNodeInfo2;
                        }
                    } else if (node.getNodeType() == 1) {
                        String string2;
                        if (visualizationNodeInfo2 != null) {
                            visualizationNodeInfo2.setId(n3);
                            this.mapData.addNodeInfoIntoList(visualizationNodeInfo2);
                            ++n3;
                            visualizationNodeInfo = visualizationNodeInfo2;
                        } else {
                            try {
                                visualizationNodeInfo2 = new VisualizationNodeInfo(visualizationNodeInfo);
                                visualizationNodeInfo2.setWords(0);
                                visualizationNodeInfo2.setLines(0);
                                visualizationNodeInfo2.setId(n3);
                                visualizationNodeInfo2.setNode(node);
                                ++n3;
                                this.mapData.addNodeInfoIntoList(visualizationNodeInfo2);
                                this.mapData.addNodeInfoMapping(node, visualizationNodeInfo2);
                            }
                            catch (NullPointerException nullPointerException) {
                                nullPointerException.printStackTrace();
                            }
                        }
                        if (string.equals("img") && (string2 = ((Element)node).getAttribute("usemap")) != null && string2.length() > 0) {
                            int n5 = visualizationNodeInfo2.getWords();
                            String string3 = map.get(string2.toLowerCase().substring(1));
                            int n6 = this.textCounter.getWordCount(string3);
                            visualizationNodeInfo2.setWords(n5 + n6);
                            visualizationNodeInfo2.setLines(visualizationNodeInfo2.getLines() + 1);
                        }
                    }
                    if (visualizationNodeInfo2 != null) {
                        visualizationNodeInfo2.setTotalWords(n);
                        visualizationNodeInfo2.setOrgTotalWords(n);
                        visualizationNodeInfo2.setTotalLines(n2);
                        visualizationNodeInfo2.setOrgTotalLines(n2);
                        n += visualizationNodeInfo2.getWords();
                        n2 += visualizationNodeInfo2.getLines();
                        if (n4 > 0) {
                            visualizationNodeInfo2.setSequence(true);
                        }
                        if (BLOCK_TAG_SET.contains(string)) {
                            visualizationNodeInfo2.setBlockElement(true);
                        }
                        if (node.getNodeType() == 1 && this.isIdRequiredInput((Element)node)) {
                            visualizationNodeInfo2.setIdRequiredInput(true);
                            visualizationNodeInfo2.appendComment("Input with id, '" + ((Element)node).getAttribute("id") + "'. ");
                        }
                        this.mapData.addNodeIdMapping(visualizationNodeInfo2.getNode(), new Integer(visualizationNodeInfo2.getId()));
                    }
                    boolean bl = string.matches(LIST_TAGS);
                    if (node.hasChildNodes()) {
                        if (bl) {
                            ++n4;
                        }
                        stack.push(node);
                        node = node.getFirstChild();
                        continue;
                    }
                    if (node.getNextSibling() != null) {
                        if (bl) {
                            --n4;
                        }
                        node = node.getNextSibling();
                        continue;
                    }
                    if (bl) {
                        --n4;
                    }
                    node = null;
                    while (node == null && stack.size() > 0) {
                        node = (Node)stack.pop();
                        string = node.getNodeName();
                        if (bl) {
                            --n4;
                        }
                        node = node.getNextSibling();
                    }
                }
            }
        }
    }
}

