/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.internal.util;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.gui.internal.GuiPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public final class GuiImages {
    public static final ImageDescriptor IMAGE_OVERLAY = GuiPlugin.getImageDescriptor("icons/action16/overlay.gif");
    public static final ImageDescriptor IMAGE_REFRESH = GuiPlugin.getImageDescriptor("icons/action16/refresh.gif");
    public static final ImageDescriptor IMAGE_CLEAR = GuiPlugin.getImageDescriptor("icons/action16/clear.gif");
    public static final ImageDescriptor IMAGE_EXPAND_ALL = GuiPlugin.getImageDescriptor("icons/action16/expandall.gif");
    public static final ImageDescriptor IMAGE_COLLAPSE_ALL = GuiPlugin.getImageDescriptor("icons/action16/collapseall.gif");
    public static final ImageDescriptor IMAGE_SPEAK = GuiPlugin.getImageDescriptor("icons/action16/speak.gif");
    public static final ImageDescriptor IMAGE_STOP = GuiPlugin.getImageDescriptor("icons/action16/stop.gif");
    public static final ImageDescriptor IMAGE_CHECKER = GuiPlugin.getImageDescriptor("icons/action16/checker.gif");
    public static final String ACC_ROLE = "icons/acc16/role_{0}.gif";
    public static final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
    public static Map<String, Image> imageMap = new HashMap<String, Image>();

    public static Image getImage(String string) {
        ImageDescriptor imageDescriptor;
        if (string == null) {
            return null;
        }
        Image image = imageMap.get(string);
        if (image == null && (imageDescriptor = GuiImages.getImageDescriptor(string)) != null) {
            image = imageDescriptor.createImage(true);
            imageMap.put(string, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        ImageDescriptor imageDescriptor = GuiPlugin.getImageDescriptor(string);
        if (imageDescriptor == null) {
            imageDescriptor = sharedImages.getImageDescriptor(string);
        }
        return imageDescriptor;
    }

    public static String roleIcon(String string) {
        return GuiImages.getFilename(ACC_ROLE, string);
    }

    public static String roleIcon(int n) {
        return GuiImages.getFilename(ACC_ROLE, "0x" + Integer.toHexString(n));
    }

    public static String getFilename(String string, String string2) {
        String string3 = MessageFormat.format((String)string, (Object[])new Object[]{string2.toLowerCase()});
        if (GuiPlugin.getImageDescriptor(string3) != null) {
            return string3;
        }
        DebugPrintUtil.devOrDebugPrintln((Object)("Missing MSAA icon " + string3));
        return null;
    }
}

