/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.problem;

import java.math.BigDecimal;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.internal.engines.lowvision.Messages;
import org.eclipse.actf.visualization.internal.engines.lowvision.PageElement;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterMS;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSM;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSS;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.EnoughContrastRecommendation;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionRecommendation;

public class ColorProblem
extends LowVisionProblem {
    public static int LEVEL0 = 0;
    public static int LEVEL1 = 1;
    public static int LEVEL2 = 2;
    private int foregroundColor = -1;
    private int backgroundColor = -1;
    private boolean hasBackgroundImage = false;
    private double contrast = 0.0;
    private String[] targetStrings;

    public ColorProblem(PageComponent pageComponent, LowVisionType lowVisionType, double d) throws LowVisionProblemException {
        super(1, lowVisionType, Messages.ColorProblem_Foreground_and_background_colors_are_too_close__1, pageComponent, d);
        this.setComponentColors();
        this.setRecommendations();
    }

    public ColorProblem(PageElement pageElement, LowVisionType lowVisionType, double d) throws LowVisionProblemException {
        super(1, lowVisionType, Messages.ColorProblem_Foreground_and_background_colors_are_too_close__1, pageElement, d);
        this.foregroundColor = pageElement.getForegroundColor();
        this.backgroundColor = pageElement.getBackgroundColor();
        this.setRecommendations();
    }

    protected void setRecommendations() throws LowVisionProblemException {
        this.numRecommendations = 1;
        this.recommendations = new LowVisionRecommendation[this.numRecommendations];
        this.recommendations[0] = new EnoughContrastRecommendation(this, this.foregroundColor, this.backgroundColor);
    }

    private void setComponentColors() throws LowVisionProblemException {
        if (this.componentType == 4) {
            this.foregroundColor = ((CharacterSS)this.pageComponent).getForegroundColor();
            this.backgroundColor = ((CharacterSS)this.pageComponent).getBackgroundColor();
        } else if (this.componentType == 5) {
            this.backgroundColor = ((CharacterMS)this.pageComponent).getBackgroundColor();
            this.foregroundColor = ((CharacterMS)this.pageComponent).getForegroundColor();
        } else if (this.componentType == 6) {
            this.foregroundColor = ((CharacterSM)this.pageComponent).getForegroundColor();
        } else {
            throw new LowVisionProblemException("Invalid component type.");
        }
    }

    public String getDescription() throws LowVisionProblemException {
        return String.valueOf(super.getDescription()) + this.getAdditionalDescription();
    }

    public String getAdditionalDescription() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasBackgroundImage && this.problemType == 1) {
            stringBuffer.append(Messages.BackgroundImage);
        }
        if (this.targetStrings != null && this.targetStrings.length > 0) {
            stringBuffer.append("(" + Messages.TargetString + " = ");
            String[] stringArray = this.targetStrings;
            int n = this.targetStrings.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray[n2];
                stringBuffer.append(String.valueOf(object) + ", ");
                ++n2;
            }
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            stringBuffer.append(") ");
        }
        if (this.contrast >= 1.0 && this.contrast <= 21.0) {
            object = new BigDecimal(this.contrast);
            stringBuffer.append("(" + Messages.ContrastRatio + " = " + ((BigDecimal)object).setScale(2, 4) + ")");
        }
        return stringBuffer.toString();
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean hasBackgroundImage() {
        return this.hasBackgroundImage;
    }

    public void setHasBackgroundImage(boolean bl) {
        this.hasBackgroundImage = bl;
    }

    public void setIsWarning(boolean bl) {
        this.problemType = bl ? 10 : 1;
    }

    public double getContrast() {
        return this.contrast;
    }

    public void setContrast(double d) {
        this.contrast = d;
    }

    public String[] getTargetStrings() {
        return this.targetStrings;
    }

    public void setTargetStrings(String[] stringArray) {
        this.targetStrings = stringArray;
    }

    public int getLevel() {
        if (this.contrast >= 1.0 && this.contrast < 3.0) {
            return LEVEL0;
        }
        if (this.contrast < 4.5) {
            return LEVEL1;
        }
        return LEVEL2;
    }
}

