/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;

public class Coord {
    int x;
    int y;

    public Coord(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void set(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void copy(Coord coord) {
        this.x = coord.x;
        this.y = coord.y;
    }

    public boolean isOrigin() {
        return this.x == 0 && this.y == 0;
    }

    public boolean equals(Coord coord) {
        return this.x == coord.x && this.y == coord.y;
    }

    public static Coord add(Coord coord, Coord coord2) {
        return new Coord(coord.x + coord2.x, coord.y + coord2.y);
    }

    public Coord add(Coord coord) {
        return Coord.add(this, coord);
    }

    public static Coord subtract(Coord coord, Coord coord2) {
        return new Coord(coord.x - coord2.x, coord.y - coord2.y);
    }

    public Coord subtract(Coord coord) {
        return Coord.subtract(this, coord);
    }

    public static int distancePow2(Coord coord, Coord coord2) {
        int n = coord.x - coord2.x;
        int n2 = coord.y - coord2.y;
        return n * n + n2 * n2;
    }

    public static int distancePow2(Coord coord) {
        return coord.x * coord.x + coord.y * coord.y;
    }

    public static double distance(Coord coord, Coord coord2) {
        return Math.sqrt(Coord.distancePow2(coord, coord2));
    }

    public static double distance(Coord coord) {
        return Math.sqrt(Coord.distancePow2(coord));
    }

    public static boolean isOnLine(Coord coord, Coord coord2, Coord coord3) {
        Coord coord4;
        Coord coord5 = Coord.subtract(coord2, coord);
        return Coord.outerProduct(coord5, coord4 = Coord.subtract(coord3, coord)) == 0;
    }

    public static boolean isLeftToVector(Coord coord, Coord coord2, Coord coord3) {
        Coord coord4 = Coord.subtract(coord2, coord);
        Coord coord5 = Coord.subtract(coord3, coord);
        return Coord.outerProduct(coord5, coord4) > 0;
    }

    public static boolean isRightToVector(Coord coord, Coord coord2, Coord coord3) {
        Coord coord4;
        Coord coord5 = Coord.subtract(coord2, coord);
        return Coord.outerProduct(coord5, coord4 = Coord.subtract(coord3, coord)) > 0;
    }

    public static int innerProduct(Coord coord, Coord coord2) {
        return coord.x * coord2.x + coord.y * coord2.y;
    }

    public static double cosine(Coord coord, Coord coord2) throws ImageException {
        if (coord.isOrigin() || coord2.isOrigin()) {
            throw new ImageException("Cannot calculate cosine of zero-vectors");
        }
        return (double)Coord.innerProduct(coord, coord2) / (Coord.distance(coord) * Coord.distance(coord2));
    }

    public static int outerProduct(Coord coord, Coord coord2) {
        return coord.x * coord2.y - coord.y * coord2.x;
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dump(printWriter);
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("-------------------------------");
        printWriter.println("Dumping a point");
        printWriter.println("(" + this.x + "," + this.y + ")");
        printWriter.println("-------------------------------");
    }

    public static void dump(PrintStream printStream, Coord[] coordArray) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        Coord.dump(printWriter, coordArray);
    }

    public static void dump(PrintWriter printWriter, Coord[] coordArray) {
        int n = coordArray.length;
        printWriter.println("-------------------------------");
        printWriter.println("Dumping points");
        printWriter.println("# of points = " + n);
        int n2 = 0;
        while (n2 < n) {
            printWriter.println("(" + coordArray[n2].x + "," + coordArray[n2].y + ")");
            printWriter.println("-----");
            ++n2;
        }
    }
}

