/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash;

import java.util.ArrayList;
import org.eclipse.actf.model.flash.IASBridge;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.model.flash.as.ASDeserializer;
import org.eclipse.actf.model.flash.as.ASObject;
import org.eclipse.actf.model.flash.as.ASSerializer;
import org.eclipse.actf.model.flash.bridge.IWaXcoding;
import org.eclipse.actf.model.flash.bridge.WaXcodingFactory;
import org.eclipse.actf.model.internal.flash.ASNodeImplV8;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.swt.widgets.Display;

public class ASBridgeImplV8
implements IASBridge {
    private IFlashPlayer flashPlayer;
    private IDispatch idispFlash;
    private Object objMarker;
    private String requestArgsPath;
    private String responseValuePath;
    private String contentIdPath;
    private String secret = null;
    private boolean _isRepaired = false;

    public ASBridgeImplV8(IFlashPlayer iFlashPlayer) {
        this.flashPlayer = iFlashPlayer;
        this.idispFlash = iFlashPlayer.getDispatch();
        String string = "";
        if ("true".equals(this.getVariable("_level0.Eclipse_ACTF_is_available"))) {
            string = "_level0";
        } else if ("true".equals(this.getVariable("_level53553.Eclipse_ACTF_is_available"))) {
            string = "_level53553";
        }
        this.requestArgsPath = String.valueOf(string) + ".Eclipse_ACTF_request_args";
        this.responseValuePath = String.valueOf(string) + ".Eclipse_ACTF_response_value";
        this.contentIdPath = String.valueOf(string) + ".Eclipse_ACTF_SWF_CONTENT_ID";
    }

    private String getVariable(String string) {
        try {
            Object object = this.idispFlash.invoke1("GetVariable", (Object)string);
            return (String)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setVariable(String string, String string2) {
        try {
            this.idispFlash.invoke("SetVariable", new Object[]{string, string2});
        }
        catch (Exception exception) {}
    }

    private boolean initSecret() {
        String string;
        block4: {
            if (this.secret != null) {
                return true;
            }
            string = this.getVariable(this.contentIdPath);
            if (string != null && string.length() != 0) break block4;
            return false;
        }
        try {
            IWaXcoding iWaXcoding = WaXcodingFactory.getWaXcoding();
            this.secret = iWaXcoding.getSecret(string, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.secret != null;
    }

    private Object invoke(String string) {
        return this.invoke(new Object[]{string});
    }

    private Object invoke(String string, Object object) {
        return this.invoke(new Object[]{string, object});
    }

    private Object invoke(Object[] objectArray) {
        int n;
        block5: {
            n = 0;
            if (this.initSecret()) break block5;
            return null;
        }
        try {
            this.setVariable(this.responseValuePath, "");
            String string = ASSerializer.serialize(this.secret, objectArray);
            this.setVariable(this.requestArgsPath, string);
            long l = System.currentTimeMillis() + 100L;
            while (l > System.currentTimeMillis()) {
                ++n;
                String string2 = this.getVariable(this.responseValuePath);
                if (string2 != null && string2.length() > 0) {
                    ASDeserializer aSDeserializer = new ASDeserializer(string2);
                    return aSDeserializer.deserialize();
                }
                Display.getCurrent().readAndDispatch();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private IASNode[] createFlashNodeArray(Object object, IASNode iASNode) {
        ArrayList<ASNodeImplV8> arrayList = new ArrayList<ASNodeImplV8>();
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof ASObject) {
                    arrayList.add(new ASNodeImplV8(iASNode, this.flashPlayer, (ASObject)objectArray[n]));
                }
                ++n;
            }
        }
        return arrayList.toArray(new ASNodeImplV8[arrayList.size()]);
    }

    private void initMarker() {
        if (this.objMarker != null) {
            return;
        }
        Object object = this.invoke("newMarker");
        if (object instanceof Integer) {
            this.objMarker = object;
            return;
        }
        this.objMarker = null;
    }

    public Object callMethod(IASNode iASNode, String string) {
        return this.invoke(new Object[]{"callMethodA", iASNode.getTarget(), string});
    }

    public Object callMethod(IASNode iASNode, String string, Object[] objectArray) {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Object[] objectArray2 = new Object[objectArray.length + 3];
        objectArray2[0] = "callMethodA";
        objectArray2[1] = iASNode.getTarget();
        objectArray2[2] = string;
        System.arraycopy(objectArray, 0, objectArray2, 3, objectArray.length);
        return this.invoke(objectArray2);
    }

    public IASNode[] getChildren(IASNode iASNode, boolean bl, boolean bl2) {
        String string = bl ? "getInnerNodes" : (bl2 ? "getSuccessorNodes" : "getChildNodes");
        return this.createFlashNodeArray(this.invoke(string, iASNode.getTarget()), iASNode);
    }

    public IASNode getNodeAtDepthWithPath(String string, int n) {
        Object object = this.invoke(new Object[]{"getNodeAtDepth", string, n});
        if (object instanceof ASObject) {
            return new ASNodeImplV8(null, this.flashPlayer, (ASObject)object);
        }
        return null;
    }

    public IASNode getNodeFromPath(String string) {
        Object object = this.invoke("getNodeFromPath", string);
        if (object instanceof ASObject) {
            return new ASNodeImplV8(null, this.flashPlayer, (ASObject)object);
        }
        return null;
    }

    public Object getProperty(String string, String string2) {
        return this.invoke(new Object[]{"getProperty", string, string2});
    }

    public IASNode getRootNode() {
        Object object = this.invoke("getRootNode");
        if (object instanceof ASObject) {
            return new ASNodeImplV8(null, this.flashPlayer, (ASObject)object);
        }
        return null;
    }

    public boolean hasChild(IASNode iASNode, boolean bl, boolean bl2) {
        if (bl) {
            return true;
        }
        String string = bl ? "getNumSuccessorNodes" : (bl2 ? "getNumSuccessorNodes" : "getNumChildNodes");
        Object object = this.invoke(string, iASNode.getTarget());
        if (object instanceof Integer) {
            return (Integer)object > 0;
        }
        return false;
    }

    public void repairFlash() {
        if (!this._isRepaired) {
            this._isRepaired = true;
            this.invoke("repairFlash", "_level0");
        }
    }

    public IASNode[] searchSound() {
        return this.createFlashNodeArray(this.invoke(new Object[]{"searchSound", "_level0", "_global"}), null);
    }

    public IASNode[] searchVideo() {
        return this.createFlashNodeArray(this.invoke(new Object[]{"searchVideo", "_level0", "_global"}), null);
    }

    public boolean setFocus(String string) {
        Object object = this.invoke("setFocus", string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public boolean setMarker(Number number, Number number2, Number number3, Number number4) {
        this.unsetMarker();
        if (number != null && number2 != null && number3 != null && number4 != null) {
            this.initMarker();
            if (this.objMarker != null) {
                this.invoke(new Object[]{"setMarker", this.objMarker, number, number2, number3, number4});
                return true;
            }
        }
        return false;
    }

    public boolean setMarker(IASNode iASNode) {
        return this.setMarker(iASNode.getX(), iASNode.getY(), iASNode.getWidth(), iASNode.getHeight());
    }

    public void setProperty(String string, String string2, Object object) {
        this.invoke(new Object[]{"setProperty", string, string2, object});
    }

    public IASNode[] translateWithPath(String string) {
        Object object = null;
        try {
            object = this.invoke("translate", string);
        }
        catch (DispatchException dispatchException) {}
        return this.createFlashNodeArray(object, null);
    }

    public boolean unsetMarker() {
        if (this.objMarker == null) {
            return false;
        }
        this.invoke("unsetMarker", this.objMarker);
        return true;
    }

    public boolean updateTarget() {
        Object object = this.invoke(new Object[]{"updateTarget", "_level0", 10});
        return object instanceof Boolean && (Boolean)object != false;
    }

    public boolean clearAllMarkers() {
        this.invoke("clearAllMarkers");
        return true;
    }
}

