/**
 * /**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.util.Weichen_und_GleissperrenAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class Weichen_und_GleissperrenItemProviderAdapterFactory extends Weichen_und_GleissperrenAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Weichen_und_GleissperrenItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Auffahrortung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Auffahrortung_TypeClassItemProvider auffahrortung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Auffahrortung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAuffahrortung_TypeClassAdapter() {
		if (auffahrortung_TypeClassItemProvider == null) {
			auffahrortung_TypeClassItemProvider = new Auffahrortung_TypeClassItemProvider(this);
		}

		return auffahrortung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Austausch_Antriebe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Austausch_Antriebe_TypeClassItemProvider austausch_Antriebe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Austausch_Antriebe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAustausch_Antriebe_TypeClassAdapter() {
		if (austausch_Antriebe_TypeClassItemProvider == null) {
			austausch_Antriebe_TypeClassItemProvider = new Austausch_Antriebe_TypeClassItemProvider(this);
		}

		return austausch_Antriebe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Auswurfrichtung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Auswurfrichtung_TypeClassItemProvider auswurfrichtung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Auswurfrichtung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAuswurfrichtung_TypeClassAdapter() {
		if (auswurfrichtung_TypeClassItemProvider == null) {
			auswurfrichtung_TypeClassItemProvider = new Auswurfrichtung_TypeClassItemProvider(this);
		}

		return auswurfrichtung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Besonderes_Fahrwegelement_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Besonderes_Fahrwegelement_TypeClassItemProvider besonderes_Fahrwegelement_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Besonderes_Fahrwegelement_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBesonderes_Fahrwegelement_TypeClassAdapter() {
		if (besonderes_Fahrwegelement_TypeClassItemProvider == null) {
			besonderes_Fahrwegelement_TypeClassItemProvider = new Besonderes_Fahrwegelement_TypeClassItemProvider(this);
		}

		return besonderes_Fahrwegelement_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Elektrischer_Antrieb_Anzahl_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Elektrischer_Antrieb_Anzahl_TypeClassItemProvider elektrischer_Antrieb_Anzahl_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Elektrischer_Antrieb_Anzahl_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElektrischer_Antrieb_Anzahl_TypeClassAdapter() {
		if (elektrischer_Antrieb_Anzahl_TypeClassItemProvider == null) {
			elektrischer_Antrieb_Anzahl_TypeClassItemProvider = new Elektrischer_Antrieb_Anzahl_TypeClassItemProvider(this);
		}

		return elektrischer_Antrieb_Anzahl_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Elektrischer_Antrieb_Lage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Elektrischer_Antrieb_Lage_TypeClassItemProvider elektrischer_Antrieb_Lage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Elektrischer_Antrieb_Lage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElektrischer_Antrieb_Lage_TypeClassAdapter() {
		if (elektrischer_Antrieb_Lage_TypeClassItemProvider == null) {
			elektrischer_Antrieb_Lage_TypeClassItemProvider = new Elektrischer_Antrieb_Lage_TypeClassItemProvider(this);
		}

		return elektrischer_Antrieb_Lage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Element_Lage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Element_Lage_TypeClassItemProvider element_Lage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Element_Lage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElement_Lage_TypeClassAdapter() {
		if (element_Lage_TypeClassItemProvider == null) {
			element_Lage_TypeClassItemProvider = new Element_Lage_TypeClassItemProvider(this);
		}

		return element_Lage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Entgleisungsschuh_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Entgleisungsschuh_AttributeGroupItemProvider entgleisungsschuh_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Entgleisungsschuh_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEntgleisungsschuh_AttributeGroupAdapter() {
		if (entgleisungsschuh_AttributeGroupItemProvider == null) {
			entgleisungsschuh_AttributeGroupItemProvider = new Entgleisungsschuh_AttributeGroupItemProvider(this);
		}

		return entgleisungsschuh_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Geschwindigkeit_L_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Geschwindigkeit_L_TypeClassItemProvider geschwindigkeit_L_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Geschwindigkeit_L_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeschwindigkeit_L_TypeClassAdapter() {
		if (geschwindigkeit_L_TypeClassItemProvider == null) {
			geschwindigkeit_L_TypeClassItemProvider = new Geschwindigkeit_L_TypeClassItemProvider(this);
		}

		return geschwindigkeit_L_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Geschwindigkeit_R_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Geschwindigkeit_R_TypeClassItemProvider geschwindigkeit_R_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Geschwindigkeit_R_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeschwindigkeit_R_TypeClassAdapter() {
		if (geschwindigkeit_R_TypeClassItemProvider == null) {
			geschwindigkeit_R_TypeClassItemProvider = new Geschwindigkeit_R_TypeClassItemProvider(this);
		}

		return geschwindigkeit_R_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleis_Abschluss} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleis_AbschlussItemProvider gleis_AbschlussItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleis_Abschluss}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleis_AbschlussAdapter() {
		if (gleis_AbschlussItemProvider == null) {
			gleis_AbschlussItemProvider = new Gleis_AbschlussItemProvider(this);
		}

		return gleis_AbschlussItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleis_Abschluss_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleis_Abschluss_Art_TypeClassItemProvider gleis_Abschluss_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleis_Abschluss_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleis_Abschluss_Art_TypeClassAdapter() {
		if (gleis_Abschluss_Art_TypeClassItemProvider == null) {
			gleis_Abschluss_Art_TypeClassItemProvider = new Gleis_Abschluss_Art_TypeClassItemProvider(this);
		}

		return gleis_Abschluss_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleissperre_Betriebsart_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleissperre_Betriebsart_TypeClassItemProvider gleissperre_Betriebsart_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleissperre_Betriebsart_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleissperre_Betriebsart_TypeClassAdapter() {
		if (gleissperre_Betriebsart_TypeClassItemProvider == null) {
			gleissperre_Betriebsart_TypeClassItemProvider = new Gleissperre_Betriebsart_TypeClassItemProvider(this);
		}

		return gleissperre_Betriebsart_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleissperre_Element_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleissperre_Element_AttributeGroupItemProvider gleissperre_Element_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleissperre_Element_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleissperre_Element_AttributeGroupAdapter() {
		if (gleissperre_Element_AttributeGroupItemProvider == null) {
			gleissperre_Element_AttributeGroupItemProvider = new Gleissperre_Element_AttributeGroupItemProvider(this);
		}

		return gleissperre_Element_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleissperre_Vorzugslage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleissperre_Vorzugslage_TypeClassItemProvider gleissperre_Vorzugslage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleissperre_Vorzugslage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleissperre_Vorzugslage_TypeClassAdapter() {
		if (gleissperre_Vorzugslage_TypeClassItemProvider == null) {
			gleissperre_Vorzugslage_TypeClassItemProvider = new Gleissperre_Vorzugslage_TypeClassItemProvider(this);
		}

		return gleissperre_Vorzugslage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleissperrensignal_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleissperrensignal_TypeClassItemProvider gleissperrensignal_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleissperrensignal_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleissperrensignal_TypeClassAdapter() {
		if (gleissperrensignal_TypeClassItemProvider == null) {
			gleissperrensignal_TypeClassItemProvider = new Gleissperrensignal_TypeClassItemProvider(this);
		}

		return gleissperrensignal_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.GZ_Freimeldung_L_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GZ_Freimeldung_L_AttributeGroupItemProvider gZ_Freimeldung_L_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.GZ_Freimeldung_L_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGZ_Freimeldung_L_AttributeGroupAdapter() {
		if (gZ_Freimeldung_L_AttributeGroupItemProvider == null) {
			gZ_Freimeldung_L_AttributeGroupItemProvider = new GZ_Freimeldung_L_AttributeGroupItemProvider(this);
		}

		return gZ_Freimeldung_L_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.GZ_Freimeldung_R_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GZ_Freimeldung_R_AttributeGroupItemProvider gZ_Freimeldung_R_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.GZ_Freimeldung_R_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGZ_Freimeldung_R_AttributeGroupAdapter() {
		if (gZ_Freimeldung_R_AttributeGroupItemProvider == null) {
			gZ_Freimeldung_R_AttributeGroupItemProvider = new GZ_Freimeldung_R_AttributeGroupItemProvider(this);
		}

		return gZ_Freimeldung_R_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Herzstueck_Antriebe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Herzstueck_Antriebe_TypeClassItemProvider herzstueck_Antriebe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Herzstueck_Antriebe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHerzstueck_Antriebe_TypeClassAdapter() {
		if (herzstueck_Antriebe_TypeClassItemProvider == null) {
			herzstueck_Antriebe_TypeClassItemProvider = new Herzstueck_Antriebe_TypeClassItemProvider(this);
		}

		return herzstueck_Antriebe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Isolierfall_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Isolierfall_TypeClassItemProvider isolierfall_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Isolierfall_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIsolierfall_TypeClassAdapter() {
		if (isolierfall_TypeClassItemProvider == null) {
			isolierfall_TypeClassItemProvider = new Isolierfall_TypeClassItemProvider(this);
		}

		return isolierfall_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Kr_KrW_Seitenzuordnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Kr_KrW_Seitenzuordnung_TypeClassItemProvider kr_KrW_Seitenzuordnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Kr_KrW_Seitenzuordnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKr_KrW_Seitenzuordnung_TypeClassAdapter() {
		if (kr_KrW_Seitenzuordnung_TypeClassItemProvider == null) {
			kr_KrW_Seitenzuordnung_TypeClassItemProvider = new Kr_KrW_Seitenzuordnung_TypeClassItemProvider(this);
		}

		return kr_KrW_Seitenzuordnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Kreuzung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Kreuzung_AttributeGroupItemProvider kreuzung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Kreuzung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKreuzung_AttributeGroupAdapter() {
		if (kreuzung_AttributeGroupItemProvider == null) {
			kreuzung_AttributeGroupItemProvider = new Kreuzung_AttributeGroupItemProvider(this);
		}

		return kreuzung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Kreuzungsgleis_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Kreuzungsgleis_TypeClassItemProvider kreuzungsgleis_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Kreuzungsgleis_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKreuzungsgleis_TypeClassAdapter() {
		if (kreuzungsgleis_TypeClassItemProvider == null) {
			kreuzungsgleis_TypeClassItemProvider = new Kreuzungsgleis_TypeClassItemProvider(this);
		}

		return kreuzungsgleis_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Schutzschiene_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schutzschiene_TypeClassItemProvider schutzschiene_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Schutzschiene_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchutzschiene_TypeClassAdapter() {
		if (schutzschiene_TypeClassItemProvider == null) {
			schutzschiene_TypeClassItemProvider = new Schutzschiene_TypeClassItemProvider(this);
		}

		return schutzschiene_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Stammgleis_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Stammgleis_TypeClassItemProvider stammgleis_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Stammgleis_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStammgleis_TypeClassAdapter() {
		if (stammgleis_TypeClassItemProvider == null) {
			stammgleis_TypeClassItemProvider = new Stammgleis_TypeClassItemProvider(this);
		}

		return stammgleis_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Vorzugslage_Automatik_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Vorzugslage_Automatik_TypeClassItemProvider vorzugslage_Automatik_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Vorzugslage_Automatik_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVorzugslage_Automatik_TypeClassAdapter() {
		if (vorzugslage_Automatik_TypeClassItemProvider == null) {
			vorzugslage_Automatik_TypeClassItemProvider = new Vorzugslage_Automatik_TypeClassItemProvider(this);
		}

		return vorzugslage_Automatik_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Anlage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected W_Kr_AnlageItemProvider w_Kr_AnlageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Anlage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createW_Kr_AnlageAdapter() {
		if (w_Kr_AnlageItemProvider == null) {
			w_Kr_AnlageItemProvider = new W_Kr_AnlageItemProvider(this);
		}

		return w_Kr_AnlageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Anlage_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected W_Kr_Anlage_Allg_AttributeGroupItemProvider w_Kr_Anlage_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Anlage_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createW_Kr_Anlage_Allg_AttributeGroupAdapter() {
		if (w_Kr_Anlage_Allg_AttributeGroupItemProvider == null) {
			w_Kr_Anlage_Allg_AttributeGroupItemProvider = new W_Kr_Anlage_Allg_AttributeGroupItemProvider(this);
		}

		return w_Kr_Anlage_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected W_Kr_Art_TypeClassItemProvider w_Kr_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createW_Kr_Art_TypeClassAdapter() {
		if (w_Kr_Art_TypeClassItemProvider == null) {
			w_Kr_Art_TypeClassItemProvider = new W_Kr_Art_TypeClassItemProvider(this);
		}

		return w_Kr_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Grundform_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected W_Kr_Grundform_TypeClassItemProvider w_Kr_Grundform_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Grundform_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createW_Kr_Grundform_TypeClassAdapter() {
		if (w_Kr_Grundform_TypeClassItemProvider == null) {
			w_Kr_Grundform_TypeClassItemProvider = new W_Kr_Grundform_TypeClassItemProvider(this);
		}

		return w_Kr_Grundform_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected W_Kr_Gsp_ElementItemProvider w_Kr_Gsp_ElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createW_Kr_Gsp_ElementAdapter() {
		if (w_Kr_Gsp_ElementItemProvider == null) {
			w_Kr_Gsp_ElementItemProvider = new W_Kr_Gsp_ElementItemProvider(this);
		}

		return w_Kr_Gsp_ElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected W_Kr_Gsp_Element_Allg_AttributeGroupItemProvider w_Kr_Gsp_Element_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createW_Kr_Gsp_Element_Allg_AttributeGroupAdapter() {
		if (w_Kr_Gsp_Element_Allg_AttributeGroupItemProvider == null) {
			w_Kr_Gsp_Element_Allg_AttributeGroupItemProvider = new W_Kr_Gsp_Element_Allg_AttributeGroupItemProvider(this);
		}

		return w_Kr_Gsp_Element_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected W_Kr_Gsp_KomponenteItemProvider w_Kr_Gsp_KomponenteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createW_Kr_Gsp_KomponenteAdapter() {
		if (w_Kr_Gsp_KomponenteItemProvider == null) {
			w_Kr_Gsp_KomponenteItemProvider = new W_Kr_Gsp_KomponenteItemProvider(this);
		}

		return w_Kr_Gsp_KomponenteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Stellart_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected W_Kr_Gsp_Stellart_TypeClassItemProvider w_Kr_Gsp_Stellart_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Stellart_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createW_Kr_Gsp_Stellart_TypeClassAdapter() {
		if (w_Kr_Gsp_Stellart_TypeClassItemProvider == null) {
			w_Kr_Gsp_Stellart_TypeClassItemProvider = new W_Kr_Gsp_Stellart_TypeClassItemProvider(this);
		}

		return w_Kr_Gsp_Stellart_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weiche_Betriebsart_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Weiche_Betriebsart_TypeClassItemProvider weiche_Betriebsart_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weiche_Betriebsart_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWeiche_Betriebsart_TypeClassAdapter() {
		if (weiche_Betriebsart_TypeClassItemProvider == null) {
			weiche_Betriebsart_TypeClassItemProvider = new Weiche_Betriebsart_TypeClassItemProvider(this);
		}

		return weiche_Betriebsart_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weiche_Element_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Weiche_Element_AttributeGroupItemProvider weiche_Element_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weiche_Element_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWeiche_Element_AttributeGroupAdapter() {
		if (weiche_Element_AttributeGroupItemProvider == null) {
			weiche_Element_AttributeGroupItemProvider = new Weiche_Element_AttributeGroupItemProvider(this);
		}

		return weiche_Element_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weiche_Vorzugslage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Weiche_Vorzugslage_TypeClassItemProvider weiche_Vorzugslage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weiche_Vorzugslage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWeiche_Vorzugslage_TypeClassAdapter() {
		if (weiche_Vorzugslage_TypeClassItemProvider == null) {
			weiche_Vorzugslage_TypeClassItemProvider = new Weiche_Vorzugslage_TypeClassItemProvider(this);
		}

		return weiche_Vorzugslage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weichenlaufkette} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WeichenlaufketteItemProvider weichenlaufketteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weichenlaufkette}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWeichenlaufketteAdapter() {
		if (weichenlaufketteItemProvider == null) {
			weichenlaufketteItemProvider = new WeichenlaufketteItemProvider(this);
		}

		return weichenlaufketteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weichenlaufkette_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Weichenlaufkette_ZuordnungItemProvider weichenlaufkette_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weichenlaufkette_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWeichenlaufkette_ZuordnungAdapter() {
		if (weichenlaufkette_ZuordnungItemProvider == null) {
			weichenlaufkette_ZuordnungItemProvider = new Weichenlaufkette_ZuordnungItemProvider(this);
		}

		return weichenlaufkette_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weichensignal_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Weichensignal_TypeClassItemProvider weichensignal_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weichensignal_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWeichensignal_TypeClassAdapter() {
		if (weichensignal_TypeClassItemProvider == null) {
			weichensignal_TypeClassItemProvider = new Weichensignal_TypeClassItemProvider(this);
		}

		return weichensignal_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zungenpaar_AttributeGroupItemProvider zungenpaar_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZungenpaar_AttributeGroupAdapter() {
		if (zungenpaar_AttributeGroupItemProvider == null) {
			zungenpaar_AttributeGroupItemProvider = new Zungenpaar_AttributeGroupItemProvider(this);
		}

		return zungenpaar_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Zungenpruefkontakt_Anzahl_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zungenpruefkontakt_Anzahl_TypeClassItemProvider zungenpruefkontakt_Anzahl_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Zungenpruefkontakt_Anzahl_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZungenpruefkontakt_Anzahl_TypeClassAdapter() {
		if (zungenpruefkontakt_Anzahl_TypeClassItemProvider == null) {
			zungenpruefkontakt_Anzahl_TypeClassItemProvider = new Zungenpruefkontakt_Anzahl_TypeClassItemProvider(this);
		}

		return zungenpruefkontakt_Anzahl_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (auffahrortung_TypeClassItemProvider != null) auffahrortung_TypeClassItemProvider.dispose();
		if (austausch_Antriebe_TypeClassItemProvider != null) austausch_Antriebe_TypeClassItemProvider.dispose();
		if (auswurfrichtung_TypeClassItemProvider != null) auswurfrichtung_TypeClassItemProvider.dispose();
		if (besonderes_Fahrwegelement_TypeClassItemProvider != null) besonderes_Fahrwegelement_TypeClassItemProvider.dispose();
		if (elektrischer_Antrieb_Anzahl_TypeClassItemProvider != null) elektrischer_Antrieb_Anzahl_TypeClassItemProvider.dispose();
		if (elektrischer_Antrieb_Lage_TypeClassItemProvider != null) elektrischer_Antrieb_Lage_TypeClassItemProvider.dispose();
		if (element_Lage_TypeClassItemProvider != null) element_Lage_TypeClassItemProvider.dispose();
		if (entgleisungsschuh_AttributeGroupItemProvider != null) entgleisungsschuh_AttributeGroupItemProvider.dispose();
		if (geschwindigkeit_L_TypeClassItemProvider != null) geschwindigkeit_L_TypeClassItemProvider.dispose();
		if (geschwindigkeit_R_TypeClassItemProvider != null) geschwindigkeit_R_TypeClassItemProvider.dispose();
		if (gleis_AbschlussItemProvider != null) gleis_AbschlussItemProvider.dispose();
		if (gleis_Abschluss_Art_TypeClassItemProvider != null) gleis_Abschluss_Art_TypeClassItemProvider.dispose();
		if (gleissperre_Betriebsart_TypeClassItemProvider != null) gleissperre_Betriebsart_TypeClassItemProvider.dispose();
		if (gleissperre_Element_AttributeGroupItemProvider != null) gleissperre_Element_AttributeGroupItemProvider.dispose();
		if (gleissperre_Vorzugslage_TypeClassItemProvider != null) gleissperre_Vorzugslage_TypeClassItemProvider.dispose();
		if (gleissperrensignal_TypeClassItemProvider != null) gleissperrensignal_TypeClassItemProvider.dispose();
		if (gZ_Freimeldung_L_AttributeGroupItemProvider != null) gZ_Freimeldung_L_AttributeGroupItemProvider.dispose();
		if (gZ_Freimeldung_R_AttributeGroupItemProvider != null) gZ_Freimeldung_R_AttributeGroupItemProvider.dispose();
		if (herzstueck_Antriebe_TypeClassItemProvider != null) herzstueck_Antriebe_TypeClassItemProvider.dispose();
		if (isolierfall_TypeClassItemProvider != null) isolierfall_TypeClassItemProvider.dispose();
		if (kr_KrW_Seitenzuordnung_TypeClassItemProvider != null) kr_KrW_Seitenzuordnung_TypeClassItemProvider.dispose();
		if (kreuzung_AttributeGroupItemProvider != null) kreuzung_AttributeGroupItemProvider.dispose();
		if (kreuzungsgleis_TypeClassItemProvider != null) kreuzungsgleis_TypeClassItemProvider.dispose();
		if (schutzschiene_TypeClassItemProvider != null) schutzschiene_TypeClassItemProvider.dispose();
		if (stammgleis_TypeClassItemProvider != null) stammgleis_TypeClassItemProvider.dispose();
		if (vorzugslage_Automatik_TypeClassItemProvider != null) vorzugslage_Automatik_TypeClassItemProvider.dispose();
		if (w_Kr_AnlageItemProvider != null) w_Kr_AnlageItemProvider.dispose();
		if (w_Kr_Anlage_Allg_AttributeGroupItemProvider != null) w_Kr_Anlage_Allg_AttributeGroupItemProvider.dispose();
		if (w_Kr_Art_TypeClassItemProvider != null) w_Kr_Art_TypeClassItemProvider.dispose();
		if (w_Kr_Grundform_TypeClassItemProvider != null) w_Kr_Grundform_TypeClassItemProvider.dispose();
		if (w_Kr_Gsp_ElementItemProvider != null) w_Kr_Gsp_ElementItemProvider.dispose();
		if (w_Kr_Gsp_Element_Allg_AttributeGroupItemProvider != null) w_Kr_Gsp_Element_Allg_AttributeGroupItemProvider.dispose();
		if (w_Kr_Gsp_KomponenteItemProvider != null) w_Kr_Gsp_KomponenteItemProvider.dispose();
		if (w_Kr_Gsp_Stellart_TypeClassItemProvider != null) w_Kr_Gsp_Stellart_TypeClassItemProvider.dispose();
		if (weiche_Betriebsart_TypeClassItemProvider != null) weiche_Betriebsart_TypeClassItemProvider.dispose();
		if (weiche_Element_AttributeGroupItemProvider != null) weiche_Element_AttributeGroupItemProvider.dispose();
		if (weiche_Vorzugslage_TypeClassItemProvider != null) weiche_Vorzugslage_TypeClassItemProvider.dispose();
		if (weichenlaufketteItemProvider != null) weichenlaufketteItemProvider.dispose();
		if (weichenlaufkette_ZuordnungItemProvider != null) weichenlaufkette_ZuordnungItemProvider.dispose();
		if (weichensignal_TypeClassItemProvider != null) weichensignal_TypeClassItemProvider.dispose();
		if (zungenpaar_AttributeGroupItemProvider != null) zungenpaar_AttributeGroupItemProvider.dispose();
		if (zungenpruefkontakt_Anzahl_TypeClassItemProvider != null) zungenpruefkontakt_Anzahl_TypeClassItemProvider.dispose();
	}

}
