/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.git.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.git.ConfigSection;
import org.eclipse.oomph.setup.git.GitConfigurationTask;
import org.eclipse.oomph.setup.git.GitPackage;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.util.StringUtil;

public class GitConfigurationTaskImpl
extends SetupTaskImpl
implements GitConfigurationTask {
    protected static final String REMOTE_URI_PATTERN_EDEFAULT = "";
    protected String remoteURIPattern = "";
    protected EList<ConfigSection> configSections;
    private static final String GIT_CONFIGURATION_TASKS = "oomph.setup.git.configuration.tasks";

    protected GitConfigurationTaskImpl() {
    }

    protected EClass eStaticClass() {
        return GitPackage.Literals.GIT_CONFIGURATION_TASK;
    }

    @Override
    public String getRemoteURIPattern() {
        return this.remoteURIPattern;
    }

    @Override
    public void setRemoteURIPattern(String newRemoteURIPattern) {
        String oldRemoteURIPattern = this.remoteURIPattern;
        this.remoteURIPattern = newRemoteURIPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldRemoteURIPattern, (Object)this.remoteURIPattern));
        }
    }

    @Override
    public EList<ConfigSection> getConfigSections() {
        if (this.configSections == null) {
            this.configSections = new EObjectContainmentEList(ConfigSection.class, (InternalEObject)this, 11);
        }
        return this.configSections;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return ((InternalEList)this.getConfigSections()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getRemoteURIPattern();
            }
            case 11: {
                return this.getConfigSections();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setRemoteURIPattern((String)newValue);
                return;
            }
            case 11: {
                this.getConfigSections().clear();
                this.getConfigSections().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setRemoteURIPattern(REMOTE_URI_PATTERN_EDEFAULT);
                return;
            }
            case 11: {
                this.getConfigSections().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return REMOTE_URI_PATTERN_EDEFAULT == null ? this.remoteURIPattern != null : !REMOTE_URI_PATTERN_EDEFAULT.equals(this.remoteURIPattern);
            }
            case 11: {
                return this.configSections != null && !this.configSections.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (remoteURIPattern: ");
        result.append(this.remoteURIPattern);
        result.append(')');
        return result.toString();
    }

    public int getPriority() {
        return 400;
    }

    public Object getOverrideToken() {
        return super.getOverrideToken();
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        String remoteURIPattern = this.getRemoteURIPattern();
        if (!StringUtil.isEmpty((String)remoteURIPattern)) {
            try {
                Pattern.compile(remoteURIPattern);
                GitConfigurationTaskImpl.getGitConfigurationTasks(context).add(this);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    public void perform(SetupTaskContext context) throws Exception {
    }

    static List<GitConfigurationTask> getGitConfigurationTasks(SetupTaskContext context) {
        ArrayList result = (ArrayList)context.get((Object)GIT_CONFIGURATION_TASKS);
        if (result == null) {
            result = new ArrayList();
            context.put((Object)GIT_CONFIGURATION_TASKS, result);
        }
        return result;
    }
}

