/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.annotations.Beta;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@ImplementedBy(value=OnlyWithoutErrors.class)
@Beta
public interface IShouldGenerate {
    public boolean shouldGenerate(Resource var1, CancelIndicator var2);

    @Singleton
    @Beta
    public static class Always
    implements IShouldGenerate {
        @Override
        public boolean shouldGenerate(Resource resource, CancelIndicator cancelIndicator) {
            return true;
        }
    }

    @Singleton
    @Beta
    public static class OnlyWithoutErrors
    implements IShouldGenerate {
        @Inject
        private IResourceValidator resourceValidator;

        @Override
        public boolean shouldGenerate(Resource resource, CancelIndicator cancelIndicator) {
            if (!resource.getErrors().isEmpty()) {
                return false;
            }
            List<Issue> issues = this.resourceValidator.validate(resource, CheckMode.NORMAL_AND_FAST, cancelIndicator);
            return !IterableExtensions.exists(issues, issue -> Objects.equals((Object)issue.getSeverity(), (Object)Severity.ERROR));
        }
    }
}

