/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.common.internal.utils;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.uml.m2m.qvto.common.Activator;
import org.eclipse.papyrus.uml.m2m.qvto.common.internal.utils.CreateFile;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateProject {
    protected String projectName = this.getProjectName();
    protected IProject createdProject;
    protected Collection<Object> inputFiles;

    public CreateProject(Collection<Object> inputFiles) {
        this.inputFiles = inputFiles;
        if (this.projectName != null) {
            try {
                this.createdProject = this.createProject();
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected IProject createProject() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.projectName);
        if (!project.exists()) {
            project.create((IProgressMonitor)new NullProgressMonitor());
        }
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        if (this.inputFiles != null && !this.inputFiles.isEmpty()) {
            this.createFolder("resources", project, this.inputFiles);
        }
        return project;
    }

    protected void createFolder(String folderName, IProject project, Collection<Object> inputFiles) throws Exception {
        IFolder folder = project.getFolder(folderName);
        folder.create(false, true, null);
        ArrayList<Object> inputList = new ArrayList<Object>(inputFiles);
        for (Object e : inputList) {
            File file = (File)e;
            IFile linkedFile = folder.getFile(file.getName());
            URI fileURI = file.toURI();
            linkedFile.createLink(fileURI, 0, null);
        }
    }

    protected void createBuildProps(IProject project, List<String> srcFolders) throws Exception {
        StringBuilder bpContent = new StringBuilder("source.. = ");
        if (srcFolders != null && !srcFolders.isEmpty()) {
            Iterator<String> iterator = srcFolders.iterator();
            while (iterator.hasNext()) {
                bpContent.append(iterator.next()).append(File.separatorChar);
                if (!iterator.hasNext()) continue;
                bpContent.append(",");
            }
        }
        bpContent.append("\n");
        bpContent.append("bin.includes = META-INF/,.\n");
        CreateFile.createFile("build.properties", (IContainer)project, bpContent.toString());
    }

    public IProject getCreatedProject() {
        return this.createdProject;
    }

    protected String getProjectName() {
        String init_value = "project_" + System.currentTimeMillis();
        Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        InputDialog dialog = new InputDialog(activeShell, "Create Project", "Provide project name...", init_value, new IInputValidator(){

            public String isValid(String newText) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject[] projs = root.getProjects();
                int i = 0;
                while (i < projs.length) {
                    if (projs[i].getName().equalsIgnoreCase(newText)) {
                        return "This project already exists";
                    }
                    ++i;
                }
                return null;
            }
        });
        if (dialog.open() == 1) {
            return null;
        }
        return dialog.getValue();
    }
}

