/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.matcher;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IKeyEventMatcher;
import org.eclipse.swt.events.KeyEvent;

public class SelectionAnchorCellLabelKeyEventMatcher
implements IKeyEventMatcher {
    protected final SelectionLayer selectionLayer;
    protected final IUniqueIndexLayer layer;
    protected final String labelToMatch;
    protected final IKeyEventMatcher aggregate;

    public SelectionAnchorCellLabelKeyEventMatcher(SelectionLayer selectionLayer, IUniqueIndexLayer layer, String labelToMatch) {
        this(selectionLayer, layer, labelToMatch, null);
    }

    public SelectionAnchorCellLabelKeyEventMatcher(SelectionLayer selectionLayer, IUniqueIndexLayer layer, String labelToMatch, IKeyEventMatcher aggregate) {
        if (selectionLayer == null) {
            throw new IllegalArgumentException("selectionLayer must not be null.");
        }
        if (layer == null) {
            throw new IllegalArgumentException("layer must not be null.");
        }
        if (labelToMatch == null || labelToMatch.length() == 0) {
            throw new IllegalArgumentException("labelToMatch must not be blank.");
        }
        this.selectionLayer = selectionLayer;
        this.layer = layer;
        this.labelToMatch = labelToMatch;
        this.aggregate = aggregate;
    }

    @Override
    public boolean matches(KeyEvent event) {
        PositionCoordinate anchorPosition = this.selectionLayer.getSelectionAnchor();
        if (anchorPosition.rowPosition != -1 && anchorPosition.columnPosition != -1) {
            int layerColumnPosition = LayerUtil.convertColumnPosition(this.selectionLayer, anchorPosition.columnPosition, this.layer);
            int layerRowPosition = LayerUtil.convertRowPosition(this.selectionLayer, anchorPosition.rowPosition, this.layer);
            LabelStack labels = this.layer.getConfigLabelsByPosition(layerColumnPosition, layerRowPosition);
            boolean labelMatches = labels.hasLabel(this.labelToMatch);
            if (this.aggregate != null) {
                return labelMatches && this.aggregate.matches(event);
            }
            return labelMatches;
        }
        return false;
    }

    public static SelectionAnchorCellLabelKeyEventMatcher anchorLabel(SelectionLayer selectionLayer, IUniqueIndexLayer layer, String labelToMatch) {
        return SelectionAnchorCellLabelKeyEventMatcher.anchorLabel(selectionLayer, layer, labelToMatch, null);
    }

    public static SelectionAnchorCellLabelKeyEventMatcher anchorLabel(SelectionLayer selectionLayer, IUniqueIndexLayer layer, String labelToMatch, IKeyEventMatcher aggregate) {
        return new SelectionAnchorCellLabelKeyEventMatcher(selectionLayer, layer, labelToMatch, aggregate);
    }
}

