/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.helper.advice.InteractionFragmentEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;

public class ExecutionSpecificationHelperAdvice
extends InteractionFragmentEditHelperAdvice {
    public void configureRequest(IEditCommandRequest request) {
        super.configureRequest(request);
        if (request instanceof CreateElementRequest) {
            this.configureCreate((CreateElementRequest)request);
        }
    }

    private void configureCreate(CreateElementRequest request) {
        if (ElementUtil.isTypeOf(request.getElementType(), (IElementType)UMLElementTypes.TIME_CONSTRAINT) && request.getContainer() instanceof ExecutionSpecification) {
            ExecutionSpecification executionSpecification = (ExecutionSpecification)request.getContainer();
            Interaction interaction = executionSpecification.getEnclosingInteraction();
            if (interaction != null) {
                request.setContainer((EObject)interaction);
            } else {
                InteractionOperand operand = executionSpecification.getEnclosingOperand();
                if (operand != null) {
                    request.setContainer((EObject)operand);
                }
            }
        }
    }

    public static ExecutionOccurrenceSpecification createOccurenceSpecification(ExecutionSpecification execution, Lifeline lifeline) {
        ExecutionOccurrenceSpecification occurrenceSpecification = UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification();
        occurrenceSpecification.setCovered(lifeline);
        ((Interaction)execution.getOwner()).getFragments().add((Object)occurrenceSpecification);
        return occurrenceSpecification;
    }

    @Override
    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        ICommand superResult = super.getBeforeConfigureCommand(request);
        final ExecutionSpecification execution = (ExecutionSpecification)request.getElementToConfigure();
        final Lifeline coveredLifeline = (Lifeline)Iterables.getFirst(RequestParameterUtils.getCoveredLifelines((IEditCommandRequest)request), null);
        if (coveredLifeline == null) {
            return superResult;
        }
        ConfigureElementCommand result = new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Object replaceStart = request.getParameters().get("REPLACE_EXECUTION_SPECIFICATION_START");
                if (replaceStart instanceof MessageOccurrenceSpecification) {
                    execution.setStart((OccurrenceSpecification)((MessageOccurrenceSpecification)replaceStart));
                } else {
                    ExecutionOccurrenceSpecification start = ExecutionSpecificationHelperAdvice.createOccurenceSpecification(execution, coveredLifeline);
                    start.setName(execution.getName() + "Start");
                    start.setExecution(execution);
                    execution.setStart((OccurrenceSpecification)start);
                }
                Object replaceFinish = request.getParameters().get("REPLACE_EXECUTION_SPECIFICATION_FINISH");
                if (replaceFinish instanceof MessageOccurrenceSpecification) {
                    execution.setFinish((OccurrenceSpecification)((MessageOccurrenceSpecification)replaceFinish));
                } else {
                    ExecutionOccurrenceSpecification finish = ExecutionSpecificationHelperAdvice.createOccurenceSpecification(execution, coveredLifeline);
                    finish.setName(execution.getName() + "Finish");
                    finish.setExecution(execution);
                    execution.setFinish((OccurrenceSpecification)finish);
                }
                return CommandResult.newOKCommandResult((Object)execution);
            }
        };
        return superResult != null ? superResult.compose((IUndoableOperation)result) : result;
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        OccurrenceSpecification osFinish;
        OccurrenceSpecification osStart;
        ArrayList<OccurrenceSpecification> dependentsToDestroy = new ArrayList<OccurrenceSpecification>();
        ExecutionSpecification es = (ExecutionSpecification)request.getElementToDestroy();
        if (this.shouldDestroyOccurrenceSpecification(es, osStart = es.getStart()) && !(osStart instanceof MessageEnd)) {
            dependentsToDestroy.add(osStart);
        }
        if (this.shouldDestroyOccurrenceSpecification(es, osFinish = es.getFinish()) && !(osFinish instanceof MessageEnd)) {
            dependentsToDestroy.add(osFinish);
        }
        if (!dependentsToDestroy.isEmpty()) {
            return request.getDestroyDependentsCommand(dependentsToDestroy);
        }
        return null;
    }

    private boolean shouldDestroyOccurrenceSpecification(ExecutionSpecification es, OccurrenceSpecification os) {
        return os instanceof ExecutionOccurrenceSpecification || os != null && EMFHelper.isOnlyUsage((EObject)os, (EObject)es);
    }
}

