/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor;

import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.xtend.shared.ui.editor.BreakpointActionGroup;
import org.eclipse.xtend.shared.ui.editor.navigation.OpenAction;
import org.eclipse.xtend.shared.ui.editor.outlineview.AbstractExtXptContentOutlinePage;
import org.eclipse.xtend.shared.ui.editor.search.actions.SearchActionGroup;

public abstract class AbstractXtendXpandEditor
extends TextEditor {
    private AbstractExtXptContentOutlinePage outlinePage = null;
    private SearchActionGroup searchActionGroup;
    private BreakpointActionGroup bpActionGroup;

    public void doRevertToSaved() {
        super.doRevertToSaved();
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
    }

    public void doSave(IProgressMonitor aMonitor) {
        super.doSave(aMonitor);
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("oaw"));
        super.editorContextMenuAboutToShow(menu);
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.searchActionGroup.setContext(context);
        this.searchActionGroup.fillContextMenu(menu);
        this.searchActionGroup.setContext(null);
        this.bpActionGroup.fillContextMenu(menu);
    }

    public Object getAdapter(Class aRequired) {
        if (IContentOutlinePage.class.equals((Object)aRequired)) {
            if (this.outlinePage == null) {
                this.outlinePage = this.createOutlinePage();
                if (this.getEditorInput() != null) {
                    this.outlinePage.setInput(this.getEditorInput());
                }
            }
            return this.outlinePage;
        }
        return super.getAdapter(aRequired);
    }

    protected abstract AbstractExtXptContentOutlinePage createOutlinePage();

    protected void createActions() {
        super.createActions();
        ResourceBundle rb = new ResourceBundle(){

            public Enumeration getKeys() {
                return new Vector().elements();
            }

            protected Object handleGetObject(String key) {
                return null;
            }
        };
        TextOperationAction a = new TextOperationAction(rb, "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(rb, "ContentAssistTip.", (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        OpenAction openAction = new OpenAction(this);
        openAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        this.setAction("org.eclipse.jdt.ui.actions.Open", (IAction)openAction);
        this.searchActionGroup = new SearchActionGroup(this);
        this.bpActionGroup = new BreakpointActionGroup(this);
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("oaw"));
        super.rulerContextMenuAboutToShow(menu);
        this.bpActionGroup.fillContextMenu(menu);
    }

    public ISourceViewer internalGetSourceViewer() {
        return this.getSourceViewer();
    }
}

