/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.JETActivatorWrapper;
import org.eclipse.jet.internal.SavedStateManager;
import org.eclipse.jet.internal.builder.WorkspaceCompiler;
import org.eclipse.jet.internal.compiler.SimplifiedCompiler;
import org.eclipse.jet.internal.core.compiler.IJETCompiler;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.osgi.util.NLS;

public class JET2Builder
extends IncrementalProjectBuilder
implements SavedStateManager.IStateSaver {
    private static boolean DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/builder")) != false;
    static final String COMPILESTATE_PROJECT_DIR = "projects";
    private Serializable savedState;
    private final SavedStateManager savedStateManager = InternalJET2Platform.getDefault().getSavedStateManager();

    protected void clean(IProgressMonitor monitor) throws CoreException {
        if (DEBUG) {
            System.out.println("JET2Builder: cleaning " + this.getProject());
        }
        this.getCompiler((IProgressMonitor)new SubProgressMonitor(monitor, 1)).clean();
        this.savedState = null;
        if (DEBUG) {
            System.out.println("*JET2Builder: done cleaning " + this.getProject());
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject[] projectDependencies = null;
        if (DEBUG) {
            System.out.println("JET2Builder: build(" + this.getProject() + ", " + kind + ")");
        }
        try {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (kind == 6 || this.isReferencedProjectChanged() || delta == null) {
                monitor.beginTask(NLS.bind((String)JET2Messages.JET2Builder_CompilingAll, (Object)this.getProject().getName()), 2);
                this.clean((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                projectDependencies = this.fullBuild((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                monitor.done();
            } else {
                projectDependencies = this.incrementalBuild(delta, monitor);
            }
            IProject[] iProjectArray = projectDependencies;
            Object var6_7 = null;
            if (DEBUG) {
                System.out.println("JET2Builder: done build(" + this.getProject() + ", " + kind + ")");
            }
            return iProjectArray;
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_8 = null;
                if (!DEBUG) break block6;
                System.out.println("JET2Builder: done build(" + this.getProject() + ", " + kind + ")");
            }
            throw throwable;
        }
    }

    private boolean isReferencedProjectChanged() {
        IProject[] projects = this.computeReferencedProjects(this.getCompiler(null).getTagLibaryDependencies());
        int i = 0;
        while (i < projects.length) {
            IResourceDelta delta = this.getDelta(projects[i]);
            if (delta != null && (delta.findMember((IPath)new Path("plugin.xml")) != null || delta.findMember((IPath)new Path("META-INF/MANIFEST.MF")) != null)) {
                if (DEBUG) {
                    System.out.println("   forcing full build. ref updated:" + projects[i]);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private IProject[] incrementalBuild(IResourceDelta mainDelta, IProgressMonitor monitor) throws CoreException {
        IProject[] iProjectArray;
        if (DEBUG) {
            System.out.println("JET2Builder: incrementalBuild " + this.getProject());
        }
        final IJETCompiler compiler = this.getCompiler(monitor);
        final HashSet templatesToRemove = new HashSet();
        final HashSet templatesToCompile = new HashSet();
        mainDelta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                String templatePath = delta.getResource().getProjectRelativePath().toString();
                switch (delta.getKind()) {
                    case 1: 
                    case 4: {
                        if (compiler.isTemplate(templatePath)) {
                            templatesToCompile.add(templatePath);
                        }
                        templatesToCompile.addAll(Arrays.asList(compiler.getAffectedTemplatePaths(templatePath)));
                        break;
                    }
                    case 2: {
                        if (compiler.isTemplate(templatePath)) {
                            templatesToRemove.add(templatePath);
                        }
                        templatesToCompile.addAll(Arrays.asList(compiler.getAffectedTemplatePaths(templatePath)));
                    }
                }
                return true;
            }
        });
        monitor.beginTask(NLS.bind((String)JET2Messages.JET2Builder_CompilingChanged, (Object)this.getProject().getName()), templatesToCompile.size() + templatesToRemove.size());
        try {
            String templatePath;
            Iterator i = templatesToRemove.iterator();
            while (i.hasNext()) {
                templatePath = (String)i.next();
                monitor.setTaskName(NLS.bind((String)JET2Messages.JET2Builder_Cleaning, (Object)templatePath));
                compiler.removeTemplate(templatePath);
                monitor.worked(1);
            }
            i = templatesToCompile.iterator();
            while (i.hasNext()) {
                templatePath = (String)i.next();
                monitor.setTaskName(NLS.bind((String)JET2Messages.JET2Builder_Compiling, (Object)templatePath));
                compiler.compile(templatePath);
                monitor.worked(1);
            }
            if (templatesToCompile.size() > 0 || templatesToRemove.size() > 0) {
                compiler.finish();
            }
            this.savedState = compiler.getMemento();
            iProjectArray = this.computeReferencedProjects(compiler.getTagLibaryDependencies());
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var8_10 = null;
                monitor.done();
                if (!DEBUG) break block7;
                System.out.println("JET2Builder: done incrementalBuild " + this.getProject());
            }
            throw throwable;
        }
        monitor.done();
        if (DEBUG) {
            System.out.println("JET2Builder: done incrementalBuild " + this.getProject());
        }
        return iProjectArray;
    }

    private IProject[] fullBuild(IProgressMonitor monitor) throws CoreException {
        if (DEBUG) {
            System.out.println("JET2Builder: fullBuild " + this.getProject());
        }
        final IJETCompiler compiler = this.getCompiler(monitor);
        final HashSet templatesToCompile = new HashSet();
        this.getProject().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                String templatePath = resource.getProjectRelativePath().toString();
                if (resource.getType() == 1 && compiler.isTemplate(templatePath)) {
                    templatesToCompile.add(templatePath);
                }
                return true;
            }
        });
        monitor.beginTask(NLS.bind((String)JET2Messages.JET2Builder_CompilingAll, (Object)this.getProject().getName()), templatesToCompile.size());
        Iterator i = templatesToCompile.iterator();
        while (i.hasNext()) {
            String templatePath = (String)i.next();
            compiler.compile(templatePath);
        }
        compiler.finish();
        this.savedState = compiler.getMemento();
        monitor.done();
        if (DEBUG) {
            System.out.println("JET2Builder: done fullBuild " + this.getProject());
        }
        return this.computeReferencedProjects(compiler.getTagLibaryDependencies());
    }

    private IJETCompiler getCompiler(IProgressMonitor monitor) {
        return new WorkspaceCompiler(this.getProject(), this.savedState, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startupOnInitialize() {
        block7: {
            block8: {
                super.startupOnInitialize();
                if (DEBUG) {
                    System.out.println("JET2Builder: startupOnInitialize " + this.getProject());
                }
                try {
                    IPath fileLocation = this.savedStateManager.addSaveSaver(this, this.getProject());
                    if (fileLocation != null) {
                        File savedStateFile = fileLocation.toFile();
                        this.readSavedState(savedStateFile);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    if (this.savedState == null) {
                        if (DEBUG) {
                            System.out.println("    compilerState not loaded from saved state");
                        }
                        this.forgetLastBuiltState();
                    }
                    if (!DEBUG) throw throwable;
                    System.out.println("JET2Builder: done startupOnInitialize " + this.getProject());
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                    if (this.savedState != null) break block7;
                    if (!DEBUG) break block8;
                    System.out.println("    compilerState not loaded from saved state");
                }
            }
            this.forgetLastBuiltState();
        }
        if (!DEBUG) return;
        System.out.println("JET2Builder: done startupOnInitialize " + this.getProject());
    }

    private void readSavedState(File savedStateFile) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(savedStateFile));
            Object readObject = ois.readObject();
            if (readObject instanceof SimplifiedCompiler.SaveStateMemento) {
                this.savedState = (Serializable)readObject;
            }
            if (DEBUG) {
                System.out.println("    loaded compilerState from saved state");
                System.out.println(this.savedState.toString());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            JETActivatorWrapper.INSTANCE.log(e);
            savedStateFile.delete();
        }
        catch (ClassNotFoundException e) {
            InternalJET2Platform.logError("Could not deserialize JET2Builder State", e);
        }
    }

    private IProject[] computeReferencedProjects(String[] allReferencedTagLibraryIds) {
        ArrayList<IProject> referencedProjects = new ArrayList<IProject>(allReferencedTagLibraryIds.length);
        int i = 0;
        while (i < allReferencedTagLibraryIds.length) {
            IProject refProject = InternalJET2Platform.getDefault().getProjectDefiningTagLibrary(allReferencedTagLibraryIds[i]);
            if (refProject != null) {
                referencedProjects.add(refProject);
                if (DEBUG) {
                    System.out.println("     depends on:" + refProject);
                }
            }
            ++i;
        }
        IProject[] projects = referencedProjects.toArray(new IProject[referencedProjects.size()]);
        return projects;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IPath location) throws CoreException {
        block14: {
            fileStream = null;
            objStream = null;
            try {
                try {
                    if (this.savedState != null) {
                        file = location.toFile();
                        file.getParentFile().mkdirs();
                        fileStream = new FileOutputStream(file);
                        objStream = new ObjectOutputStream(fileStream);
                        objStream.writeObject(this.savedState);
                    }
                }
                catch (IOException e) {
                    throw new CoreException(InternalJET2Platform.newStatus(4, e.getLocalizedMessage(), e));
                }
            }
            catch (Throwable var6_6) {
                var5_7 = null;
                if (objStream != null) {
                    try {
                        objStream.close();
                    }
                    catch (IOException e) {
                        JETActivatorWrapper.INSTANCE.log(e);
                    }
                }
                if (fileStream == null) throw var6_6;
                try {
                    fileStream.close();
                    throw var6_6;
                }
                catch (IOException e) {
                    JETActivatorWrapper.INSTANCE.log(e);
                }
                throw var6_6;
            }
            {
                var5_8 = null;
                if (objStream == null) break block14;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 93->100)] { 
lbl35:
            // 1 sources

            objStream.close();
            break block14;
lbl37:
            // 1 sources

            catch (IOException e) {
                JETActivatorWrapper.INSTANCE.log(e);
            }
        }
        if (fileStream == null) return;
        try {}
        catch (IOException e) {
            JETActivatorWrapper.INSTANCE.log(e);
            return;
        }
        fileStream.close();
    }

    public String getStateFileName() {
        return "compilerState.tmp";
    }
}

