/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.notation.stylepooling;

import org.eclipse.gmf.runtime.notation.stylepooling.AbstractStyleImmutable;
import org.eclipse.gmf.runtime.notation.stylepooling.StylePoolContainer;

public class FontStyleImplImmutable
extends AbstractStyleImmutable {
    public static int FONT_NONE = 0;
    public static int FONT_BOLD = 1;
    public static int FONT_ITALIC = 2;
    public static int FONT_UNDERLINE = 4;
    public static int FONT_STRIKETHRU = 8;
    protected static StylePoolContainer myStylePool = new StylePoolContainer();
    private String theName;
    private Integer theHeight;
    private Integer theColor;
    private int theFlags;

    private FontStyleImplImmutable() {
    }

    public FontStyleImplImmutable(String name, int height, int color, boolean bStrike, boolean bUnder, boolean bItalic, boolean bBold) {
        this.theName = name;
        this.theHeight = new Integer(height);
        this.theColor = new Integer(color);
        this.theFlags = FontStyleImplImmutable.getFlagsAsInt(bStrike, bUnder, bItalic, bBold);
    }

    public static FontStyleImplImmutable getFontStyle(String sNm, int height, int color, boolean bStrike, boolean bUnder, boolean bItalic, boolean bBold) {
        Integer myKey = new Integer(FontStyleImplImmutable.getFontKey(sNm, height, color, bStrike, bUnder, bItalic, bBold));
        if (myStylePool.containsKey(myKey)) {
            return (FontStyleImplImmutable)myStylePool.get(myKey);
        }
        FontStyleImplImmutable myValue = new FontStyleImplImmutable(sNm, height, color, bStrike, bUnder, bItalic, bBold);
        myStylePool.put(myKey, myValue);
        return myValue;
    }

    public static int getFontKey(String name, int height, int color, boolean bStrike, boolean bUnder, boolean bItalic, boolean bBold) {
        int flags = FontStyleImplImmutable.getFlagsAsInt(bStrike, bUnder, bItalic, bBold);
        StringBuffer theBuffer = new StringBuffer();
        theBuffer.append(name);
        theBuffer.append(":");
        theBuffer.append(height);
        theBuffer.append(":");
        theBuffer.append(color);
        theBuffer.append(":");
        theBuffer.append(flags);
        return theBuffer.toString().hashCode();
    }

    private static int getFlagsAsInt(boolean bStrike, boolean bUnder, boolean bItalic, boolean bBold) {
        int myInt = FONT_NONE;
        if (bStrike) {
            myInt |= FONT_STRIKETHRU;
        }
        if (bUnder) {
            myInt |= FONT_UNDERLINE;
        }
        if (bItalic) {
            myInt |= FONT_ITALIC;
        }
        if (bBold) {
            myInt |= FONT_BOLD;
        }
        return myInt;
    }

    public Integer getColor() {
        return this.theColor;
    }

    public int getTheFlags() {
        return this.theFlags;
    }

    public Integer getHeight() {
        return this.theHeight;
    }

    public String getName() {
        return this.theName;
    }

    public boolean getBold() {
        return (this.getTheFlags() & FONT_BOLD) > 0;
    }

    public boolean getItalic() {
        return (this.getTheFlags() & FONT_ITALIC) > 0;
    }

    public boolean getUnderline() {
        return (this.getTheFlags() & FONT_UNDERLINE) > 0;
    }

    public boolean getStrikethru() {
        return (this.getTheFlags() & FONT_STRIKETHRU) > 0;
    }
}

