/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.tests;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import ordersystem.Address;
import ordersystem.Order;
import ordersystem.OrderSystem;
import ordersystem.OrderSystemFactory;
import ordersystem.Warehouse;
import ordersystem.special.LimitedEditionProduct;
import ordersystem.special.PreferredCustomer;
import ordersystem.special.SpecialFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.tests.CachedTestProvider;
import org.eclipse.emf.validation.tests.Example1;
import org.eclipse.emf.validation.tests.LazyTestModelConstraint;
import org.eclipse.emf.validation.tests.TestBadXmlConfigProvider;
import org.eclipse.emf.validation.tests.TestBase;
import org.eclipse.emf.validation.tests.TestNotification;
import org.osgi.framework.Bundle;

public class FrameworkTest
extends TestBase {
    public static final String CREATE_NEW_TEST_DOCUMENT_PROPERTY = "emf.test.newdocument";
    private static OrderSystem orderSystem = null;

    public FrameworkTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        if (orderSystem == null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URL file = FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.emf.validation.tests"), (IPath)new Path("test.ordersystem"), null);
            URI uri = URI.createURI((String)file.toExternalForm());
            Resource res = resourceSet.getResource(uri, true);
            orderSystem = (OrderSystem)res.getContents().get(0);
            if (Boolean.getBoolean(CREATE_NEW_TEST_DOCUMENT_PROPERTY)) {
                this.createTestDocument(res, orderSystem);
            }
        }
    }

    private void createTestDocument(Resource res, OrderSystem os) throws IOException {
        os.getCustomer().clear();
        os.getWarehouse().clear();
        os.getProduct().clear();
        Example1.create(os);
        res.save(Collections.EMPTY_MAP);
    }

    public void zztest_showContents() {
        Trace.trace((String)">>> Testing showContents");
        this.showRecursive(orderSystem, 0);
    }

    public void test_providerNameSpaces() {
        Trace.trace((String)">>> Testing providerNameSpaces");
        this.orderSystemNameSpace();
    }

    private void orderSystemNameSpace() {
        IStatus[] status;
        Address object = OrderSystemFactory.eINSTANCE.createAddress();
        IStatus[] iStatusArray = status = this.getStatuses(this.batchValidator.validate((EObject)object));
        int n = status.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            IModelConstraint constraint = ((IConstraintStatus)element).getConstraint();
            if (constraint.getDescriptor().getId().equals("org.eclipse.emf.validation.tests.ordersystem.marker")) {
                return;
            }
            ++n2;
        }
        FrameworkTest.fail((String)"ordersystem.marker constraint not found");
    }

    public void test_batchConstraints() {
        Trace.trace((String)">>> Testing batchConstraints");
        Order object = OrderSystemFactory.eINSTANCE.createOrder();
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)object));
        this.assertAllConstraintsPresent("batch", status, "org.eclipse.emf.validation.tests.order.hasContents", "org.eclipse.emf.validation.tests.order.notFilledBeforePlacement");
    }

    public void test_liveConstraints() {
        Trace.trace((String)">>> Testing liveConstraints");
        Order object = OrderSystemFactory.eINSTANCE.createOrder();
        new XMLResourceImpl().getContents().add((Object)object);
        TestNotification event = new TestNotification(object, 1);
        IStatus[] status = this.getStatuses(this.liveValidator.validate((Notification)event));
        this.assertAllConstraintsPresent("live", status, "org.eclipse.emf.validation.tests.order.hasName", "org.eclipse.emf.validation.tests.order.hasOwner");
    }

    public void test_multiLiveConstraints() {
        Trace.trace((String)">>> Testing multiLiveConstraints");
        Order object = OrderSystemFactory.eINSTANCE.createOrder();
        TestNotification event = new TestNotification(object, 1);
        IStatus[] status = this.getStatuses(this.liveValidator.validate(Collections.nCopies(5, event)));
        HashSet<IModelConstraint> evaluatedConstraints = new HashSet<IModelConstraint>();
        IStatus[] iStatusArray = status;
        int n = status.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            IConstraintStatus next = (IConstraintStatus)element;
            evaluatedConstraints.add(next.getConstraint());
            ++n2;
        }
        FrameworkTest.assertEquals((String)"Some constraint was evaluated more than once:", (int)evaluatedConstraints.size(), (int)status.length);
    }

    public void test_lazyConstraintInstantiation() {
        Trace.trace((String)">>> Testing lazyConstraintInstantiation");
        Trace.trace((String)"");
        int currentCount = LazyTestModelConstraint.getInstanceCount();
        Warehouse object = OrderSystemFactory.eINSTANCE.createWarehouse();
        new XMLResourceImpl().getContents().add((Object)object);
        TestNotification notification = new TestNotification(object, 4);
        ConstraintRegistry.getInstance().getDescriptor("org.eclipse.emf.validation.tests", "lazy.marker").setEnabled(false);
        this.liveValidator.validate((Notification)notification);
        FrameworkTest.assertEquals((String)"Constraint prematurely instantiated", (int)currentCount, (int)LazyTestModelConstraint.getInstanceCount());
        ConstraintRegistry.getInstance().getDescriptor("org.eclipse.emf.validation.tests", "lazy.marker").setEnabled(true);
        this.liveValidator.validate((Notification)notification);
        FrameworkTest.assertTrue((String)"Constraint not lazily instantiated", (currentCount < LazyTestModelConstraint.getInstanceCount() ? 1 : 0) != 0);
    }

    public void test_constraintCache() {
        Trace.trace((String)">>> Testing constraintCache");
        Order object = OrderSystemFactory.eINSTANCE.createOrder();
        this.batchValidator.validate((EObject)object);
        this.batchValidator.validate((EObject)object);
        FrameworkTest.assertEquals((String)"Cache was not hit!", (int)1, (int)CachedTestProvider.getInstance().getHitCount(object.eClass()));
    }

    public void test_constraintXmlErrors() {
        Trace.trace((String)">>> Testing constraintXmlErrors");
        Warehouse object = OrderSystemFactory.eINSTANCE.createWarehouse();
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)object));
        this.assertAllConstraintsNotPresent("batch", status, "org.eclipse.emf.validation.tests.bad.constraint.xml");
    }

    public void test_constraintDynamicErrors() {
        String[] ids;
        Trace.trace((String)">>> Testing constraintDynamicErrors");
        Warehouse object = OrderSystemFactory.eINSTANCE.createWarehouse();
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)object));
        String[] stringArray = ids = new String[]{"org.eclipse.emf.validation.tests.bad.constraint.disabled.java", "org.eclipse.emf.validation.tests.bad.constraint.disabled.ocl", "org.eclipse.emf.validation.tests.bad.constraint.disabled.bsh", "org.eclipse.emf.validation.tests.bad.constraint.disabled.runtime"};
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IStatus nextStatus = this.getStatus(status, id);
            if (nextStatus != null) {
                FrameworkTest.assertTrue((boolean)nextStatus.matches(1));
            }
            ++n2;
        }
        status = this.getStatuses(this.batchValidator.validate((EObject)object));
        this.assertAllConstraintsNotPresent("batch", status, ids);
    }

    public void test_providerXmlErrors() {
        Trace.trace((String)">>> Testing providerXmlErrors");
        EAnnotation object = EcoreFactory.eINSTANCE.createEAnnotation();
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)object));
        FrameworkTest.assertNotNull((Object)status);
        FrameworkTest.assertTrue((String)"Provider for ecore namespace prefix was initialized.", (TestBadXmlConfigProvider.getInstance("http://www.eclipse.org/emf/2002/Ecore") == null ? 1 : 0) != 0);
    }

    public void test_providerDynamicErrors() {
        IStatus[] status;
        Trace.trace((String)">>> Testing providerDynamicErrors");
        OrderSystem object = OrderSystemFactory.eINSTANCE.createOrderSystem();
        IStatus[] iStatusArray = status = this.getStatuses(this.batchValidator.validate((EObject)object));
        int n = status.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            IModelConstraint constraint = ((IConstraintStatus)element).getConstraint();
            FrameworkTest.assertFalse((String)"Got constraints from ordersystem namespace prefix provider.", (boolean)constraint.getDescriptor().getId().startsWith("org.eclipse.emf.validation.tests.ordersystem"));
            ++n2;
        }
        FrameworkTest.assertTrue((String)"Provider for ordersystem namespace prefix was not initialized.", (TestBadXmlConfigProvider.getInstance("http:///ordersystem.ecore") != null ? 1 : 0) != 0);
    }

    public void test_providerBatchFilter() {
        Trace.trace((String)">>> Testing providerBatchFilter");
        Object object = OrderSystemFactory.eINSTANCE.createInventoryItem();
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)object));
        this.assertAllConstraintsPresent("batch", status, "org.eclipse.emf.validation.tests.providertarget.batch1");
        this.assertAllConstraintsNotPresent("batch", status, "org.eclipse.emf.validation.tests.providertarget.batch2");
        object = OrderSystemFactory.eINSTANCE.createOrder();
        status = this.getStatuses(this.batchValidator.validate((EObject)object));
        this.assertAllConstraintsNotPresent("batch", status, "org.eclipse.emf.validation.tests.providertarget.batch1");
    }

    public void test_providerLiveFilter() {
        Trace.trace((String)">>> Testing providerLiveFilter");
        Object object = OrderSystemFactory.eINSTANCE.createInventoryItem();
        new XMLResourceImpl().getContents().add(object);
        TestNotification event = new TestNotification((EObject)object, 1);
        IStatus[] status = this.getStatuses(this.liveValidator.validate((Notification)event));
        this.assertAllConstraintsPresent("live", status, "org.eclipse.emf.validation.tests.providertarget.live2");
        this.assertAllConstraintsNotPresent("live", status, "org.eclipse.emf.validation.tests.providertarget.live1");
        object = OrderSystemFactory.eINSTANCE.createOrder();
        event = new TestNotification((EObject)object, 1);
        status = this.getStatuses(this.liveValidator.validate((Notification)event));
        this.assertAllConstraintsNotPresent("live", status, "org.eclipse.emf.validation.tests.providertarget.live2");
        object = OrderSystemFactory.eINSTANCE.createInventoryItem();
        event = new TestNotification((EObject)object, 3);
        status = this.getStatuses(this.liveValidator.validate((Notification)event));
        this.assertAllConstraintsNotPresent("live", status, "org.eclipse.emf.validation.tests.providertarget.live2");
    }

    public void test_multiPackagesPerProvider() {
        Trace.trace((String)">>> Testing multiPackagesPerProvider");
        PreferredCustomer object = SpecialFactory.eINSTANCE.createPreferredCustomer();
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)object));
        this.assertAllConstraintsPresent("batch", status, "org.eclipse.emf.validation.tests.multipackage.test");
    }

    public void test_subclassInOtherPackage() {
        Trace.trace((String)">>> Testing subclassInOtherPackage");
        LimitedEditionProduct object = SpecialFactory.eINSTANCE.createLimitedEditionProduct();
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)object));
        this.assertAllConstraintsPresent("batch", status, "org.eclipse.emf.validation.tests.inheritance.test");
    }

    public void test_qualifiedName() {
        Trace.trace((String)">>> Testing qualifiedName");
        LimitedEditionProduct object = SpecialFactory.eINSTANCE.createLimitedEditionProduct();
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)object));
        this.assertAllConstraintsPresent("batch", status, "org.eclipse.emf.validation.tests.qualifiedName.test");
    }
}

