/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StructuredContentProvider<INPUT>
implements IStructuredContentProvider,
IListener {
    private StructuredViewer viewer;
    private INPUT input;

    public void dispose() {
        if (this.input != null) {
            this.disconnectInput(this.input);
            this.input = null;
        }
    }

    public INPUT getInput() {
        return this.input;
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (StructuredViewer)viewer;
        if (newInput != this.input) {
            if (this.input != null) {
                this.disconnectInput(this.input);
            }
            try {
                this.input = newInput;
                if (this.input != null) {
                    this.connectInput(this.input);
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                this.input = null;
            }
        }
    }

    protected void connectInput(INPUT input) {
    }

    protected void disconnectInput(INPUT input) {
    }

    public void notifyEvent(IEvent event) {
        this.refreshViewer(true);
    }

    protected void refreshViewer(boolean updateLabels) {
        this.refreshElement(null, updateLabels);
    }

    protected void refreshElement(final Object element, final boolean updateLabels) {
        try {
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        StructuredContentProvider.this.refreshSynced(element, updateLabels);
                    }
                    catch (RuntimeException runtimeException) {}
                }
            });
        }
        catch (RuntimeException runtimeException) {}
    }

    protected void refreshSynced(Object element, boolean updateLabels) {
        if (element != null && element != this.input) {
            this.viewer.refresh(element, updateLabels);
        } else {
            this.viewer.refresh(updateLabels);
        }
    }

    protected void updateLabels(final Object element) {
        try {
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        StructuredContentProvider.this.viewer.update(element, null);
                    }
                    catch (RuntimeException runtimeException) {}
                }
            });
        }
        catch (RuntimeException runtimeException) {}
    }

    protected void revealElement(final Object element) {
        try {
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        StructuredContentProvider.this.viewer.reveal(element);
                    }
                    catch (RuntimeException runtimeException) {}
                }
            });
        }
        catch (RuntimeException runtimeException) {}
    }

    protected Display getDisplay() {
        Display display = this.viewer.getControl().getDisplay();
        if (display == null) {
            display = UIUtil.getDisplay();
        }
        return display;
    }
}

