/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.l10n.ValidationMessages;
import org.eclipse.emf.validation.internal.service.IClientContext;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.internal.util.XmlExpressionSelector;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.IClientSelector;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientContext
implements IClientContext {
    private static final String A_DEFAULT = "default";
    private static final String E_ENABLEMENT = "enablement";
    private static final String E_SELECTOR = "selector";
    private final String id;
    private final IClientSelector selector;
    private final boolean isDefault;
    private final Set<String> constraintBindings = new HashSet<String>();
    private final Set<String> categoryBindings = new HashSet<String>();

    public ClientContext(IConfigurationElement config) throws CoreException {
        this.id = this.initializeId(config);
        this.selector = this.initializeSelector(config);
        this.isDefault = this.initializeDefault(config);
    }

    private String initializeId(IConfigurationElement config) throws CoreException {
        String result = config.getAttribute("id");
        if (result == null) {
            CoreException ce = new CoreException((IStatus)new Status(4, EMFModelValidationPlugin.getPluginId(), 110, EMFModelValidationPlugin.getMessage(ValidationMessages.client_noId_ERROR_, config.getDeclaringExtension().getNamespaceIdentifier()), null));
            Trace.throwing(this.getClass(), "initializeId", ce);
            throw ce;
        }
        return result;
    }

    private IClientSelector initializeSelector(IConfigurationElement config) throws CoreException {
        IClientSelector result = null;
        IConfigurationElement[] enablement = config.getChildren(E_ENABLEMENT);
        if (enablement.length > 0) {
            result = this.initializeExpressionSelector(enablement[0]);
        } else {
            IConfigurationElement[] custom = config.getChildren(E_SELECTOR);
            if (custom.length > 0) {
                result = this.initializeCustomSelector(custom[0]);
            }
        }
        if (result == null) {
            CoreException ce = new CoreException((IStatus)new Status(4, EMFModelValidationPlugin.getPluginId(), 111, EMFModelValidationPlugin.getMessage(ValidationMessages.client_noSelector_ERROR_, this.getId(), config.getDeclaringExtension().getNamespaceIdentifier()), null));
            Trace.throwing(this.getClass(), "initializeSelector", ce);
            throw ce;
        }
        return result;
    }

    private IClientSelector initializeExpressionSelector(IConfigurationElement enablement) throws CoreException {
        try {
            return new XmlExpressionSelector(enablement);
        }
        catch (CoreException e) {
            Trace.catching(this.getClass(), "initializeExpressionSelector", e);
            CoreException ce = new CoreException((IStatus)new Status(4, EMFModelValidationPlugin.getPluginId(), 113, EMFModelValidationPlugin.getMessage(ValidationMessages.client_badExpression_ERROR_, this.getId(), enablement.getDeclaringExtension().getNamespaceIdentifier()), (Throwable)e));
            Trace.throwing(this.getClass(), "initializeExpressionSelector", ce);
            throw ce;
        }
    }

    private IClientSelector initializeCustomSelector(IConfigurationElement config) throws CoreException {
        Object result = config.createExecutableExtension("class");
        if (!(result instanceof IClientSelector)) {
            CoreException ce = new CoreException((IStatus)new Status(4, EMFModelValidationPlugin.getPluginId(), 112, EMFModelValidationPlugin.getMessage(ValidationMessages.client_selectorClass_ERROR_, result.getClass().getName(), IClientSelector.class.getName(), this.getId(), config.getDeclaringExtension().getNamespaceIdentifier()), null));
            Trace.throwing(this.getClass(), "initializeCustomSelector", ce);
            throw ce;
        }
        return (IClientSelector)result;
    }

    private boolean initializeDefault(IConfigurationElement config) {
        boolean result = false;
        String string = config.getAttribute(A_DEFAULT);
        if (string != null) {
            result = Boolean.valueOf(string);
        }
        return result;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final IClientSelector getSelector() {
        return this.selector;
    }

    @Override
    public final boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public boolean includes(IModelConstraint constraint) {
        boolean result = false;
        IConstraintDescriptor descriptor = constraint.getDescriptor();
        if (descriptor != null && !(result = this.constraintBindings.contains(descriptor.getId())) && !this.categoryBindings.isEmpty() && (result = this.hasCategoryBinding(descriptor.getCategories()))) {
            this.bindConstraint(descriptor.getId());
        }
        return result;
    }

    private boolean hasCategoryBinding(Collection<Category> categories) {
        boolean result = false;
        Iterator<Category> iter = categories.iterator();
        while (!result && iter.hasNext()) {
            Category category = iter.next();
            result = this.categoryBindings.contains(category.getPath());
            if (result) continue;
            Category ancestor = category.getParent();
            while (ancestor != null && !result) {
                result = this.categoryBindings.contains(ancestor.getPath());
                ancestor = ancestor.getParent();
            }
            if (!result) continue;
            this.bindCategory(category.getPath());
        }
        return result;
    }

    void bindConstraint(String constraintId) {
        this.constraintBindings.add(constraintId);
    }

    void bindCategory(String categoryId) {
        this.categoryBindings.add(categoryId);
    }

    public boolean equals(Object obj) {
        return obj instanceof ClientContext && ((ClientContext)obj).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "ClientContext[" + this.getId() + ']';
    }
}

