/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.conditions.eobjects.structuralfeatures;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.EStructuralFeatureValueGetter;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.IEStructuralFeatureValueGetter;
import org.eclipse.emf.query.handlers.PruneHandler;

public class EObjectReferencerCondition
extends EObjectCondition {
    private EObject referencedEObject;
    private IEStructuralFeatureValueGetter eStructuralFeatureValueGetter;

    public EObjectReferencerCondition(EObject referencedEObject, IEStructuralFeatureValueGetter eStructuralFeatureValueGetter) {
        this(referencedEObject, eStructuralFeatureValueGetter, PruneHandler.NEVER);
    }

    public EObjectReferencerCondition(EObject referencedEObject) {
        this(referencedEObject, EStructuralFeatureValueGetter.getInstance(), PruneHandler.NEVER);
    }

    public EObjectReferencerCondition(EObject referencedEObject, IEStructuralFeatureValueGetter eStructuralFeatureValueGetter, PruneHandler pruneHandler) {
        super(pruneHandler);
        this.referencedEObject = referencedEObject;
        this.eStructuralFeatureValueGetter = eStructuralFeatureValueGetter;
    }

    public boolean isSatisfied(EObject eObject) {
        boolean result = false;
        EReference eReference = null;
        Iterator it = eObject.eClass().getEAllReferences().iterator();
        while (it.hasNext() && !result) {
            eReference = (EReference)it.next();
            if (eReference.isContainment() || eReference.isContainer() || !eObject.eIsSet((EStructuralFeature)eReference)) continue;
            Object value = this.eStructuralFeatureValueGetter.eGet(eObject, (EStructuralFeature)eReference, true);
            result = FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference) ? ((Collection)value).contains(this.referencedEObject) : this.referencedEObject.equals(value);
        }
        return result;
    }
}

